/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.genericrow;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowSerializer;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.readers.GenericRow;

public class GenericRowFileWriter
implements Closeable {
    private final DataOutputStream _offsetStream;
    private final BufferedOutputStream _dataStream;
    private final GenericRowSerializer _serializer;
    private long _nextOffset;

    public GenericRowFileWriter(File offsetFile, File dataFile, List<FieldSpec> fieldSpecs, boolean includeNullFields) throws FileNotFoundException {
        this._offsetStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(offsetFile)));
        this._dataStream = new BufferedOutputStream(new FileOutputStream(dataFile));
        this._serializer = new GenericRowSerializer(fieldSpecs, includeNullFields);
    }

    public void write(GenericRow genericRow) throws IOException {
        this._offsetStream.writeLong(this._nextOffset);
        byte[] bytes = this._serializer.serialize(genericRow);
        this._dataStream.write(bytes);
        this._nextOffset += (long)bytes.length;
    }

    @Override
    public void close() throws IOException {
        this._offsetStream.close();
        this._dataStream.close();
    }
}

