/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.genericrow;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileReader;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileWriter;
import org.apache.pinot.spi.data.FieldSpec;

public class GenericRowFileManager {
    public static final String OFFSET_FILE_NAME = "record.offset";
    public static final String DATA_FILE_NAME = "record.data";
    private final File _offsetFile;
    private final File _dataFile;
    private final List<FieldSpec> _fieldSpecs;
    private final boolean _includeNullFields;
    private final int _numSortFields;
    private GenericRowFileWriter _fileWriter;
    private GenericRowFileReader _fileReader;

    public GenericRowFileManager(File outputDir, List<FieldSpec> fieldSpecs, boolean includeNullFields, int numSortFields) {
        this._offsetFile = new File(outputDir, OFFSET_FILE_NAME);
        this._dataFile = new File(outputDir, DATA_FILE_NAME);
        this._fieldSpecs = fieldSpecs;
        this._includeNullFields = includeNullFields;
        this._numSortFields = numSortFields;
    }

    public List<FieldSpec> getFieldSpecs() {
        return this._fieldSpecs;
    }

    public boolean isIncludeNullFields() {
        return this._includeNullFields;
    }

    public int getNumSortFields() {
        return this._numSortFields;
    }

    public GenericRowFileWriter getFileWriter() throws IOException {
        if (this._fileWriter == null) {
            Preconditions.checkState((!this._offsetFile.exists() ? 1 : 0) != 0, (String)"Record offset file: %s already exists", (Object)this._offsetFile);
            Preconditions.checkState((!this._dataFile.exists() ? 1 : 0) != 0, (String)"Record data file: %s already exists", (Object)this._dataFile);
            this._fileWriter = new GenericRowFileWriter(this._offsetFile, this._dataFile, this._fieldSpecs, this._includeNullFields);
        }
        return this._fileWriter;
    }

    public void closeFileWriter() throws IOException {
        if (this._fileWriter != null) {
            this._fileWriter.close();
            this._fileWriter = null;
        }
    }

    public GenericRowFileReader getFileReader() throws IOException {
        if (this._fileReader == null) {
            Preconditions.checkState((boolean)this._offsetFile.exists(), (String)"Record offset file: %s does not exist", (Object)this._offsetFile);
            Preconditions.checkState((boolean)this._dataFile.exists(), (String)"Record data file: %s does not exist", (Object)this._dataFile);
            this._fileReader = new GenericRowFileReader(this._offsetFile, this._dataFile, this._fieldSpecs, this._includeNullFields, this._numSortFields);
        }
        return this._fileReader;
    }

    public void closeFileReader() throws IOException {
        if (this._fileReader != null) {
            this._fileReader.close();
            this._fileReader = null;
        }
    }

    public void cleanUp() throws IOException {
        this.closeFileWriter();
        this.closeFileReader();
        FileUtils.deleteQuietly((File)this._offsetFile);
        FileUtils.deleteQuietly((File)this._dataFile);
    }
}

