/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.framework;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SegmentConfig {
    public static final int DEFAULT_MAX_NUM_RECORDS_PER_SEGMENT = 5000000;
    private final int _maxNumRecordsPerSegment;
    private final String _segmentNamePrefix;
    private final String _segmentNamePostfix;
    private final String _fixedSegmentName;

    @JsonCreator
    private SegmentConfig(@JsonProperty(value="maxNumRecordsPerSegment", required=true) int maxNumRecordsPerSegment, @JsonProperty(value="segmentNamePrefix") @Nullable String segmentNamePrefix, @JsonProperty(value="segmentNamePostfix") @Nullable String segmentNamePostfix, @JsonProperty(value="fixedSegmentName") @Nullable String fixedSegmentName) {
        Preconditions.checkState((maxNumRecordsPerSegment > 0 ? 1 : 0) != 0, (Object)"Max num records per segment must be > 0");
        this._maxNumRecordsPerSegment = maxNumRecordsPerSegment;
        this._segmentNamePrefix = segmentNamePrefix;
        this._segmentNamePostfix = segmentNamePostfix;
        this._fixedSegmentName = fixedSegmentName;
    }

    public int getMaxNumRecordsPerSegment() {
        return this._maxNumRecordsPerSegment;
    }

    @Nullable
    public String getSegmentNamePrefix() {
        return this._segmentNamePrefix;
    }

    @Nullable
    public String getSegmentNamePostfix() {
        return this._segmentNamePostfix;
    }

    @Nullable
    public String getFixedSegmentName() {
        return this._fixedSegmentName;
    }

    public String toString() {
        return "SegmentConfig{_maxNumRecordsPerSegment=" + this._maxNumRecordsPerSegment + ", _segmentNamePrefix='" + this._segmentNamePrefix + "', _segmentNamePostfix='" + this._segmentNamePostfix + "', _fixedSegmentName='" + this._fixedSegmentName + "'}";
    }

    public static class Builder {
        private int _maxNumRecordsPerSegment = 5000000;
        private String _segmentNamePrefix;
        private String _segmentNamePostfix;
        private String _fixedSegmentName;

        public Builder setMaxNumRecordsPerSegment(int maxNumRecordsPerSegment) {
            this._maxNumRecordsPerSegment = maxNumRecordsPerSegment;
            return this;
        }

        public Builder setSegmentNamePrefix(String segmentNamePrefix) {
            this._segmentNamePrefix = segmentNamePrefix;
            return this;
        }

        public Builder setSegmentNamePostfix(String segmentNamePostfix) {
            this._segmentNamePostfix = segmentNamePostfix;
            return this;
        }

        public Builder setFixedSegmentName(String fixedSegmentName) {
            this._fixedSegmentName = fixedSegmentName;
            return this;
        }

        public SegmentConfig build() {
            Preconditions.checkState((this._maxNumRecordsPerSegment > 0 ? 1 : 0) != 0, (Object)"Max num records per segment must be > 0");
            return new SegmentConfig(this._maxNumRecordsPerSegment, this._segmentNamePrefix, this._segmentNamePostfix, this._fixedSegmentName);
        }
    }
}

