/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.aggregator;

import org.apache.pinot.core.segment.processing.aggregator.MaxValueAggregator;
import org.apache.pinot.core.segment.processing.aggregator.MinValueAggregator;
import org.apache.pinot.core.segment.processing.aggregator.SumValueAggregator;
import org.apache.pinot.core.segment.processing.aggregator.ValueAggregator;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public class ValueAggregatorFactory {
    private ValueAggregatorFactory() {
    }

    public static ValueAggregator getValueAggregator(AggregationFunctionType aggregationType, FieldSpec.DataType dataType) {
        switch (aggregationType) {
            case MIN: {
                return new MinValueAggregator(dataType);
            }
            case MAX: {
                return new MaxValueAggregator(dataType);
            }
            case SUM: {
                return new SumValueAggregator(dataType);
            }
        }
        throw new IllegalStateException("Unsupported aggregation type: " + aggregationType);
    }
}

