/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.utils.idset;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.pinot.core.query.utils.idset.IdSet;
import org.roaringbitmap.longlong.Roaring64NavigableMap;

public class Roaring64NavigableMapIdSet
implements IdSet {
    private final Roaring64NavigableMap _bitmap;

    Roaring64NavigableMapIdSet() {
        this._bitmap = new Roaring64NavigableMap();
    }

    private Roaring64NavigableMapIdSet(Roaring64NavigableMap bitmap) {
        this._bitmap = bitmap;
    }

    Roaring64NavigableMap getBitmap() {
        return this._bitmap;
    }

    @Override
    public IdSet.Type getType() {
        return IdSet.Type.ROARING_64_NAVIGABLE_MAP;
    }

    @Override
    public void add(long id) {
        this._bitmap.addLong(id);
    }

    @Override
    public boolean contains(long id) {
        return this._bitmap.contains(id);
    }

    @Override
    public int getSerializedSizeInBytes() {
        return 1 + (int)this._bitmap.serializedSizeInBytes();
    }

    @Override
    public byte[] toBytes() throws IOException {
        int numBytes = 1 + (int)this._bitmap.serializedSizeInBytes();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(numBytes);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.write(IdSet.Type.ROARING_64_NAVIGABLE_MAP.getId());
        this._bitmap.serialize((DataOutput)dataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    static Roaring64NavigableMapIdSet fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
        Preconditions.checkArgument((boolean)byteBuffer.hasArray(), (Object)"Cannot deserialize Roaring64NavigableMap from ByteBuffer not backed by an accessible byte array");
        Roaring64NavigableMap roaring64NavigableMap = new Roaring64NavigableMap();
        roaring64NavigableMap.deserialize((DataInput)new DataInputStream(new ByteArrayInputStream(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining())));
        return new Roaring64NavigableMapIdSet(roaring64NavigableMap);
    }

    public int hashCode() {
        return this._bitmap.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Roaring64NavigableMapIdSet)) {
            return false;
        }
        Roaring64NavigableMapIdSet that = (Roaring64NavigableMapIdSet)o;
        return this._bitmap.equals((Object)that._bitmap);
    }
}

