/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.utils.idset;

import com.google.common.base.Preconditions;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.pinot.core.query.utils.idset.IdSet;
import org.apache.pinot.spi.data.FieldSpec;

public class BloomFilterIdSet
implements IdSet {
    private final FunnelType _funnelType;
    private final BloomFilter _bloomFilter;
    private final int _serializedSizeInBytes;

    BloomFilterIdSet(FieldSpec.DataType dataType, int expectedInsertions, double fpp) {
        switch (dataType) {
            case INT: 
            case FLOAT: {
                this._funnelType = FunnelType.INT;
                this._bloomFilter = BloomFilter.create((Funnel)Funnels.integerFunnel(), (int)expectedInsertions, (double)fpp);
                break;
            }
            case LONG: 
            case DOUBLE: {
                this._funnelType = FunnelType.LONG;
                this._bloomFilter = BloomFilter.create((Funnel)Funnels.longFunnel(), (int)expectedInsertions, (double)fpp);
                break;
            }
            case STRING: {
                this._funnelType = FunnelType.STRING;
                this._bloomFilter = BloomFilter.create((Funnel)Funnels.unencodedCharsFunnel(), (int)expectedInsertions, (double)fpp);
                break;
            }
            case BYTES: {
                this._funnelType = FunnelType.BYTES;
                this._bloomFilter = BloomFilter.create((Funnel)Funnels.byteArrayFunnel(), (int)expectedInsertions, (double)fpp);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported data type: " + dataType);
            }
        }
        long numBitsInBloomFilter = (long)((double)(-expectedInsertions) * Math.log(fpp) / (Math.log(2.0) * Math.log(2.0)));
        this._serializedSizeInBytes = 8 + (int)((numBitsInBloomFilter + 64L - 1L) / 64L) * 8;
    }

    private BloomFilterIdSet(FunnelType funnelType, BloomFilter bloomFilter, int serializedSizeInBytes) {
        this._funnelType = funnelType;
        this._bloomFilter = bloomFilter;
        this._serializedSizeInBytes = serializedSizeInBytes;
    }

    BloomFilter getBloomFilter() {
        return this._bloomFilter;
    }

    @Override
    public IdSet.Type getType() {
        return IdSet.Type.BLOOM_FILTER;
    }

    @Override
    public void add(int id) {
        this._bloomFilter.put((Object)id);
    }

    @Override
    public void add(long id) {
        this._bloomFilter.put((Object)id);
    }

    @Override
    public void add(float id) {
        this._bloomFilter.put((Object)Float.floatToRawIntBits(id));
    }

    @Override
    public void add(double id) {
        this._bloomFilter.put((Object)Double.doubleToRawLongBits(id));
    }

    @Override
    public void add(String id) {
        this._bloomFilter.put((Object)id);
    }

    @Override
    public void add(byte[] id) {
        this._bloomFilter.put((Object)id);
    }

    @Override
    public boolean contains(int id) {
        return this._bloomFilter.mightContain((Object)id);
    }

    @Override
    public boolean contains(long id) {
        return this._bloomFilter.mightContain((Object)id);
    }

    @Override
    public boolean contains(float id) {
        return this._bloomFilter.mightContain((Object)Float.floatToRawIntBits(id));
    }

    @Override
    public boolean contains(double id) {
        return this._bloomFilter.mightContain((Object)Double.doubleToRawLongBits(id));
    }

    @Override
    public boolean contains(String id) {
        return this._bloomFilter.mightContain((Object)id);
    }

    @Override
    public boolean contains(byte[] id) {
        return this._bloomFilter.mightContain((Object)id);
    }

    @Override
    public int getSerializedSizeInBytes() {
        return this._serializedSizeInBytes;
    }

    @Override
    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this._serializedSizeInBytes);
        byteArrayOutputStream.write(IdSet.Type.BLOOM_FILTER.getId());
        byteArrayOutputStream.write(this._funnelType.getId());
        this._bloomFilter.writeTo((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    static BloomFilterIdSet fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
        Funnel funnel;
        FunnelType funnelType;
        Preconditions.checkArgument((boolean)byteBuffer.hasArray(), (Object)"Cannot deserialize BloomFilter from ByteBuffer not backed by an accessible byte array");
        int serializedSizeInBytes = 1 + byteBuffer.remaining();
        byte funnelTypeId = byteBuffer.get();
        switch (funnelTypeId) {
            case 0: {
                funnelType = FunnelType.INT;
                funnel = Funnels.integerFunnel();
                break;
            }
            case 1: {
                funnelType = FunnelType.LONG;
                funnel = Funnels.longFunnel();
                break;
            }
            case 2: {
                funnelType = FunnelType.STRING;
                funnel = Funnels.unencodedCharsFunnel();
                break;
            }
            case 3: {
                funnelType = FunnelType.BYTES;
                funnel = Funnels.byteArrayFunnel();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        BloomFilter bloomFilter = BloomFilter.readFrom((InputStream)new ByteArrayInputStream(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining()), (Funnel)funnel);
        return new BloomFilterIdSet(funnelType, bloomFilter, serializedSizeInBytes);
    }

    public int hashCode() {
        return 31 * this._funnelType.hashCode() + this._bloomFilter.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BloomFilterIdSet)) {
            return false;
        }
        BloomFilterIdSet that = (BloomFilterIdSet)o;
        return this._funnelType == that._funnelType && this._bloomFilter.equals((Object)that._bloomFilter);
    }

    private static enum FunnelType {
        INT(0),
        LONG(1),
        STRING(2),
        BYTES(3);

        private final byte _id;

        private FunnelType(byte id) {
            this._id = id;
        }

        public byte getId() {
            return this._id;
        }
    }
}

