/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.scheduler.fcfs;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.concurrent.atomic.LongAccumulator;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.metrics.ServerQueryPhase;
import org.apache.pinot.core.query.executor.QueryExecutor;
import org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.core.query.scheduler.QueryScheduler;
import org.apache.pinot.core.query.scheduler.resources.QueryExecutorService;
import org.apache.pinot.core.query.scheduler.resources.UnboundedResourceManager;
import org.apache.pinot.spi.env.PinotConfiguration;

public class FCFSQueryScheduler
extends QueryScheduler {
    public FCFSQueryScheduler(PinotConfiguration config, QueryExecutor queryExecutor, ServerMetrics serverMetrics, LongAccumulator latestQueryTime) {
        super(config, queryExecutor, new UnboundedResourceManager(config), serverMetrics, latestQueryTime);
    }

    @Override
    public ListenableFuture<byte[]> submit(ServerQueryRequest queryRequest) {
        if (!this._isRunning) {
            return this.immediateErrorResponse(queryRequest, QueryException.SERVER_SCHEDULER_DOWN_ERROR);
        }
        queryRequest.getTimerContext().startNewPhaseTimer(ServerQueryPhase.SCHEDULER_WAIT);
        QueryExecutorService queryExecutorService = this._resourceManager.getExecutorService(queryRequest, null);
        ListenableFutureTask<byte[]> queryTask = this.createQueryFutureTask(queryRequest, queryExecutorService);
        this._resourceManager.getQueryRunners().submit(queryTask);
        return queryTask;
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
    }

    @Override
    public String name() {
        return "FCFS";
    }
}

