/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce.filter;

import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.core.query.reduce.filter.AndRowMatcher;
import org.apache.pinot.core.query.reduce.filter.NotRowMatcher;
import org.apache.pinot.core.query.reduce.filter.OrRowMatcher;
import org.apache.pinot.core.query.reduce.filter.PredicateRowMatcher;
import org.apache.pinot.core.query.reduce.filter.RowMatcher;
import org.apache.pinot.core.query.reduce.filter.ValueExtractorFactory;

public class RowMatcherFactory {
    private RowMatcherFactory() {
    }

    public static RowMatcher getRowMatcher(FilterContext filter, ValueExtractorFactory valueExtractorFactory, boolean nullHandlingEnabled) {
        switch (filter.getType()) {
            case AND: {
                return new AndRowMatcher(filter.getChildren(), valueExtractorFactory, nullHandlingEnabled);
            }
            case OR: {
                return new OrRowMatcher(filter.getChildren(), valueExtractorFactory, nullHandlingEnabled);
            }
            case NOT: {
                assert (filter.getChildren().size() == 1);
                return new NotRowMatcher((FilterContext)filter.getChildren().get(0), valueExtractorFactory, nullHandlingEnabled);
            }
            case PREDICATE: {
                return new PredicateRowMatcher(filter.getPredicate(), valueExtractorFactory.getValueExtractor(filter.getPredicate().getLhs()), nullHandlingEnabled);
            }
        }
        throw new IllegalStateException();
    }
}

