/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctAggregationFunction;
import org.apache.pinot.core.query.reduce.AggregationDataTableReducer;
import org.apache.pinot.core.query.reduce.DataTableReducer;
import org.apache.pinot.core.query.reduce.DistinctDataTableReducer;
import org.apache.pinot.core.query.reduce.ExplainPlanDataTableReducer;
import org.apache.pinot.core.query.reduce.GroupByDataTableReducer;
import org.apache.pinot.core.query.reduce.SelectionDataTableReducer;
import org.apache.pinot.core.query.reduce.SelectionOnlyStreamingReducer;
import org.apache.pinot.core.query.reduce.StreamingReducer;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextUtils;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public final class ResultReducerFactory {
    private ResultReducerFactory() {
    }

    public static DataTableReducer getResultReducer(QueryContext queryContext) {
        if (queryContext.isExplain()) {
            return new ExplainPlanDataTableReducer(queryContext);
        }
        AggregationFunction[] aggregationFunctions = queryContext.getAggregationFunctions();
        if (aggregationFunctions == null) {
            return new SelectionDataTableReducer(queryContext);
        }
        if (queryContext.getGroupByExpressions() == null) {
            if (aggregationFunctions.length == 1 && aggregationFunctions[0].getType() == AggregationFunctionType.DISTINCT) {
                return new DistinctDataTableReducer((DistinctAggregationFunction)aggregationFunctions[0], queryContext);
            }
            return new AggregationDataTableReducer(queryContext);
        }
        return new GroupByDataTableReducer(queryContext);
    }

    public static StreamingReducer getStreamingReducer(QueryContext queryContext) {
        if (!QueryContextUtils.isSelectionQuery(queryContext) || queryContext.getOrderByExpressions() != null) {
            throw new UnsupportedOperationException("Only selection queries are supported");
        }
        return new SelectionOnlyStreamingReducer(queryContext);
    }
}

