/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.query.reduce.BaseGapfillProcessor;
import org.apache.pinot.core.query.reduce.CountGapfillProcessor;
import org.apache.pinot.core.query.reduce.GapfillProcessor;
import org.apache.pinot.core.query.reduce.SumAvgGapfillProcessor;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.util.GapfillUtils;

public final class GapfillProcessorFactory {
    private GapfillProcessorFactory() {
    }

    public static BaseGapfillProcessor getGapfillProcessor(QueryContext queryContext, GapfillUtils.GapfillType gapfillType) {
        if (gapfillType == GapfillUtils.GapfillType.AGGREGATE_GAP_FILL_AGGREGATE) {
            if (queryContext.getSelectExpressions().size() == 2 && queryContext.getSelectExpressions().get(0).getType() == ExpressionContext.Type.IDENTIFIER && queryContext.getSelectExpressions().get(1).getType() == ExpressionContext.Type.FUNCTION && queryContext.getSelectExpressions().get(1).getFunction().getFunctionName().equals("count")) {
                return new CountGapfillProcessor(queryContext, gapfillType);
            }
            int sumOrAvg = 0;
            int groupBy = 0;
            for (ExpressionContext expressionContext : queryContext.getSelectExpressions()) {
                if (expressionContext.getType() == ExpressionContext.Type.FUNCTION && (expressionContext.getFunction().getFunctionName().equals("sum") || expressionContext.getFunction().getFunctionName().equals("avg"))) {
                    ++sumOrAvg;
                    continue;
                }
                if (expressionContext.getType() != ExpressionContext.Type.IDENTIFIER) continue;
                ++groupBy;
            }
            if (groupBy == 1 && sumOrAvg + groupBy == queryContext.getSelectExpressions().size()) {
                return new SumAvgGapfillProcessor(queryContext, gapfillType);
            }
        }
        return new GapfillProcessor(queryContext, gapfillType);
    }
}

