/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.query.reduce.filter.ColumnValueExtractor;
import org.apache.pinot.core.query.reduce.filter.LiteralValueExtractor;
import org.apache.pinot.core.query.reduce.filter.RowMatcher;
import org.apache.pinot.core.query.reduce.filter.RowMatcherFactory;
import org.apache.pinot.core.query.reduce.filter.ValueExtractor;
import org.apache.pinot.core.query.reduce.filter.ValueExtractorFactory;
import org.apache.pinot.core.util.GapfillUtils;

public class GapfillFilterHandler
implements ValueExtractorFactory {
    private final RowMatcher _rowMatcher;
    private final DataSchema _dataSchema;
    private final Map<String, Integer> _indexes;

    public GapfillFilterHandler(FilterContext filter, DataSchema dataSchema) {
        this._dataSchema = dataSchema;
        this._indexes = new HashMap<String, Integer>();
        for (int i = 0; i < this._dataSchema.size(); ++i) {
            this._indexes.put(this._dataSchema.getColumnName(i), i);
        }
        this._rowMatcher = RowMatcherFactory.getRowMatcher(filter, this, false);
    }

    public boolean isMatch(Object[] row) {
        return this._rowMatcher.isMatch(row);
    }

    @Override
    public ValueExtractor getValueExtractor(ExpressionContext expression) {
        if ((expression = GapfillUtils.stripGapfill(expression)).getType() == ExpressionContext.Type.LITERAL) {
            return new LiteralValueExtractor(expression.getLiteralString());
        }
        if (expression.getType() == ExpressionContext.Type.IDENTIFIER) {
            return new ColumnValueExtractor(this._indexes.get(expression.getIdentifier()), this._dataSchema);
        }
        return new ColumnValueExtractor(this._indexes.get(expression.getFunction().toString()), this._dataSchema);
    }
}

