/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.query.aggregation.function.DistinctAggregationFunction;
import org.apache.pinot.core.query.distinct.DistinctTable;
import org.apache.pinot.core.query.reduce.DataTableReducer;
import org.apache.pinot.core.query.reduce.DataTableReducerContext;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.roaringbitmap.RoaringBitmap;

public class DistinctDataTableReducer
implements DataTableReducer {
    private final DistinctAggregationFunction _distinctAggregationFunction;
    private final QueryContext _queryContext;

    DistinctDataTableReducer(DistinctAggregationFunction distinctAggregationFunction, QueryContext queryContext) {
        this._distinctAggregationFunction = distinctAggregationFunction;
        this._queryContext = queryContext;
    }

    @Override
    public void reduceAndSetResults(String tableName, DataSchema dataSchema, Map<ServerRoutingInstance, DataTable> dataTableMap, BrokerResponseNative brokerResponseNative, DataTableReducerContext reducerContext, BrokerMetrics brokerMetrics) {
        ArrayList<DistinctTable> nonEmptyDistinctTables = new ArrayList<DistinctTable>(dataTableMap.size());
        for (DataTable dataTable : dataTableMap.values()) {
            dataSchema = dataTable.getDataSchema();
            int numColumns = dataSchema.size();
            if (numColumns == 1 && dataSchema.getColumnDataType(0) == DataSchema.ColumnDataType.OBJECT) {
                DataTable.CustomObject customObject = dataTable.getCustomObject(0, 0);
                assert (customObject != null);
                DistinctTable distinctTable = (DistinctTable)ObjectSerDeUtils.deserialize(customObject);
                if (distinctTable.isEmpty()) continue;
                nonEmptyDistinctTables.add(distinctTable);
                continue;
            }
            int numRows = dataTable.getNumberOfRows();
            if (numRows <= 0) continue;
            ArrayList<Record> records = new ArrayList<Record>(numRows);
            if (this._queryContext.isNullHandlingEnabled()) {
                RoaringBitmap[] nullBitmaps = new RoaringBitmap[numColumns];
                for (int coldId = 0; coldId < numColumns; ++coldId) {
                    nullBitmaps[coldId] = dataTable.getNullRowIds(coldId);
                }
                for (int rowId = 0; rowId < numRows; ++rowId) {
                    records.add(new Record(SelectionOperatorUtils.extractRowFromDataTableWithNullHandling(dataTable, rowId, nullBitmaps)));
                }
            } else {
                for (int rowId = 0; rowId < numRows; ++rowId) {
                    records.add(new Record(SelectionOperatorUtils.extractRowFromDataTable(dataTable, rowId)));
                }
            }
            nonEmptyDistinctTables.add(new DistinctTable(dataSchema, records));
        }
        if (nonEmptyDistinctTables.isEmpty()) {
            String[] columns = this._distinctAggregationFunction.getColumns();
            int numColumns = columns.length;
            Object[] columnDataTypes = new DataSchema.ColumnDataType[numColumns];
            Arrays.fill(columnDataTypes, DataSchema.ColumnDataType.STRING);
            brokerResponseNative.setResultTable(new ResultTable(new DataSchema(columns, (DataSchema.ColumnDataType[])columnDataTypes), Collections.emptyList()));
        } else {
            DistinctTable mainDistinctTable = new DistinctTable(((DistinctTable)nonEmptyDistinctTables.get(0)).getDataSchema(), this._distinctAggregationFunction.getOrderByExpressions(), this._distinctAggregationFunction.getLimit(), this._queryContext.isNullHandlingEnabled());
            for (DistinctTable distinctTable : nonEmptyDistinctTables) {
                mainDistinctTable.mergeTable(distinctTable);
            }
            brokerResponseNative.setResultTable(this.reduceToResultTable(mainDistinctTable));
        }
    }

    private ResultTable reduceToResultTable(DistinctTable distinctTable) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(distinctTable.size());
        DataSchema dataSchema = distinctTable.getDataSchema();
        DataSchema.ColumnDataType[] columnDataTypes = dataSchema.getColumnDataTypes();
        int numColumns = columnDataTypes.length;
        Iterator<Record> iterator = distinctTable.getFinalResult();
        while (iterator.hasNext()) {
            Object[] values = iterator.next().getValues();
            Object[] row = new Object[numColumns];
            for (int i = 0; i < numColumns; ++i) {
                Object value = values[i];
                if (value == null) continue;
                row[i] = columnDataTypes[i].convertAndFormat(value);
            }
            rows.add(row);
        }
        return new ResultTable(dataSchema, rows);
    }
}

