/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.data.table.Key;
import org.apache.pinot.core.query.reduce.BaseGapfillProcessor;
import org.apache.pinot.core.query.reduce.GapfillFilterHandler;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.util.GapfillUtils;

class CountGapfillProcessor
extends BaseGapfillProcessor {
    protected final Set<Key> _filteredSet = new HashSet<Key>();

    CountGapfillProcessor(QueryContext queryContext, GapfillUtils.GapfillType gapfillType) {
        super(queryContext, gapfillType);
    }

    @Override
    protected List<Object[]> gapFillAndAggregate(List<Object[]> rows, DataSchema dataSchema, DataSchema resultTableSchema) {
        Object[] row;
        long rowTimestamp;
        int bucketIndex;
        int rowIndex;
        DataSchema.ColumnDataType timeColumnDataType = resultTableSchema.getColumnDataTypes()[0];
        if (this._queryContext.getSubquery() != null && this._queryContext.getFilter() != null) {
            this._postGapfillFilterHandler = new GapfillFilterHandler(this._queryContext.getFilter(), dataSchema);
        }
        if (this._queryContext.getHavingFilter() != null) {
            this._postAggregateHavingFilterHandler = new GapfillFilterHandler(this._queryContext.getHavingFilter(), resultTableSchema);
        }
        for (rowIndex = 0; rowIndex < rows.size() && (bucketIndex = this.findGapfillBucketIndex(rowTimestamp = this.extractTimeColumn(row = rows.get(rowIndex), timeColumnDataType))) < 0; ++rowIndex) {
            this.updateCounter(row);
        }
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        long aggregatedCount = 0L;
        for (long time = this._startMs; time < this._endMs; time += this._gapfillTimeBucketSize) {
            Object[] row2;
            long rowTimestamp2;
            while (rowIndex < rows.size() && (rowTimestamp2 = this.extractTimeColumn(row2 = rows.get(rowIndex), timeColumnDataType)) == time) {
                this.updateCounter(row2);
                ++rowIndex;
            }
            int timeBucketIndex = this.findGapfillBucketIndex(time);
            if ((aggregatedCount += this._count) <= 0L || (timeBucketIndex + 1) % this._aggregationSize != 0) continue;
            Object[] aggregatedRow = new Object[this._queryContext.getSelectExpressions().size()];
            long aggregationTimeBucketTimestamp = time - (long)(this._aggregationSize - 1) * this._gapfillTimeBucketSize;
            aggregatedRow[0] = timeColumnDataType == DataSchema.ColumnDataType.LONG ? Long.valueOf(aggregationTimeBucketTimestamp) : this._dateTimeFormatter.fromMillisToFormat(aggregationTimeBucketTimestamp);
            aggregatedRow[1] = aggregatedCount;
            aggregatedCount = 0L;
            if (this._postAggregateHavingFilterHandler == null || this._postAggregateHavingFilterHandler.isMatch(aggregatedRow)) {
                result.add(aggregatedRow);
            }
            if (result.size() < this._limitForAggregatedResult) continue;
            return result;
        }
        return result;
    }

    private long extractTimeColumn(Object[] row, DataSchema.ColumnDataType columnDataType) {
        if (columnDataType == DataSchema.ColumnDataType.LONG) {
            return (Long)row[this._timeBucketColumnIndex];
        }
        return this._dateTimeFormatter.fromFormatToMillis((String)row[this._timeBucketColumnIndex]);
    }

    private void updateCounter(Object[] row) {
        boolean isFilter;
        Key key = this.constructGroupKeys(row);
        boolean bl = isFilter = this._postGapfillFilterHandler == null || this._postGapfillFilterHandler.isMatch(row);
        if (this._filteredSet.contains(key) != isFilter) {
            this._count = isFilter ? ++this._count : --this._count;
        }
        if (isFilter) {
            this._filteredSet.add(key);
        } else {
            this._filteredSet.remove(key);
        }
    }
}

