/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.reduce.DataTableReducer;
import org.apache.pinot.core.query.reduce.DataTableReducerContext;
import org.apache.pinot.core.query.reduce.PostAggregationHandler;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.roaringbitmap.RoaringBitmap;

public class AggregationDataTableReducer
implements DataTableReducer {
    private final QueryContext _queryContext;
    private final AggregationFunction[] _aggregationFunctions;

    AggregationDataTableReducer(QueryContext queryContext) {
        this._queryContext = queryContext;
        this._aggregationFunctions = queryContext.getAggregationFunctions();
    }

    @Override
    public void reduceAndSetResults(String tableName, DataSchema dataSchema, Map<ServerRoutingInstance, DataTable> dataTableMap, BrokerResponseNative brokerResponseNative, DataTableReducerContext reducerContext, BrokerMetrics brokerMetrics) {
        assert (dataSchema != null);
        if (dataTableMap.isEmpty()) {
            DataSchema resultTableSchema = new PostAggregationHandler(this._queryContext, this.getPrePostAggregationDataSchema()).getResultDataSchema();
            brokerResponseNative.setResultTable(new ResultTable(resultTableSchema, Collections.emptyList()));
            return;
        }
        if (!this._queryContext.isServerReturnFinalResult()) {
            this.reduceWithIntermediateResult(dataSchema, dataTableMap.values(), brokerResponseNative);
        } else {
            Preconditions.checkState((dataTableMap.size() == 1 ? 1 : 0) != 0, (Object)"Cannot merge final results from multiple servers");
            this.reduceWithFinalResult(dataSchema, dataTableMap.values().iterator().next(), brokerResponseNative);
        }
    }

    private void reduceWithIntermediateResult(DataSchema dataSchema, Collection<DataTable> dataTables, BrokerResponseNative brokerResponseNative) {
        int numAggregationFunctions = this._aggregationFunctions.length;
        Object[] intermediateResults = new Object[numAggregationFunctions];
        for (DataTable dataTable : dataTables) {
            for (int i = 0; i < numAggregationFunctions; ++i) {
                RoaringBitmap nullBitmap;
                DataSchema.ColumnDataType columnDataType = dataSchema.getColumnDataType(i);
                Object intermediateResultToMerge = this._queryContext.isNullHandlingEnabled() ? ((nullBitmap = dataTable.getNullRowIds(i)) != null && nullBitmap.contains(0) ? null : AggregationFunctionUtils.getIntermediateResult(dataTable, columnDataType, 0, i)) : AggregationFunctionUtils.getIntermediateResult(dataTable, columnDataType, 0, i);
                Object mergedIntermediateResult = intermediateResults[i];
                intermediateResults[i] = mergedIntermediateResult == null ? intermediateResultToMerge : this._aggregationFunctions[i].merge(mergedIntermediateResult, intermediateResultToMerge);
            }
        }
        Object[] finalResults = new Object[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            AggregationFunction aggregationFunction = this._aggregationFunctions[i];
            Object result = aggregationFunction.extractFinalResult(intermediateResults[i]);
            finalResults[i] = result == null ? null : aggregationFunction.getFinalResultColumnType().convert(result);
        }
        brokerResponseNative.setResultTable(this.reduceToResultTable(finalResults));
    }

    private void reduceWithFinalResult(DataSchema dataSchema, DataTable dataTable, BrokerResponseNative brokerResponseNative) {
        int numAggregationFunctions = this._aggregationFunctions.length;
        Object[] finalResults = new Object[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            DataSchema.ColumnDataType columnDataType = dataSchema.getColumnDataType(i);
            if (this._queryContext.isNullHandlingEnabled()) {
                RoaringBitmap nullBitmap = dataTable.getNullRowIds(i);
                if (nullBitmap != null && nullBitmap.contains(0)) {
                    finalResults[i] = null;
                    continue;
                }
                finalResults[i] = AggregationFunctionUtils.getConvertedFinalResult(dataTable, columnDataType, 0, i);
                continue;
            }
            finalResults[i] = AggregationFunctionUtils.getConvertedFinalResult(dataTable, columnDataType, 0, i);
        }
        brokerResponseNative.setResultTable(this.reduceToResultTable(finalResults));
    }

    private ResultTable reduceToResultTable(Object[] finalResults) {
        PostAggregationHandler postAggregationHandler = new PostAggregationHandler(this._queryContext, this.getPrePostAggregationDataSchema());
        DataSchema dataSchema = postAggregationHandler.getResultDataSchema();
        Object[] row = postAggregationHandler.getResult(finalResults);
        DataSchema.ColumnDataType[] columnDataTypes = dataSchema.getColumnDataTypes();
        int numColumns = columnDataTypes.length;
        for (int i = 0; i < numColumns; ++i) {
            row[i] = columnDataTypes[i].format(row[i]);
        }
        return new ResultTable(dataSchema, Collections.singletonList(row));
    }

    private DataSchema getPrePostAggregationDataSchema() {
        int numAggregationFunctions = this._aggregationFunctions.length;
        String[] columnNames = new String[numAggregationFunctions];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            AggregationFunction aggregationFunction = this._aggregationFunctions[i];
            columnNames[i] = aggregationFunction.getResultColumnName();
            columnDataTypes[i] = aggregationFunction.getFinalResultColumnType();
        }
        return new DataSchema(columnNames, columnDataTypes);
    }
}

