/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.pruner;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.core.query.pruner.ColumnValueSegmentPruner;
import org.apache.pinot.core.query.pruner.SegmentPruner;
import org.apache.pinot.core.query.pruner.SelectionQuerySegmentPruner;
import org.apache.pinot.spi.env.PinotConfiguration;

public class SegmentPrunerProvider {
    private static final Map<String, Class<? extends SegmentPruner>> PRUNER_MAP = new HashMap<String, Class<? extends SegmentPruner>>();
    public static final String COLUMN_VALUE_SEGMENT_PRUNER_NAME = "columnvaluesegmentpruner";
    public static final String SELECTION_QUERY_SEGMENT_PRUNER_NAME = "selectionquerysegmentpruner";

    private SegmentPrunerProvider() {
    }

    @Nullable
    public static SegmentPruner getSegmentPruner(String prunerClassName, PinotConfiguration segmentPrunerConfig) {
        try {
            Class<? extends SegmentPruner> cls = PRUNER_MAP.get(prunerClassName.toLowerCase());
            if (cls != null) {
                SegmentPruner segmentPruner = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                segmentPruner.init(segmentPrunerConfig);
                return segmentPruner;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Not support SegmentPruner type with - " + prunerClassName, ex);
        }
        return null;
    }

    static {
        PRUNER_MAP.put(COLUMN_VALUE_SEGMENT_PRUNER_NAME, ColumnValueSegmentPruner.class);
        PRUNER_MAP.put(SELECTION_QUERY_SEGMENT_PRUNER_NAME, SelectionQuerySegmentPruner.class);
    }
}

