/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.prefetch;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.core.query.prefetch.FetchPlanner;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.FetchContext;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.store.ColumnIndexType;

public class DefaultFetchPlanner
implements FetchPlanner {
    @Override
    public FetchContext planFetchForPruning(IndexSegment indexSegment, QueryContext queryContext) {
        HashSet<String> eqInColumns = new HashSet<String>();
        DefaultFetchPlanner.extractEqInColumns(Objects.requireNonNull(queryContext.getFilter()), eqInColumns);
        HashMap<String, List<ColumnIndexType>> columnToIndexList = new HashMap<String, List<ColumnIndexType>>();
        for (String column : eqInColumns) {
            DataSource dataSource = indexSegment.getDataSource(column);
            if (dataSource.getBloomFilter() == null) continue;
            columnToIndexList.put(column, Collections.singletonList(ColumnIndexType.BLOOM_FILTER));
        }
        return new FetchContext(UUID.randomUUID(), indexSegment.getSegmentName(), columnToIndexList);
    }

    protected static void extractEqInColumns(FilterContext filter, Set<String> eqInColumns) {
        switch (filter.getType()) {
            case AND: 
            case OR: {
                for (FilterContext child : filter.getChildren()) {
                    DefaultFetchPlanner.extractEqInColumns(child, eqInColumns);
                }
                break;
            }
            case NOT: {
                break;
            }
            case PREDICATE: {
                Predicate predicate = filter.getPredicate();
                ExpressionContext lhs = predicate.getLhs();
                if (lhs.getType() != ExpressionContext.Type.IDENTIFIER) break;
                String column = lhs.getIdentifier();
                Predicate.Type predicateType = predicate.getType();
                if (predicateType != Predicate.Type.EQ && predicateType != Predicate.Type.IN) break;
                eqInColumns.add(column);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown filter type: " + filter.getType());
            }
        }
    }

    @Override
    public FetchContext planFetchForProcessing(IndexSegment indexSegment, QueryContext queryContext) {
        return new FetchContext(UUID.randomUUID(), indexSegment.getSegmentName(), this.getColumns(indexSegment, queryContext));
    }

    private Set<String> getColumns(IndexSegment indexSegment, QueryContext queryContext) {
        List<ExpressionContext> selectExpressions = queryContext.getSelectExpressions();
        if (selectExpressions.size() == 1 && "*".equals(selectExpressions.get(0).getIdentifier())) {
            return indexSegment.getPhysicalColumnNames();
        }
        return queryContext.getColumns();
    }
}

