/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.executor.sql;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.helix.ExtraInstanceConfig;
import org.apache.pinot.common.minion.MinionClient;
import org.apache.pinot.common.response.BrokerResponse;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.helix.LeadControllerUtils;
import org.apache.pinot.spi.config.task.AdhocTaskConfig;
import org.apache.pinot.sql.parsers.SqlNodeAndOptions;
import org.apache.pinot.sql.parsers.dml.DataManipulationStatement;
import org.apache.pinot.sql.parsers.dml.DataManipulationStatementParser;

public class SqlQueryExecutor {
    private final String _controllerUrl;
    private final HelixManager _helixManager;

    public SqlQueryExecutor(HelixManager helixManager) {
        this._helixManager = helixManager;
        this._controllerUrl = null;
    }

    public SqlQueryExecutor(String controllerUrl) {
        this._controllerUrl = controllerUrl;
        this._helixManager = null;
    }

    private static String getControllerBaseUrl(HelixManager helixManager) {
        PropertyKey.Builder keyBuilder;
        String instanceId = LeadControllerUtils.getHelixClusterLeader((HelixManager)helixManager);
        if (instanceId == null) {
            throw new RuntimeException("Unable to locate the leader pinot controller, please retry later...");
        }
        HelixDataAccessor helixDataAccessor = helixManager.getHelixDataAccessor();
        ExtraInstanceConfig extraInstanceConfig = new ExtraInstanceConfig((InstanceConfig)helixDataAccessor.getProperty((keyBuilder = helixDataAccessor.keyBuilder()).instanceConfig("Controller_" + instanceId)));
        String controllerBaseUrl = extraInstanceConfig.getComponentUrl();
        if (controllerBaseUrl == null) {
            throw new RuntimeException("Unable to extract the base url from the leader pinot controller");
        }
        return controllerBaseUrl;
    }

    public BrokerResponse executeDMLStatement(SqlNodeAndOptions sqlNodeAndOptions, @Nullable Map<String, String> headers) {
        DataManipulationStatement statement = DataManipulationStatementParser.parse((SqlNodeAndOptions)sqlNodeAndOptions);
        BrokerResponseNative result = new BrokerResponseNative();
        switch (statement.getExecutionType()) {
            case MINION: {
                AdhocTaskConfig taskConf = statement.generateAdhocTaskConfig();
                try {
                    Map tableToTaskIdMap = this.getMinionClient().executeTask(taskConf, headers);
                    ArrayList rows = new ArrayList();
                    tableToTaskIdMap.forEach((key, value) -> rows.add(new Object[]{key, value}));
                    result.setResultTable(new ResultTable(statement.getResultSchema(), rows));
                }
                catch (IOException e) {
                    result.setExceptions((List)ImmutableList.of((Object)QueryException.getException((ProcessingException)QueryException.QUERY_EXECUTION_ERROR, (Throwable)e)));
                }
                break;
            }
            case HTTP: {
                try {
                    result.setResultTable(new ResultTable(statement.getResultSchema(), statement.execute()));
                }
                catch (Exception e) {
                    result.setExceptions((List)ImmutableList.of((Object)QueryException.getException((ProcessingException)QueryException.QUERY_EXECUTION_ERROR, (Throwable)e)));
                }
                break;
            }
            default: {
                result.setExceptions((List)ImmutableList.of((Object)QueryException.getException((ProcessingException)QueryException.QUERY_EXECUTION_ERROR, (Throwable)new UnsupportedOperationException("Unsupported statement - " + statement))));
            }
        }
        return result;
    }

    private MinionClient getMinionClient() {
        if (this._helixManager != null) {
            return new MinionClient(SqlQueryExecutor.getControllerBaseUrl(this._helixManager), null);
        }
        return new MinionClient(this._controllerUrl, null);
    }
}

