/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.executor;

import com.google.common.base.Preconditions;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.metrics.ServerQueryPhase;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.config.QueryOptionsUtils;
import org.apache.pinot.core.common.ExplainPlanRowData;
import org.apache.pinot.core.common.ExplainPlanRows;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.data.manager.InstanceDataManager;
import org.apache.pinot.core.data.manager.realtime.RealtimeTableDataManager;
import org.apache.pinot.core.operator.blocks.InstanceResponseBlock;
import org.apache.pinot.core.operator.blocks.results.AggregationResultsBlock;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.operator.blocks.results.ExplainResultsBlock;
import org.apache.pinot.core.operator.blocks.results.ResultsBlockUtils;
import org.apache.pinot.core.operator.filter.EmptyFilterOperator;
import org.apache.pinot.core.operator.filter.MatchAllFilterOperator;
import org.apache.pinot.core.plan.Plan;
import org.apache.pinot.core.plan.maker.InstancePlanMakerImplV2;
import org.apache.pinot.core.plan.maker.PlanMaker;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.config.QueryExecutorConfig;
import org.apache.pinot.core.query.executor.QueryExecutor;
import org.apache.pinot.core.query.pruner.SegmentPrunerService;
import org.apache.pinot.core.query.pruner.SegmentPrunerStatistics;
import org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.TimerContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextConverterUtils;
import org.apache.pinot.core.query.utils.idset.IdSet;
import org.apache.pinot.core.util.trace.TraceContext;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.MutableSegment;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.exception.BadQueryRequestException;
import org.apache.pinot.spi.exception.QueryCancelledException;
import org.apache.pinot.spi.trace.Tracing;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ServerQueryExecutorV1Impl
implements QueryExecutor {
    public static final String ENABLE_PREFETCH = "enable.prefetch";
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerQueryExecutorV1Impl.class);
    private static final String IN_PARTITIONED_SUBQUERY = "inPartitionedSubquery";
    private InstanceDataManager _instanceDataManager;
    private ServerMetrics _serverMetrics;
    private SegmentPrunerService _segmentPrunerService;
    private PlanMaker _planMaker;
    private long _defaultTimeoutMs = 15000L;
    private boolean _enablePrefetch;

    @Override
    public synchronized void init(PinotConfiguration config, InstanceDataManager instanceDataManager, ServerMetrics serverMetrics) throws ConfigurationException {
        this._instanceDataManager = instanceDataManager;
        this._serverMetrics = serverMetrics;
        QueryExecutorConfig queryExecutorConfig = new QueryExecutorConfig(config);
        LOGGER.info("Trying to build SegmentPrunerService");
        this._segmentPrunerService = new SegmentPrunerService(queryExecutorConfig.getPrunerConfig());
        LOGGER.info("Trying to build QueryPlanMaker");
        this._planMaker = new InstancePlanMakerImplV2(queryExecutorConfig);
        if (queryExecutorConfig.getTimeOut() > 0L) {
            this._defaultTimeoutMs = queryExecutorConfig.getTimeOut();
        }
        this._enablePrefetch = Boolean.parseBoolean(config.getProperty(ENABLE_PREFETCH));
        LOGGER.info("Initialized query executor with defaultTimeoutMs: {}, enablePrefetch: {}", (Object)this._defaultTimeoutMs, (Object)this._enablePrefetch);
    }

    @Override
    public synchronized void start() {
        LOGGER.info("Query executor started");
    }

    @Override
    public synchronized void shutDown() {
        LOGGER.info("Query executor shut down");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstanceResponseBlock execute(ServerQueryRequest queryRequest, ExecutorService executorService, @Nullable StreamObserver<Server.ServerResponse> responseObserver) {
        if (!queryRequest.isEnableTrace()) {
            return this.executeInternal(queryRequest, executorService, responseObserver);
        }
        try {
            long requestId = queryRequest.getRequestId();
            long traceId = TableNameBuilder.isRealtimeTableResource((String)queryRequest.getTableNameWithType()) ? -requestId : requestId;
            Tracing.getTracer().register(traceId);
            InstanceResponseBlock instanceResponseBlock = this.executeInternal(queryRequest, executorService, responseObserver);
            return instanceResponseBlock;
        }
        finally {
            Tracing.getTracer().unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstanceResponseBlock executeInternal(ServerQueryRequest queryRequest, ExecutorService executorService, @Nullable StreamObserver<Server.ServerResponse> responseObserver) {
        List missingSegments;
        int numMissingSegments;
        TimerContext timerContext = queryRequest.getTimerContext();
        TimerContext.Timer schedulerWaitTimer = timerContext.getPhaseTimer(ServerQueryPhase.SCHEDULER_WAIT);
        if (schedulerWaitTimer != null) {
            schedulerWaitTimer.stopAndRecord();
        }
        TimerContext.Timer queryProcessingTimer = timerContext.startNewPhaseTimer(ServerQueryPhase.QUERY_PROCESSING);
        long requestId = queryRequest.getRequestId();
        String tableNameWithType = queryRequest.getTableNameWithType();
        QueryContext queryContext = queryRequest.getQueryContext();
        LOGGER.debug("Incoming request Id: {}, query: {}", (Object)requestId, (Object)queryContext);
        long queryTimeoutMs = this._defaultTimeoutMs;
        Long timeoutFromQueryOptions = QueryOptionsUtils.getTimeoutMs(queryContext.getQueryOptions());
        if (timeoutFromQueryOptions != null) {
            queryTimeoutMs = timeoutFromQueryOptions;
        }
        long queryArrivalTimeMs = timerContext.getQueryArrivalTimeMs();
        long queryEndTimeMs = timerContext.getQueryArrivalTimeMs() + queryTimeoutMs;
        queryContext.setEndTimeMs(queryEndTimeMs);
        queryContext.setEnablePrefetch(this._enablePrefetch);
        long querySchedulingTimeMs = System.currentTimeMillis() - queryArrivalTimeMs;
        if (querySchedulingTimeMs >= queryTimeoutMs) {
            this._serverMetrics.addMeteredTableValue(tableNameWithType, (AbstractMetrics.Meter)ServerMeter.SCHEDULING_TIMEOUT_EXCEPTIONS, 1L);
            String errorMessage = String.format("Query scheduling took %dms (longer than query timeout of %dms) on server: %s", querySchedulingTimeMs, queryTimeoutMs, this._instanceDataManager.getInstanceId());
            InstanceResponseBlock instanceResponse = new InstanceResponseBlock();
            instanceResponse.addException(QueryException.getException((ProcessingException)QueryException.QUERY_SCHEDULING_TIMEOUT_ERROR, (String)errorMessage));
            LOGGER.error("{} while processing requestId: {}", (Object)errorMessage, (Object)requestId);
            return instanceResponse;
        }
        TableDataManager tableDataManager = this._instanceDataManager.getTableDataManager(tableNameWithType);
        if (tableDataManager == null) {
            String errorMessage = String.format("Failed to find table: %s on server: %s", tableNameWithType, this._instanceDataManager.getInstanceId());
            InstanceResponseBlock instanceResponse = new InstanceResponseBlock();
            instanceResponse.addException(QueryException.getException((ProcessingException)QueryException.SERVER_TABLE_MISSING_ERROR, (String)errorMessage));
            LOGGER.error("{} while processing requestId: {}", (Object)errorMessage, (Object)requestId);
            return instanceResponse;
        }
        List<String> segmentsToQuery = queryRequest.getSegmentsToQuery();
        ArrayList notAcquiredSegments = new ArrayList();
        List segmentDataManagers = tableDataManager.acquireSegments(segmentsToQuery, notAcquiredSegments);
        int numSegmentsAcquired = segmentDataManagers.size();
        ArrayList<IndexSegment> indexSegments = new ArrayList<IndexSegment>(numSegmentsAcquired);
        for (SegmentDataManager segmentDataManager : segmentDataManagers) {
            indexSegments.add(segmentDataManager.getSegment());
        }
        int numConsumingSegmentsQueried = 0;
        long minIndexTimeMs = 0L;
        long minIngestionTimeMs = 0L;
        long maxEndTimeMs = 0L;
        if (tableDataManager instanceof RealtimeTableDataManager) {
            minIndexTimeMs = Long.MAX_VALUE;
            minIngestionTimeMs = Long.MAX_VALUE;
            maxEndTimeMs = Long.MIN_VALUE;
            for (IndexSegment indexSegment : indexSegments) {
                SegmentMetadata segmentMetadata = indexSegment.getSegmentMetadata();
                if (indexSegment instanceof MutableSegment) {
                    long ingestionTimeMs;
                    ++numConsumingSegmentsQueried;
                    long indexTimeMs = segmentMetadata.getLastIndexedTimestamp();
                    if (indexTimeMs > 0L) {
                        minIndexTimeMs = Math.min(minIndexTimeMs, indexTimeMs);
                    }
                    if ((ingestionTimeMs = segmentMetadata.getLatestIngestionTimestamp()) <= 0L) continue;
                    minIngestionTimeMs = Math.min(minIngestionTimeMs, ingestionTimeMs);
                    continue;
                }
                if (!(indexSegment instanceof ImmutableSegment)) continue;
                long indexCreationTime = segmentMetadata.getIndexCreationTime();
                if (indexCreationTime > 0L) {
                    maxEndTimeMs = Math.max(maxEndTimeMs, indexCreationTime);
                    continue;
                }
                long endTime = segmentMetadata.getEndTime();
                if (endTime <= 0L) continue;
                maxEndTimeMs = Math.max(maxEndTimeMs, endTime);
            }
        }
        InstanceResponseBlock instanceResponse = null;
        try {
            instanceResponse = this.executeInternal(indexSegments, queryContext, timerContext, executorService, responseObserver, queryRequest.isEnableStreaming());
        }
        catch (Exception exception) {
            this._serverMetrics.addMeteredTableValue(tableNameWithType, (AbstractMetrics.Meter)ServerMeter.QUERY_EXECUTION_EXCEPTIONS, 1L);
            instanceResponse = new InstanceResponseBlock();
            if (exception instanceof BadQueryRequestException) {
                LOGGER.info("Caught BadQueryRequestException while processing requestId: {}, {}", (Object)requestId, (Object)exception.getMessage());
                instanceResponse.addException(QueryException.getException((ProcessingException)QueryException.QUERY_EXECUTION_ERROR, (Throwable)exception));
            } else if (exception instanceof QueryCancelledException) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Cancelled while processing requestId: {}", (Object)requestId, (Object)exception);
                } else {
                    LOGGER.info("Cancelled while processing requestId: {}, {}", (Object)requestId, (Object)exception.getMessage());
                }
                instanceResponse.addException(QueryException.getException((ProcessingException)QueryException.QUERY_CANCELLATION_ERROR, (String)("Query cancelled on: " + this._instanceDataManager.getInstanceId() + exception)));
            } else {
                LOGGER.error("Exception processing requestId {}", (Object)requestId, (Object)exception);
                instanceResponse.addException(QueryException.getException((ProcessingException)QueryException.QUERY_EXECUTION_ERROR, (Throwable)exception));
            }
        }
        finally {
            for (SegmentDataManager segmentDataManager : segmentDataManagers) {
                tableDataManager.releaseSegment(segmentDataManager);
            }
            if (queryRequest.isEnableTrace() && TraceContext.traceEnabled() && instanceResponse != null) {
                instanceResponse.addMetadata(DataTable.MetadataKey.TRACE_INFO.getName(), TraceContext.getTraceInfo());
            }
        }
        queryProcessingTimer.stopAndRecord();
        long l = queryProcessingTimer.getDurationMs();
        instanceResponse.addMetadata(DataTable.MetadataKey.NUM_SEGMENTS_QUERIED.getName(), Integer.toString(numSegmentsAcquired));
        instanceResponse.addMetadata(DataTable.MetadataKey.TIME_USED_MS.getName(), Long.toString(l));
        if (notAcquiredSegments.size() > 0 && (numMissingSegments = (missingSegments = notAcquiredSegments.stream().filter(segmentName -> !tableDataManager.isSegmentDeletedRecently(segmentName)).collect(Collectors.toList())).size()) > 0) {
            instanceResponse.addException(QueryException.getException((ProcessingException)QueryException.SERVER_SEGMENT_MISSING_ERROR, (String)String.format("%d segments %s missing on server: %s", numMissingSegments, missingSegments, this._instanceDataManager.getInstanceId())));
            this._serverMetrics.addMeteredTableValue(tableNameWithType, (AbstractMetrics.Meter)ServerMeter.NUM_MISSING_SEGMENTS, (long)numMissingSegments);
        }
        if (tableDataManager instanceof RealtimeTableDataManager) {
            if (numConsumingSegmentsQueried > 0) {
                instanceResponse.addMetadata(DataTable.MetadataKey.NUM_CONSUMING_SEGMENTS_QUERIED.getName(), Integer.toString(numConsumingSegmentsQueried));
            }
            long minConsumingFreshnessTimeMs = 0L;
            if (minIngestionTimeMs != Long.MAX_VALUE) {
                minConsumingFreshnessTimeMs = minIndexTimeMs;
            } else if (minIndexTimeMs != Long.MAX_VALUE) {
                minConsumingFreshnessTimeMs = minIndexTimeMs;
            } else if (maxEndTimeMs != Long.MIN_VALUE) {
                minConsumingFreshnessTimeMs = maxEndTimeMs;
            }
            if (minConsumingFreshnessTimeMs > 0L) {
                instanceResponse.addMetadata(DataTable.MetadataKey.MIN_CONSUMING_FRESHNESS_TIME_MS.getName(), Long.toString(minConsumingFreshnessTimeMs));
            }
            LOGGER.debug("Request {} queried {} consuming segments with minConsumingFreshnessTimeMs: {}", new Object[]{requestId, numConsumingSegmentsQueried, minConsumingFreshnessTimeMs});
        }
        LOGGER.debug("Query processing time for request Id - {}: {}", (Object)requestId, (Object)l);
        return instanceResponse;
    }

    private InstanceResponseBlock executeInternal(List<IndexSegment> indexSegments, QueryContext queryContext, TimerContext timerContext, ExecutorService executorService, @Nullable StreamObserver<Server.ServerResponse> responseObserver, boolean enableStreaming) throws Exception {
        InstanceResponseBlock instanceResponse;
        this.handleSubquery(queryContext, indexSegments, timerContext, executorService);
        long numTotalDocs = 0L;
        for (IndexSegment indexSegment : indexSegments) {
            numTotalDocs += (long)indexSegment.getSegmentMetadata().getTotalDocs();
        }
        TimerContext.Timer segmentPruneTimer = timerContext.startNewPhaseTimer(ServerQueryPhase.SEGMENT_PRUNING);
        int numTotalSegments = indexSegments.size();
        SegmentPrunerStatistics prunerStats = new SegmentPrunerStatistics();
        List<IndexSegment> selectedSegments = this._segmentPrunerService.prune(indexSegments, queryContext, prunerStats);
        segmentPruneTimer.stopAndRecord();
        int numSelectedSegments = selectedSegments.size();
        LOGGER.debug("Matched {} segments after pruning", (Object)numSelectedSegments);
        if (numSelectedSegments == 0) {
            instanceResponse = queryContext.isExplain() ? ServerQueryExecutorV1Impl.getExplainResponseForNoMatchingSegment(numTotalSegments, queryContext) : new InstanceResponseBlock(ResultsBlockUtils.buildEmptyQueryResults(queryContext), queryContext);
        } else {
            TimerContext.Timer planBuildTimer = timerContext.startNewPhaseTimer(ServerQueryPhase.BUILD_QUERY_PLAN);
            Plan queryPlan = enableStreaming ? this._planMaker.makeStreamingInstancePlan(selectedSegments, queryContext, executorService, responseObserver, this._serverMetrics) : this._planMaker.makeInstancePlan(selectedSegments, queryContext, executorService, this._serverMetrics);
            planBuildTimer.stopAndRecord();
            TimerContext.Timer planExecTimer = timerContext.startNewPhaseTimer(ServerQueryPhase.QUERY_PLAN_EXECUTION);
            instanceResponse = queryContext.isExplain() ? ServerQueryExecutorV1Impl.executeExplainQuery(queryPlan, queryContext) : queryPlan.execute();
            planExecTimer.stopAndRecord();
        }
        instanceResponse.addMetadata(DataTable.MetadataKey.TOTAL_DOCS.getName(), Long.toString(numTotalDocs));
        int prunedSegments = numTotalSegments - numSelectedSegments;
        instanceResponse.addMetadata(DataTable.MetadataKey.NUM_SEGMENTS_PRUNED_BY_SERVER.getName(), String.valueOf(prunedSegments));
        this.addPrunerStats(instanceResponse, prunerStats);
        return instanceResponse;
    }

    private static InstanceResponseBlock getExplainResponseForNoMatchingSegment(int numTotalSegments, QueryContext queryContext) {
        ExplainResultsBlock explainResults = new ExplainResultsBlock();
        explainResults.addOperator(String.format("PLAN_START(numSegmentsForThisPlan:%d)", numTotalSegments), -1, -1);
        explainResults.addOperator("ALL_SEGMENTS_PRUNED_ON_SERVER", 3, 2);
        return new InstanceResponseBlock(explainResults, queryContext);
    }

    private static Map<Integer, List<ExplainPlanRows>> getAllSegmentsUniqueExplainPlanRowData(Operator root) {
        HashMap<Integer, List<ExplainPlanRows>> operatorDepthToRowDataMap = new HashMap<Integer, List<ExplainPlanRows>>();
        if (root == null) {
            return operatorDepthToRowDataMap;
        }
        HashMap uniquePlanNodeHashCodes = new HashMap();
        List<Operator> children = root.getChildOperators();
        for (Operator child : children) {
            int[] operatorId = new int[]{3};
            ExplainPlanRows explainPlanRows = new ExplainPlanRows();
            ServerQueryExecutorV1Impl.getSegmentExplainPlanRowData(child, explainPlanRows, operatorId, 2);
            int numRows = explainPlanRows.getExplainPlanRowData().size();
            if (numRows <= 0) continue;
            operatorDepthToRowDataMap.putIfAbsent(numRows, new ArrayList());
            uniquePlanNodeHashCodes.putIfAbsent(numRows, new HashSet());
            int explainPlanRowsHashCode = explainPlanRows.hashCode();
            if (!((HashSet)uniquePlanNodeHashCodes.get(numRows)).contains(explainPlanRowsHashCode)) {
                explainPlanRows.incrementNumSegmentsMatchingThisPlan();
                ((List)operatorDepthToRowDataMap.get(numRows)).add(explainPlanRows);
                ((HashSet)uniquePlanNodeHashCodes.get(numRows)).add(explainPlanRowsHashCode);
                continue;
            }
            boolean explainPlanMatchFound = false;
            int operatorDepthToRowMapSize = ((List)operatorDepthToRowDataMap.get(numRows)).size();
            for (int i = 0; i < operatorDepthToRowMapSize; ++i) {
                ExplainPlanRows explainPlanRowsPotentialMatch = (ExplainPlanRows)((List)operatorDepthToRowDataMap.get(numRows)).get(i);
                if (explainPlanRowsPotentialMatch.hashCode() != explainPlanRowsHashCode || !explainPlanRowsPotentialMatch.equals(explainPlanRows)) continue;
                explainPlanRowsPotentialMatch.incrementNumSegmentsMatchingThisPlan();
                explainPlanMatchFound = true;
                break;
            }
            if (explainPlanMatchFound) continue;
            explainPlanRows.incrementNumSegmentsMatchingThisPlan();
            ((List)operatorDepthToRowDataMap.get(numRows)).add(explainPlanRows);
        }
        return operatorDepthToRowDataMap;
    }

    private static void getSegmentExplainPlanRowData(Operator node, ExplainPlanRows explainPlanRows, int[] globalId, int parentId) {
        if (node == null) {
            return;
        }
        String explainPlanString = node.toExplainString();
        if (explainPlanString != null) {
            ExplainPlanRowData explainPlanRowData = new ExplainPlanRowData(explainPlanString, globalId[0], parentId);
            int n = globalId[0];
            globalId[0] = n + 1;
            parentId = n;
            explainPlanRows.appendExplainPlanRowData(explainPlanRowData);
            if (node instanceof EmptyFilterOperator) {
                explainPlanRows.setHasEmptyFilter(true);
            }
            if (node instanceof MatchAllFilterOperator) {
                explainPlanRows.setHasMatchAllFilter(true);
            }
        }
        List<Operator> children = node.getChildOperators();
        for (Operator child : children) {
            ServerQueryExecutorV1Impl.getSegmentExplainPlanRowData(child, explainPlanRows, globalId, parentId);
        }
    }

    public static InstanceResponseBlock executeExplainQuery(Plan queryPlan, QueryContext queryContext) {
        ExplainResultsBlock explainResults = new ExplainResultsBlock();
        List<Operator> childOperators = queryPlan.getPlanNode().run().getChildOperators();
        assert (childOperators.size() == 1);
        Operator root = childOperators.get(0);
        int numEmptyFilterSegments = 0;
        int numMatchAllFilterSegments = 0;
        Map<Integer, List<ExplainPlanRows>> operatorDepthToRowDataMap = ServerQueryExecutorV1Impl.getAllSegmentsUniqueExplainPlanRowData(root);
        ArrayList listOfExplainPlans = new ArrayList();
        operatorDepthToRowDataMap.forEach((key, value) -> listOfExplainPlans.addAll(value));
        explainResults.addOperator(root.toExplainString(), 2, 1);
        for (ExplainPlanRows explainPlanRows : listOfExplainPlans) {
            numEmptyFilterSegments += explainPlanRows.isHasEmptyFilter() ? explainPlanRows.getNumSegmentsMatchingThisPlan() : 0;
            numMatchAllFilterSegments += explainPlanRows.isHasMatchAllFilter() ? explainPlanRows.getNumSegmentsMatchingThisPlan() : 0;
            explainResults.addOperator(String.format("PLAN_START(numSegmentsForThisPlan:%d)", explainPlanRows.getNumSegmentsMatchingThisPlan()), -1, -1);
            for (ExplainPlanRowData explainPlanRowData : explainPlanRows.getExplainPlanRowData()) {
                explainResults.addOperator(explainPlanRowData.getExplainPlanString(), explainPlanRowData.getOperatorId(), explainPlanRowData.getParentId());
            }
        }
        InstanceResponseBlock instanceResponse = new InstanceResponseBlock(explainResults, queryContext);
        instanceResponse.addMetadata(DataTable.MetadataKey.EXPLAIN_PLAN_NUM_EMPTY_FILTER_SEGMENTS.getName(), String.valueOf(numEmptyFilterSegments));
        instanceResponse.addMetadata(DataTable.MetadataKey.EXPLAIN_PLAN_NUM_MATCH_ALL_FILTER_SEGMENTS.getName(), String.valueOf(numMatchAllFilterSegments));
        return instanceResponse;
    }

    private void handleSubquery(QueryContext queryContext, List<IndexSegment> indexSegments, TimerContext timerContext, ExecutorService executorService) throws Exception {
        FilterContext filter = queryContext.getFilter();
        if (filter != null) {
            this.handleSubquery(filter, indexSegments, timerContext, executorService, queryContext.getEndTimeMs());
        }
    }

    private void handleSubquery(FilterContext filter, List<IndexSegment> indexSegments, TimerContext timerContext, ExecutorService executorService, long endTimeMs) throws Exception {
        List children = filter.getChildren();
        if (children != null) {
            for (FilterContext child : children) {
                this.handleSubquery(child, indexSegments, timerContext, executorService, endTimeMs);
            }
        } else {
            this.handleSubquery(filter.getPredicate().getLhs(), indexSegments, timerContext, executorService, endTimeMs);
        }
    }

    private void handleSubquery(ExpressionContext expression, List<IndexSegment> indexSegments, TimerContext timerContext, ExecutorService executorService, long endTimeMs) throws Exception {
        FunctionContext function = expression.getFunction();
        if (function == null) {
            return;
        }
        List arguments = function.getArguments();
        if (StringUtils.remove((String)function.getFunctionName(), (char)'_').equalsIgnoreCase(IN_PARTITIONED_SUBQUERY)) {
            Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0, (Object)"IN_PARTITIONED_SUBQUERY requires 2 arguments: expression, subquery");
            ExpressionContext subqueryExpression = (ExpressionContext)arguments.get(1);
            Preconditions.checkState((subqueryExpression.getType() == ExpressionContext.Type.LITERAL ? 1 : 0) != 0, (Object)"Second argument of IN_PARTITIONED_SUBQUERY must be a literal (subquery)");
            QueryContext subquery = QueryContextConverterUtils.getQueryContext(subqueryExpression.getLiteralString());
            AggregationFunction[] aggregationFunctions = subquery.getAggregationFunctions();
            Preconditions.checkArgument((aggregationFunctions != null && aggregationFunctions.length == 1 && aggregationFunctions[0].getType() == AggregationFunctionType.IDSET && subquery.getGroupByExpressions() == null ? 1 : 0) != 0, (String)"Subquery in IN_PARTITIONED_SUBQUERY should be an ID_SET aggregation only query, found: %s", (Object)subqueryExpression.toString());
            subquery.setEndTimeMs(endTimeMs);
            InstanceResponseBlock instanceResponse = this.executeInternal(new ArrayList<IndexSegment>(indexSegments), subquery, timerContext, executorService, null, false);
            BaseResultsBlock resultsBlock = instanceResponse.getResultsBlock();
            Preconditions.checkState((boolean)(resultsBlock instanceof AggregationResultsBlock), (String)"Got unexpected results block type: %s, expecting aggregation results", resultsBlock != null ? resultsBlock.getClass().getSimpleName() : null);
            Object result = ((AggregationResultsBlock)resultsBlock).getResults().get(0);
            Preconditions.checkState((boolean)(result instanceof IdSet), (String)"Got unexpected result type: %s, expecting IdSet", result != null ? result.getClass().getSimpleName() : null);
            function.setFunctionName(TransformFunctionType.INIDSET.name());
            arguments.set(1, ExpressionContext.forLiteralContext((FieldSpec.DataType)FieldSpec.DataType.STRING, (Object)((IdSet)result).toBase64String()));
        } else {
            for (ExpressionContext argument : arguments) {
                this.handleSubquery(argument, indexSegments, timerContext, executorService, endTimeMs);
            }
        }
    }

    private void addPrunerStats(InstanceResponseBlock instanceResponse, SegmentPrunerStatistics prunerStats) {
        instanceResponse.addMetadata(DataTable.MetadataKey.NUM_SEGMENTS_PRUNED_INVALID.getName(), String.valueOf(prunerStats.getInvalidSegments()));
        instanceResponse.addMetadata(DataTable.MetadataKey.NUM_SEGMENTS_PRUNED_BY_LIMIT.getName(), String.valueOf(prunerStats.getLimitPruned()));
        instanceResponse.addMetadata(DataTable.MetadataKey.NUM_SEGMENTS_PRUNED_BY_VALUE.getName(), String.valueOf(prunerStats.getValuePruned()));
    }
}

