/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.executor;

import io.grpc.stub.StreamObserver;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.core.data.manager.InstanceDataManager;
import org.apache.pinot.core.operator.blocks.InstanceResponseBlock;
import org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.spi.env.PinotConfiguration;

@ThreadSafe
public interface QueryExecutor {
    public void init(PinotConfiguration var1, InstanceDataManager var2, ServerMetrics var3) throws ConfigurationException;

    public void start();

    public void shutDown();

    @Deprecated
    default public DataTable processQuery(ServerQueryRequest queryRequest, ExecutorService executorService) {
        return this.processQuery(queryRequest, executorService, null);
    }

    @Deprecated
    default public DataTable processQuery(ServerQueryRequest queryRequest, ExecutorService executorService, @Nullable StreamObserver<Server.ServerResponse> responseObserver) {
        InstanceResponseBlock instanceResponse = this.execute(queryRequest, executorService, responseObserver);
        try {
            return instanceResponse.toDataTable();
        }
        catch (Exception e) {
            DataTable metadataOnlyDataTable = instanceResponse.toMetadataOnlyDataTable();
            metadataOnlyDataTable.addException(QueryException.getException((ProcessingException)QueryException.DATA_TABLE_SERIALIZATION_ERROR, (Throwable)e));
            return metadataOnlyDataTable;
        }
    }

    default public InstanceResponseBlock execute(ServerQueryRequest queryRequest, ExecutorService executorService) {
        return this.execute(queryRequest, executorService, null);
    }

    public InstanceResponseBlock execute(ServerQueryRequest var1, ExecutorService var2, @Nullable StreamObserver<Server.ServerResponse> var3);
}

