/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.query.distinct.raw.BaseRawStringSingleColumnDistinctExecutor;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RoaringBitmap;

public class RawStringSingleColumnDistinctOnlyExecutor
extends BaseRawStringSingleColumnDistinctExecutor {
    public RawStringSingleColumnDistinctOnlyExecutor(ExpressionContext expression, FieldSpec.DataType dataType, int limit, boolean nullHandlingEnabled) {
        super(expression, dataType, limit, nullHandlingEnabled);
    }

    @Override
    public boolean process(TransformBlock transformBlock) {
        BlockValSet blockValueSet = transformBlock.getBlockValueSet(this._expression);
        int numDocs = transformBlock.getNumDocs();
        if (blockValueSet.isSingleValue()) {
            String[] values = blockValueSet.getStringValuesSV();
            if (this._nullHandlingEnabled) {
                RoaringBitmap nullBitmap = blockValueSet.getNullBitmap();
                for (int i = 0; i < numDocs; ++i) {
                    if (nullBitmap != null && nullBitmap.contains(i)) {
                        values[i] = null;
                    }
                    this._valueSet.add((Object)values[i]);
                    if (this._valueSet.size() < this._limit) continue;
                    return true;
                }
            } else {
                for (int i = 0; i < numDocs; ++i) {
                    this._valueSet.add((Object)values[i]);
                    if (this._valueSet.size() < this._limit) continue;
                    return true;
                }
            }
        } else {
            String[][] values = blockValueSet.getStringValuesMV();
            for (int i = 0; i < numDocs; ++i) {
                for (String value : values[i]) {
                    this._valueSet.add((Object)value);
                    if (this._valueSet.size() < this._limit) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

