/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import it.unimi.dsi.fastutil.longs.LongHeapPriorityQueue;
import it.unimi.dsi.fastutil.longs.LongPriorityQueue;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.query.distinct.raw.BaseRawLongSingleColumnDistinctExecutor;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RoaringBitmap;

public class RawLongSingleColumnDistinctOrderByExecutor
extends BaseRawLongSingleColumnDistinctExecutor {
    private final LongPriorityQueue _priorityQueue;

    public RawLongSingleColumnDistinctOrderByExecutor(ExpressionContext expression, FieldSpec.DataType dataType, OrderByExpressionContext orderByExpression, int limit, boolean nullHandlingEnabled) {
        super(expression, dataType, limit, nullHandlingEnabled);
        assert (orderByExpression.getExpression().equals((Object)expression));
        int comparisonFactor = orderByExpression.isAsc() ? -1 : 1;
        this._priorityQueue = new LongHeapPriorityQueue(Math.min(limit, 10000), (l1, l2) -> Long.compare(l1, l2) * comparisonFactor);
    }

    @Override
    public boolean process(TransformBlock transformBlock) {
        BlockValSet blockValueSet = transformBlock.getBlockValueSet(this._expression);
        int numDocs = transformBlock.getNumDocs();
        if (blockValueSet.isSingleValue()) {
            long[] values = blockValueSet.getLongValuesSV();
            if (this._nullHandlingEnabled) {
                RoaringBitmap nullBitmap = blockValueSet.getNullBitmap();
                for (int i = 0; i < numDocs; ++i) {
                    if (nullBitmap != null && nullBitmap.contains(i)) {
                        this._hasNull = true;
                        continue;
                    }
                    this.add(values[i]);
                }
            } else {
                for (int i = 0; i < numDocs; ++i) {
                    this.add(values[i]);
                }
            }
        } else {
            long[][] values = blockValueSet.getLongValuesMV();
            for (int i = 0; i < numDocs; ++i) {
                for (long value : values[i]) {
                    this.add(value);
                }
            }
        }
        return false;
    }

    private void add(long value) {
        if (!this._valueSet.contains(value)) {
            if (this._valueSet.size() < this._limit - (this._hasNull ? 1 : 0)) {
                this._valueSet.add(value);
                this._priorityQueue.enqueue(value);
            } else {
                long firstValue = this._priorityQueue.firstLong();
                if (this._priorityQueue.comparator().compare(value, firstValue) > 0) {
                    this._valueSet.remove(firstValue);
                    this._valueSet.add(value);
                    this._priorityQueue.dequeueLong();
                    this._priorityQueue.enqueue(value);
                }
            }
        }
    }
}

