/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.math.BigDecimal;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.query.distinct.raw.BaseRawBigDecimalSingleColumnDistinctExecutor;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RoaringBitmap;

public class RawBigDecimalSingleColumnDistinctOrderByExecutor
extends BaseRawBigDecimalSingleColumnDistinctExecutor {
    private final PriorityQueue<BigDecimal> _priorityQueue;

    public RawBigDecimalSingleColumnDistinctOrderByExecutor(ExpressionContext expression, FieldSpec.DataType dataType, OrderByExpressionContext orderByExpression, int limit, boolean nullHandlingEnabled) {
        super(expression, dataType, limit, nullHandlingEnabled);
        assert (orderByExpression.getExpression().equals((Object)expression));
        int comparisonFactor = orderByExpression.isAsc() ? -1 : 1;
        this._priorityQueue = nullHandlingEnabled ? new ObjectHeapPriorityQueue(Math.min(limit, 10000), (b1, b2) -> b1 == null ? (b2 == null ? 0 : 1) : (b2 == null ? -1 : b1.compareTo((BigDecimal)b2)) * comparisonFactor) : new ObjectHeapPriorityQueue(Math.min(limit, 10000), (b1, b2) -> b1.compareTo((BigDecimal)b2) * comparisonFactor);
    }

    @Override
    public boolean process(TransformBlock transformBlock) {
        BlockValSet blockValueSet = transformBlock.getBlockValueSet(this._expression);
        BigDecimal[] values = blockValueSet.getBigDecimalValuesSV();
        int numDocs = transformBlock.getNumDocs();
        if (this._nullHandlingEnabled) {
            RoaringBitmap nullBitmap = blockValueSet.getNullBitmap();
            for (int i = 0; i < numDocs; ++i) {
                BigDecimal value = nullBitmap != null && nullBitmap.contains(i) ? null : values[i];
                this.processInternal(value);
            }
        } else {
            for (int i = 0; i < numDocs; ++i) {
                this.processInternal(values[i]);
            }
        }
        return false;
    }

    private void processInternal(BigDecimal value) {
        if (!this._valueSet.contains((Object)value)) {
            if (this._valueSet.size() < this._limit) {
                this._valueSet.add((Object)value);
                this._priorityQueue.enqueue((Object)value);
            } else {
                BigDecimal firstValue = (BigDecimal)this._priorityQueue.first();
                if (this._priorityQueue.comparator().compare(value, firstValue) > 0) {
                    this._valueSet.remove((Object)firstValue);
                    this._valueSet.add((Object)value);
                    this._priorityQueue.dequeue();
                    this._priorityQueue.enqueue((Object)value);
                }
            }
        }
    }
}

