/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.dictionary;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.query.distinct.DistinctExecutor;
import org.apache.pinot.core.query.distinct.DistinctTable;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;

abstract class BaseDictionaryBasedMultiColumnDistinctExecutor
implements DistinctExecutor {
    final List<ExpressionContext> _expressions;
    final List<Dictionary> _dictionaries;
    final List<FieldSpec.DataType> _dataTypes;
    final int _limit;
    final ObjectSet<DictIds> _dictIdsSet;

    BaseDictionaryBasedMultiColumnDistinctExecutor(List<ExpressionContext> expressions, List<Dictionary> dictionaries, List<FieldSpec.DataType> dataTypes, int limit) {
        this._expressions = expressions;
        this._dictionaries = dictionaries;
        this._dataTypes = dataTypes;
        this._limit = limit;
        this._dictIdsSet = new ObjectOpenHashSet(Math.min(limit, 10000));
    }

    @Override
    public DistinctTable getResult() {
        int numExpressions = this._expressions.size();
        String[] columnNames = new String[numExpressions];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numExpressions];
        for (int i = 0; i < numExpressions; ++i) {
            columnNames[i] = this._expressions.get(i).toString();
            columnDataTypes[i] = DataSchema.ColumnDataType.fromDataTypeSV((FieldSpec.DataType)this._dataTypes.get(i));
        }
        DataSchema dataSchema = new DataSchema(columnNames, columnDataTypes);
        ArrayList<Record> records = new ArrayList<Record>(this._dictIdsSet.size());
        for (DictIds dictIds : this._dictIdsSet) {
            Object[] values = new Object[numExpressions];
            for (int i = 0; i < numExpressions; ++i) {
                int dictId = dictIds._dictIds[i];
                values[i] = this._dictionaries.get(i).getInternal(dictId);
            }
            records.add(new Record(values));
        }
        return new DistinctTable(dataSchema, records);
    }

    static class DictIds {
        final int[] _dictIds;

        DictIds(int[] dictIds) {
            this._dictIds = dictIds;
        }

        public boolean equals(Object o) {
            return Arrays.equals(this._dictIds, ((DictIds)o)._dictIds);
        }

        public int hashCode() {
            return Arrays.hashCode(this._dictIds);
        }
    }
}

