/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.utils;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;

public class StatisticalAggregationFunctionUtils {
    private StatisticalAggregationFunctionUtils() {
    }

    public static double[] getValSet(Map<ExpressionContext, BlockValSet> blockValSetMap, ExpressionContext expression) {
        BlockValSet blockValSet = blockValSetMap.get(expression);
        Preconditions.checkState((boolean)blockValSet.isSingleValue(), (Object)"Variance, Covariance, Standard Deviation function currently only supports single-valued column");
        switch (blockValSet.getValueType().getStoredType()) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return blockValSet.getDoubleValuesSV();
            }
        }
        throw new IllegalStateException("Cannot compute variance, covariance, or standard deviation for non-numeric type: " + blockValSet.getValueType());
    }
}

