/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.utils;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;

public class DoubleVectorOpUtils {
    private DoubleVectorOpUtils() {
    }

    public static DoubleArrayList vectorAdd(DoubleArrayList a, DoubleArrayList b) {
        return DoubleVectorOpUtils.vectorAdd(a, b.elements());
    }

    public static DoubleArrayList vectorAdd(DoubleArrayList a, double[] b) {
        double[] elements = a.elements();
        int length = elements.length;
        Preconditions.checkState((length == b.length ? 1 : 0) != 0, (String)"The two operand arrays are not of the same size! provided %s, %s", (int)length, (int)b.length);
        for (int i = 0; i < length; ++i) {
            int n = i;
            elements[n] = elements[n] + b[i];
        }
        return a;
    }

    public static DoubleArrayList createAndInitialize(double[] a) {
        return new DoubleArrayList(a);
    }

    public static DoubleArrayList createAndInitialize(int len) {
        Preconditions.checkState((len > 0 ? 1 : 0) != 0, (String)"Asking for an array of length %s", (int)len);
        return new DoubleArrayList(new double[len]);
    }

    public static DoubleArrayList incrementElement(DoubleArrayList a, int offset, double val) {
        Preconditions.checkState((a.size() > offset ? 1 : 0) != 0, (String)"The offset %s exceeds the array size!", (int)offset);
        double[] elements = a.elements();
        int n = offset;
        elements[n] = elements[n] + val;
        return a;
    }

    public static DoubleArrayList incrementElementByOne(DoubleArrayList a, int offset) {
        return DoubleVectorOpUtils.incrementElement(a, offset, 1.0);
    }
}

