/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.math.BigDecimal;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.DoubleAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.DoubleGroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.roaringbitmap.RoaringBitmap;

public class SumAggregationFunction
extends BaseSingleInputAggregationFunction<Double, Double> {
    private static final double DEFAULT_VALUE = 0.0;
    private final boolean _nullHandlingEnabled;

    public SumAggregationFunction(ExpressionContext expression) {
        this(expression, false);
    }

    public SumAggregationFunction(ExpressionContext expression, boolean nullHandlingEnabled) {
        super(expression);
        this._nullHandlingEnabled = nullHandlingEnabled;
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.SUM;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        if (this._nullHandlingEnabled) {
            return new ObjectAggregationResultHolder();
        }
        return new DoubleAggregationResultHolder(0.0);
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        if (this._nullHandlingEnabled) {
            return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
        }
        return new DoubleGroupByResultHolder(initialCapacity, maxCapacity, 0.0);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        if (this._nullHandlingEnabled) {
            RoaringBitmap nullBitmap = blockValSet.getNullBitmap();
            if (nullBitmap == null) {
                nullBitmap = new RoaringBitmap();
            }
            this.aggregateNullHandlingEnabled(length, aggregationResultHolder, blockValSet, nullBitmap);
            return;
        }
        double sum = aggregationResultHolder.getDoubleResult();
        switch (blockValSet.getValueType().getStoredType()) {
            case INT: {
                int[] values = blockValSet.getIntValuesSV();
                int i = 0;
                while (i < length & i < values.length) {
                    sum += (double)values[i];
                    ++i;
                }
                break;
            }
            case LONG: {
                long[] values = blockValSet.getLongValuesSV();
                int i = 0;
                while (i < length & i < values.length) {
                    sum += (double)values[i];
                    ++i;
                }
                break;
            }
            case FLOAT: {
                float[] values = blockValSet.getFloatValuesSV();
                int i = 0;
                while (i < length & i < values.length) {
                    sum += (double)values[i];
                    ++i;
                }
                break;
            }
            case DOUBLE: {
                double[] values = blockValSet.getDoubleValuesSV();
                int i = 0;
                while (i < length & i < values.length) {
                    sum += values[i];
                    ++i;
                }
                break;
            }
            case BIG_DECIMAL: {
                BigDecimal decimalSum = BigDecimal.valueOf(sum);
                BigDecimal[] values = blockValSet.getBigDecimalValuesSV();
                int i = 0;
                while (i < length & i < values.length) {
                    decimalSum = decimalSum.add(values[i]);
                    ++i;
                }
                sum = decimalSum.doubleValue();
                break;
            }
            default: {
                throw new IllegalStateException("Cannot compute sum for non-numeric type: " + blockValSet.getValueType());
            }
        }
        aggregationResultHolder.setValue(sum);
    }

    private void aggregateNullHandlingEnabled(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet, RoaringBitmap nullBitmap) {
        double sum = 0.0;
        switch (blockValSet.getValueType().getStoredType()) {
            case INT: {
                if (nullBitmap.getCardinality() >= length) break;
                int[] values = blockValSet.getIntValuesSV();
                int i = 0;
                while (i < length & i < values.length) {
                    if (!nullBitmap.contains(i)) {
                        sum += (double)values[i];
                    }
                    ++i;
                }
                this.setAggregationResultHolder(aggregationResultHolder, sum);
                break;
            }
            case LONG: {
                if (nullBitmap.getCardinality() >= length) break;
                long[] values = blockValSet.getLongValuesSV();
                int i = 0;
                while (i < length & i < values.length) {
                    if (!nullBitmap.contains(i)) {
                        sum += (double)values[i];
                    }
                    ++i;
                }
                this.setAggregationResultHolder(aggregationResultHolder, sum);
                break;
            }
            case FLOAT: {
                if (nullBitmap.getCardinality() >= length) break;
                float[] values = blockValSet.getFloatValuesSV();
                int i = 0;
                while (i < length & i < values.length) {
                    if (!nullBitmap.contains(i)) {
                        sum += (double)values[i];
                    }
                    ++i;
                }
                this.setAggregationResultHolder(aggregationResultHolder, sum);
                break;
            }
            case DOUBLE: {
                if (nullBitmap.getCardinality() >= length) break;
                double[] values = blockValSet.getDoubleValuesSV();
                int i = 0;
                while (i < length & i < values.length) {
                    if (!nullBitmap.contains(i)) {
                        sum += values[i];
                    }
                    ++i;
                }
                this.setAggregationResultHolder(aggregationResultHolder, sum);
                break;
            }
            case BIG_DECIMAL: {
                if (nullBitmap.getCardinality() >= length) break;
                BigDecimal[] values = blockValSet.getBigDecimalValuesSV();
                BigDecimal decimalSum = BigDecimal.valueOf(sum);
                int i = 0;
                while (i < length & i < values.length) {
                    if (!nullBitmap.contains(i)) {
                        decimalSum = decimalSum.add(values[i]);
                    }
                    ++i;
                }
                this.setAggregationResultHolder(aggregationResultHolder, decimalSum.doubleValue());
                break;
            }
            default: {
                throw new IllegalStateException("Cannot compute sum for non-numeric type: " + blockValSet.getValueType());
            }
        }
    }

    private void setAggregationResultHolder(AggregationResultHolder aggregationResultHolder, double sum) {
        Double otherSum = (Double)aggregationResultHolder.getResult();
        aggregationResultHolder.setValue(otherSum == null ? sum : sum + otherSum);
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        if (this._nullHandlingEnabled) {
            RoaringBitmap nullBitmap = blockValSet.getNullBitmap();
            if (nullBitmap == null) {
                nullBitmap = new RoaringBitmap();
            }
            if (nullBitmap.getCardinality() < length) {
                double[] valueArray = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    int groupKey;
                    if (nullBitmap.contains(i)) continue;
                    Double result = (Double)groupByResultHolder.getResult(groupKey = groupKeyArray[i]);
                    groupByResultHolder.setValueForKey(groupKey, result == null ? valueArray[i] : result + valueArray[i]);
                }
            }
            return;
        }
        double[] valueArray = blockValSet.getDoubleValuesSV();
        for (int i = 0; i < length; ++i) {
            int groupKey = groupKeyArray[i];
            groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + valueArray[i]);
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[] valueArray = blockValSetMap.get(this._expression).getDoubleValuesSV();
        for (int i = 0; i < length; ++i) {
            double value = valueArray[i];
            for (int groupKey : groupKeysArray[i]) {
                groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + value);
            }
        }
    }

    @Override
    public Double extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        if (this._nullHandlingEnabled) {
            return (Double)aggregationResultHolder.getResult();
        }
        return aggregationResultHolder.getDoubleResult();
    }

    @Override
    public Double extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        if (this._nullHandlingEnabled) {
            return (Double)groupByResultHolder.getResult(groupKey);
        }
        return groupByResultHolder.getDoubleResult(groupKey);
    }

    @Override
    public Double merge(Double intermediateResult1, Double intermediateResult2) {
        if (this._nullHandlingEnabled) {
            if (intermediateResult1 == null) {
                return intermediateResult2;
            }
            if (intermediateResult2 == null) {
                return intermediateResult1;
            }
        }
        return intermediateResult1 + intermediateResult2;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public Double extractFinalResult(Double intermediateResult) {
        return intermediateResult;
    }
}

