/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import com.google.common.base.Preconditions;
import com.tdunning.math.stats.TDigest;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public class PercentileSmartTDigestAggregationFunction
extends BaseSingleInputAggregationFunction<Object, Double> {
    private static final double DEFAULT_FINAL_RESULT = Double.NEGATIVE_INFINITY;
    private final double _percentile;
    private final int _threshold;
    private final int _compression;

    public PercentileSmartTDigestAggregationFunction(List<ExpressionContext> arguments) {
        super(arguments.get(0));
        try {
            this._percentile = Double.parseDouble(arguments.get(1).getLiteralString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Second argument of PERCENTILE_SMART_TDIGEST aggregation function must be a double literal (percentile)");
        }
        Preconditions.checkArgument((this._percentile >= 0.0 && this._percentile <= 100.0 ? 1 : 0) != 0, (String)"Invalid percentile: %s", (Object)this._percentile);
        if (arguments.size() > 2) {
            Parameters parameters = new Parameters(arguments.get(2).getLiteralString());
            this._compression = parameters._compression;
            this._threshold = parameters._threshold;
        } else {
            this._threshold = 100000;
            this._compression = 100;
        }
    }

    public double getPercentile() {
        return this._percentile;
    }

    public int getThreshold() {
        return this._threshold;
    }

    public int getCompression() {
        return this._compression;
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.PERCENTILESMARTTDIGEST;
    }

    @Override
    public String getColumnName() {
        return AggregationFunctionType.PERCENTILESMARTTDIGEST.getName() + this._percentile + "_" + this._expression;
    }

    @Override
    public String getResultColumnName() {
        return AggregationFunctionType.PERCENTILESMARTTDIGEST.getName().toLowerCase() + "(" + this._expression + ", " + this._percentile + ")";
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        PercentileSmartTDigestAggregationFunction.validateValueType(blockValSet);
        if (aggregationResultHolder.getResult() instanceof TDigest) {
            PercentileSmartTDigestAggregationFunction.aggregateIntoTDigest(length, aggregationResultHolder, blockValSet);
        } else {
            this.aggregateIntoValueList(length, aggregationResultHolder, blockValSet);
        }
    }

    private static void validateValueType(BlockValSet blockValSet) {
        FieldSpec.DataType valueType = blockValSet.getValueType();
        Preconditions.checkArgument((boolean)valueType.getStoredType().isNumeric(), (String)"Illegal data type for PERCENTILE_SMART_TDIGEST aggregation function: %s%s", (Object)valueType, (Object)(blockValSet.isSingleValue() ? "" : "_MV"));
    }

    private static void aggregateIntoTDigest(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet) {
        TDigest tDigest = (TDigest)aggregationResultHolder.getResult();
        if (blockValSet.isSingleValue()) {
            double[] doubleValues = blockValSet.getDoubleValuesSV();
            for (int i = 0; i < length; ++i) {
                tDigest.add(doubleValues[i]);
            }
        } else {
            double[][] doubleValues = blockValSet.getDoubleValuesMV();
            for (int i = 0; i < length; ++i) {
                for (double value : doubleValues[i]) {
                    tDigest.add(value);
                }
            }
        }
    }

    private void aggregateIntoValueList(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet) {
        DoubleArrayList valueList = (DoubleArrayList)aggregationResultHolder.getResult();
        if (valueList == null) {
            valueList = new DoubleArrayList(length);
            aggregationResultHolder.setValue(valueList);
        }
        if (blockValSet.isSingleValue()) {
            double[] doubleValues = blockValSet.getDoubleValuesSV();
            valueList.addElements(valueList.size(), doubleValues, 0, length);
        } else {
            double[][] doubleValues = blockValSet.getDoubleValuesMV();
            for (int i = 0; i < length; ++i) {
                valueList.addElements(valueList.size(), doubleValues[i]);
            }
        }
        if (valueList.size() > this._threshold) {
            aggregationResultHolder.setValue(this.convertValueListToTDigest(valueList));
        }
    }

    private TDigest convertValueListToTDigest(DoubleArrayList valueList) {
        TDigest tDigest = TDigest.createMergingDigest((double)this._compression);
        DoubleListIterator iterator = valueList.iterator();
        while (iterator.hasNext()) {
            tDigest.add(iterator.nextDouble());
        }
        return tDigest;
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        PercentileSmartTDigestAggregationFunction.validateValueType(blockValSet);
        if (blockValSet.isSingleValue()) {
            double[] doubleValues = blockValSet.getDoubleValuesSV();
            for (int i = 0; i < length; ++i) {
                DoubleArrayList valueList = PercentileSmartTDigestAggregationFunction.getValueList(groupByResultHolder, groupKeyArray[i]);
                valueList.add(doubleValues[i]);
            }
        } else {
            double[][] doubleValues = blockValSet.getDoubleValuesMV();
            for (int i = 0; i < length; ++i) {
                DoubleArrayList valueList = PercentileSmartTDigestAggregationFunction.getValueList(groupByResultHolder, groupKeyArray[i]);
                valueList.addElements(valueList.size(), doubleValues[i]);
            }
        }
    }

    private static DoubleArrayList getValueList(GroupByResultHolder groupByResultHolder, int groupKey) {
        DoubleArrayList valueList = (DoubleArrayList)groupByResultHolder.getResult(groupKey);
        if (valueList == null) {
            valueList = new DoubleArrayList();
            groupByResultHolder.setValueForKey(groupKey, valueList);
        }
        return valueList;
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        PercentileSmartTDigestAggregationFunction.validateValueType(blockValSet);
        if (blockValSet.isSingleValue()) {
            double[] doubleValues = blockValSet.getDoubleValuesSV();
            for (int i = 0; i < length; ++i) {
                for (int groupKey : groupKeysArray[i]) {
                    PercentileSmartTDigestAggregationFunction.getValueList(groupByResultHolder, groupKey).add(doubleValues[i]);
                }
            }
        } else {
            double[][] doubleValues = blockValSet.getDoubleValuesMV();
            for (int i = 0; i < length; ++i) {
                for (int groupKey : groupKeysArray[i]) {
                    DoubleArrayList valueList = PercentileSmartTDigestAggregationFunction.getValueList(groupByResultHolder, groupKey);
                    valueList.addElements(valueList.size(), doubleValues[i]);
                }
            }
        }
    }

    @Override
    public Object extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        Object result = aggregationResultHolder.getResult();
        return result != null ? result : new DoubleArrayList();
    }

    @Override
    public Object extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        Object result = groupByResultHolder.getResult(groupKey);
        return result != null ? result : new DoubleArrayList();
    }

    @Override
    public Object merge(Object intermediateResult1, Object intermediateResult2) {
        if (intermediateResult1 instanceof TDigest) {
            return PercentileSmartTDigestAggregationFunction.mergeIntoTDigest((TDigest)intermediateResult1, intermediateResult2);
        }
        if (intermediateResult2 instanceof TDigest) {
            return PercentileSmartTDigestAggregationFunction.mergeIntoTDigest((TDigest)intermediateResult2, intermediateResult1);
        }
        DoubleArrayList valueList1 = (DoubleArrayList)intermediateResult1;
        DoubleArrayList valueList2 = (DoubleArrayList)intermediateResult2;
        valueList1.addAll((DoubleList)valueList2);
        return valueList1.size() > this._threshold ? this.convertValueListToTDigest(valueList1) : valueList1;
    }

    private static TDigest mergeIntoTDigest(TDigest tDigest, Object intermediateResult) {
        if (intermediateResult instanceof TDigest) {
            tDigest.add((TDigest)intermediateResult);
        } else {
            DoubleArrayList valueList = (DoubleArrayList)intermediateResult;
            DoubleListIterator iterator = valueList.iterator();
            while (iterator.hasNext()) {
                tDigest.add(iterator.nextDouble());
            }
        }
        return tDigest;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public Double extractFinalResult(Object intermediateResult) {
        if (intermediateResult instanceof TDigest) {
            return ((TDigest)intermediateResult).quantile(this._percentile / 100.0);
        }
        DoubleArrayList valueList = (DoubleArrayList)intermediateResult;
        int size = valueList.size();
        if (size == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        double[] values = valueList.elements();
        Arrays.sort(values, 0, size);
        if (this._percentile == 100.0) {
            return values[size - 1];
        }
        return values[(int)((double)size * this._percentile / 100.0)];
    }

    private static class Parameters {
        static final char PARAMETER_DELIMITER = ';';
        static final char PARAMETER_KEY_VALUE_SEPARATOR = '=';
        static final String THRESHOLD_KEY = "THRESHOLD";
        static final int DEFAULT_THRESHOLD = 100000;
        static final String COMPRESSION_KEY = "COMPRESSION";
        static final int DEFAULT_COMPRESSION = 100;
        int _threshold = 100000;
        int _compression = 100;

        Parameters(String parametersString) {
            String[] keyValuePairs;
            StringUtils.deleteWhitespace((String)parametersString);
            block8: for (String keyValuePair : keyValuePairs = StringUtils.split((String)parametersString, (char)';')) {
                String[] keyAndValue = StringUtils.split((String)keyValuePair, (char)'=');
                Preconditions.checkArgument((keyAndValue.length == 2 ? 1 : 0) != 0, (String)"Invalid parameter: %s", (Object)keyValuePair);
                String key = keyAndValue[0];
                String value = keyAndValue[1];
                switch (key.toUpperCase()) {
                    case "THRESHOLD": {
                        this._threshold = Integer.parseInt(value);
                        if (this._threshold > 0) continue block8;
                        this._threshold = Integer.MAX_VALUE;
                        continue block8;
                    }
                    case "COMPRESSION": {
                        this._compression = Integer.parseInt(value);
                        continue block8;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid parameter key: " + key);
                    }
                }
            }
        }
    }
}

