/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileEstAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.segment.local.customobject.QuantileDigest;
import org.apache.pinot.segment.local.customobject.SerializedQuantileDigest;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class PercentileRawEstAggregationFunction
extends BaseSingleInputAggregationFunction<QuantileDigest, SerializedQuantileDigest> {
    private final PercentileEstAggregationFunction _percentileEstAggregationFunction;

    public PercentileRawEstAggregationFunction(ExpressionContext expressionContext, double percentile) {
        this(expressionContext, new PercentileEstAggregationFunction(expressionContext, percentile));
    }

    public PercentileRawEstAggregationFunction(ExpressionContext expressionContext, int percentile) {
        this(expressionContext, new PercentileEstAggregationFunction(expressionContext, percentile));
    }

    protected PercentileRawEstAggregationFunction(ExpressionContext expression, PercentileEstAggregationFunction percentileEstAggregationFunction) {
        super(expression);
        this._percentileEstAggregationFunction = percentileEstAggregationFunction;
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.PERCENTILERAWEST;
    }

    @Override
    public String getColumnName() {
        double percentile = this._percentileEstAggregationFunction._percentile;
        int version = this._percentileEstAggregationFunction._version;
        String type = this.getType().getName();
        return version == 0 ? type + (int)percentile + "_" + this._expression : type + percentile + "_" + this._expression;
    }

    @Override
    public String getResultColumnName() {
        double percentile = this._percentileEstAggregationFunction._percentile;
        int version = this._percentileEstAggregationFunction._version;
        String type = this.getType().getName().toLowerCase();
        return version == 0 ? type + (int)percentile + "(" + this._expression + ")" : type + "(" + this._expression + ", " + percentile + ")";
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return this._percentileEstAggregationFunction.createAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return this._percentileEstAggregationFunction.createGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        this._percentileEstAggregationFunction.aggregate(length, aggregationResultHolder, blockValSetMap);
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        this._percentileEstAggregationFunction.aggregateGroupBySV(length, groupKeyArray, groupByResultHolder, blockValSetMap);
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        this._percentileEstAggregationFunction.aggregateGroupByMV(length, groupKeysArray, groupByResultHolder, blockValSetMap);
    }

    @Override
    public QuantileDigest extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        return this._percentileEstAggregationFunction.extractAggregationResult(aggregationResultHolder);
    }

    @Override
    public QuantileDigest extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        return this._percentileEstAggregationFunction.extractGroupByResult(groupByResultHolder, groupKey);
    }

    @Override
    public QuantileDigest merge(QuantileDigest intermediateResult1, QuantileDigest intermediateResult2) {
        return this._percentileEstAggregationFunction.merge(intermediateResult1, intermediateResult2);
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return this._percentileEstAggregationFunction.getIntermediateResultColumnType();
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.STRING;
    }

    @Override
    public SerializedQuantileDigest extractFinalResult(QuantileDigest intermediateResult) {
        return new SerializedQuantileDigest(intermediateResult, this._percentileEstAggregationFunction._percentile);
    }
}

