/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.doubles.Double2LongMap;
import it.unimi.dsi.fastutil.doubles.Double2LongOpenHashMap;
import it.unimi.dsi.fastutil.floats.Float2LongMap;
import it.unimi.dsi.fastutil.floats.Float2LongOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntMaps;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class ModeAggregationFunction
extends BaseSingleInputAggregationFunction<Map<? extends Number, Long>, Double> {
    private static final double DEFAULT_FINAL_RESULT = Double.NEGATIVE_INFINITY;
    private final MultiModeReducerType _multiModeReducerType;

    public ModeAggregationFunction(List<ExpressionContext> arguments) {
        super(arguments.get(0));
        int numArguments = arguments.size();
        Preconditions.checkArgument((numArguments <= 2 ? 1 : 0) != 0, (String)"Mode expects at most 2 arguments, got: %s", (int)numArguments);
        this._multiModeReducerType = numArguments > 1 ? MultiModeReducerType.valueOf(arguments.get(1).getLiteralString()) : MultiModeReducerType.MIN;
    }

    private static Map<? extends Number, Long> getValueMap(FieldSpec.DataType valueType) {
        switch (valueType) {
            case INT: {
                return new Int2LongOpenHashMap();
            }
            case LONG: {
                return new Long2LongOpenHashMap();
            }
            case FLOAT: {
                return new Float2LongOpenHashMap();
            }
            case DOUBLE: {
                return new Double2LongOpenHashMap();
            }
        }
        throw new IllegalStateException("Illegal data type for MODE aggregation function: " + valueType);
    }

    private static Map<? extends Number, Long> getValueMap(AggregationResultHolder aggregationResultHolder, FieldSpec.DataType valueType) {
        Map<? extends Number, Long> valueMap = (Map<? extends Number, Long>)aggregationResultHolder.getResult();
        if (valueMap == null) {
            valueMap = ModeAggregationFunction.getValueMap(valueType);
            aggregationResultHolder.setValue(valueMap);
        }
        return valueMap;
    }

    private static void setValueForGroupKeys(GroupByResultHolder groupByResultHolder, int groupKey, int value) {
        Int2LongOpenHashMap valueMap = (Int2LongOpenHashMap)groupByResultHolder.getResult(groupKey);
        if (valueMap == null) {
            valueMap = new Int2LongOpenHashMap();
            groupByResultHolder.setValueForKey(groupKey, valueMap);
        }
        valueMap.merge(value, 1L, Long::sum);
    }

    private static void setValueForGroupKeys(GroupByResultHolder groupByResultHolder, int groupKey, long value) {
        Long2LongOpenHashMap valueMap = (Long2LongOpenHashMap)groupByResultHolder.getResult(groupKey);
        if (valueMap == null) {
            valueMap = new Long2LongOpenHashMap();
            groupByResultHolder.setValueForKey(groupKey, valueMap);
        }
        valueMap.merge(value, 1L, Long::sum);
    }

    private static void setValueForGroupKeys(GroupByResultHolder groupByResultHolder, int groupKey, float value) {
        Float2LongOpenHashMap valueMap = (Float2LongOpenHashMap)groupByResultHolder.getResult(groupKey);
        if (valueMap == null) {
            valueMap = new Float2LongOpenHashMap();
            groupByResultHolder.setValueForKey(groupKey, valueMap);
        }
        valueMap.merge(value, 1L, Long::sum);
    }

    private static void setValueForGroupKeys(GroupByResultHolder groupByResultHolder, int groupKey, double value) {
        Double2LongOpenHashMap valueMap = (Double2LongOpenHashMap)groupByResultHolder.getResult(groupKey);
        if (valueMap == null) {
            valueMap = new Double2LongOpenHashMap();
            groupByResultHolder.setValueForKey(groupKey, valueMap);
        }
        valueMap.merge(value, 1L, Long::sum);
    }

    protected static Int2IntOpenHashMap getDictIdCountMap(AggregationResultHolder aggregationResultHolder, Dictionary dictionary) {
        DictIdsWrapper dictIdsWrapper = (DictIdsWrapper)aggregationResultHolder.getResult();
        if (dictIdsWrapper == null) {
            dictIdsWrapper = new DictIdsWrapper(dictionary);
            aggregationResultHolder.setValue(dictIdsWrapper);
        }
        return dictIdsWrapper._dictIdCountMap;
    }

    protected static Int2IntOpenHashMap getDictIdCountMap(GroupByResultHolder groupByResultHolder, int groupKey, Dictionary dictionary) {
        DictIdsWrapper dictIdsWrapper = (DictIdsWrapper)groupByResultHolder.getResult(groupKey);
        if (dictIdsWrapper == null) {
            dictIdsWrapper = new DictIdsWrapper(dictionary);
            groupByResultHolder.setValueForKey(groupKey, dictIdsWrapper);
        }
        return dictIdsWrapper._dictIdCountMap;
    }

    private static Map<? extends Number, Long> convertToValueMap(DictIdsWrapper dictIdsWrapper) {
        Dictionary dictionary = dictIdsWrapper._dictionary;
        Int2IntOpenHashMap dictIdCountMap = dictIdsWrapper._dictIdCountMap;
        int numValues = dictIdCountMap.size();
        ObjectIterator iterator = Int2IntMaps.fastIterator((Int2IntMap)dictIdCountMap);
        FieldSpec.DataType storedType = dictionary.getValueType();
        switch (storedType) {
            case INT: {
                Int2LongOpenHashMap intValueMap = new Int2LongOpenHashMap(numValues);
                while (iterator.hasNext()) {
                    Int2IntMap.Entry next = (Int2IntMap.Entry)iterator.next();
                    intValueMap.put(dictionary.getIntValue(next.getIntKey()), (long)next.getIntValue());
                }
                return intValueMap;
            }
            case LONG: {
                Long2LongOpenHashMap longValueMap = new Long2LongOpenHashMap(numValues);
                while (iterator.hasNext()) {
                    Int2IntMap.Entry next = (Int2IntMap.Entry)iterator.next();
                    longValueMap.put(dictionary.getLongValue(next.getIntKey()), (long)next.getIntValue());
                }
                return longValueMap;
            }
            case FLOAT: {
                Float2LongOpenHashMap floatValueMap = new Float2LongOpenHashMap(numValues);
                while (iterator.hasNext()) {
                    Int2IntMap.Entry next = (Int2IntMap.Entry)iterator.next();
                    floatValueMap.put(dictionary.getFloatValue(next.getIntKey()), (long)next.getIntValue());
                }
                return floatValueMap;
            }
            case DOUBLE: {
                Double2LongOpenHashMap doubleValueMap = new Double2LongOpenHashMap(numValues);
                while (iterator.hasNext()) {
                    Int2IntMap.Entry next = (Int2IntMap.Entry)iterator.next();
                    doubleValueMap.put(dictionary.getDoubleValue(next.getIntKey()), (long)next.getIntValue());
                }
                return doubleValueMap;
            }
        }
        throw new IllegalStateException("Illegal data type for MODE aggregation function: " + storedType);
    }

    private static Map<? extends Number, Long> extractIntermediateResult(@Nullable Object result) {
        if (result == null) {
            return new Int2LongOpenHashMap();
        }
        if (result instanceof DictIdsWrapper) {
            return ModeAggregationFunction.convertToValueMap((DictIdsWrapper)result);
        }
        assert (result instanceof Map);
        return (Map)result;
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.MODE;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            int[] dictIds = blockValSet.getDictionaryIdsSV();
            Int2IntOpenHashMap dictIdValueMap = ModeAggregationFunction.getDictIdCountMap(aggregationResultHolder, dictionary);
            for (int i = 0; i < length; ++i) {
                dictIdValueMap.merge(dictIds[i], 1, Integer::sum);
            }
            return;
        }
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        Map<? extends Number, Long> valueMap = ModeAggregationFunction.getValueMap(aggregationResultHolder, storedType);
        switch (storedType) {
            case INT: {
                Int2LongOpenHashMap intMap = (Int2LongOpenHashMap)valueMap;
                int[] intValues = blockValSet.getIntValuesSV();
                for (int i = 0; i < length; ++i) {
                    intMap.merge(intValues[i], 1L, Long::sum);
                }
                break;
            }
            case LONG: {
                Long2LongOpenHashMap longMap = (Long2LongOpenHashMap)valueMap;
                long[] longValues = blockValSet.getLongValuesSV();
                for (int i = 0; i < length; ++i) {
                    longMap.merge(longValues[i], 1L, Long::sum);
                }
                break;
            }
            case FLOAT: {
                Float2LongOpenHashMap floatMap = (Float2LongOpenHashMap)valueMap;
                float[] floatValues = blockValSet.getFloatValuesSV();
                for (int i = 0; i < length; ++i) {
                    floatMap.merge(floatValues[i], 1L, Long::sum);
                }
                break;
            }
            case DOUBLE: {
                Double2LongOpenHashMap doubleMap = (Double2LongOpenHashMap)valueMap;
                double[] doubleValues = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    doubleMap.merge(doubleValues[i], 1L, Long::sum);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for MODE aggregation function: " + storedType);
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            int[] dictIds = blockValSet.getDictionaryIdsSV();
            for (int i = 0; i < length; ++i) {
                ModeAggregationFunction.getDictIdCountMap(groupByResultHolder, groupKeyArray[i], dictionary).merge(dictIds[i], 1, Integer::sum);
            }
            return;
        }
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        switch (storedType) {
            case INT: {
                int[] intValues = blockValSet.getIntValuesSV();
                for (int i = 0; i < length; ++i) {
                    ModeAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeyArray[i], intValues[i]);
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValSet.getLongValuesSV();
                for (int i = 0; i < length; ++i) {
                    ModeAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeyArray[i], longValues[i]);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSet.getFloatValuesSV();
                for (int i = 0; i < length; ++i) {
                    ModeAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeyArray[i], floatValues[i]);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    ModeAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeyArray[i], doubleValues[i]);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for MODE aggregation function: " + storedType);
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            int[] dictIds = blockValSet.getDictionaryIdsSV();
            for (int i = 0; i < length; ++i) {
                for (int groupKey : groupKeysArray[i]) {
                    ModeAggregationFunction.getDictIdCountMap(groupByResultHolder, groupKey, dictionary).merge(dictIds[i], 1, Integer::sum);
                }
            }
            return;
        }
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        switch (storedType) {
            case INT: {
                int[] intValues = blockValSet.getIntValuesSV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        ModeAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKey, intValues[i]);
                    }
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValSet.getLongValuesSV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        ModeAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKey, longValues[i]);
                    }
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSet.getFloatValuesSV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        ModeAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKey, floatValues[i]);
                    }
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        ModeAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKey, doubleValues[i]);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for MODE aggregation function: " + storedType);
            }
        }
    }

    @Override
    public Map<? extends Number, Long> extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        return ModeAggregationFunction.extractIntermediateResult(aggregationResultHolder.getResult());
    }

    @Override
    public Map<? extends Number, Long> extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        return ModeAggregationFunction.extractIntermediateResult(groupByResultHolder.getResult(groupKey));
    }

    @Override
    public Map<? extends Number, Long> merge(Map<? extends Number, Long> intermediateResult1, Map<? extends Number, Long> intermediateResult2) {
        if (intermediateResult1.isEmpty()) {
            return intermediateResult2;
        }
        if (intermediateResult2.isEmpty()) {
            return intermediateResult1;
        }
        if (intermediateResult1 instanceof Int2LongOpenHashMap && intermediateResult2 instanceof Int2LongOpenHashMap) {
            ((Int2LongOpenHashMap)intermediateResult2).int2LongEntrySet().fastForEach(e -> ((Int2LongOpenHashMap)intermediateResult1).merge(e.getIntKey(), e.getLongValue(), Long::sum));
        } else if (intermediateResult1 instanceof Long2LongOpenHashMap && intermediateResult2 instanceof Long2LongOpenHashMap) {
            ((Long2LongOpenHashMap)intermediateResult2).long2LongEntrySet().fastForEach(e -> ((Long2LongOpenHashMap)intermediateResult1).merge(e.getLongKey(), e.getLongValue(), Long::sum));
        } else if (intermediateResult1 instanceof Float2LongOpenHashMap && intermediateResult2 instanceof Float2LongOpenHashMap) {
            ((Float2LongOpenHashMap)intermediateResult2).float2LongEntrySet().fastForEach(e -> ((Float2LongOpenHashMap)intermediateResult1).merge(e.getFloatKey(), e.getLongValue(), Long::sum));
        } else if (intermediateResult1 instanceof Double2LongOpenHashMap && intermediateResult2 instanceof Double2LongOpenHashMap) {
            ((Double2LongOpenHashMap)intermediateResult2).double2LongEntrySet().fastForEach(e -> ((Double2LongOpenHashMap)intermediateResult1).merge(e.getDoubleKey(), e.getLongValue(), Long::sum));
        } else {
            throw new IllegalStateException("Illegal data type for Intermediate Result of MODE aggregation function: " + intermediateResult1.getClass().getSimpleName() + ", " + intermediateResult2.getClass().getSimpleName());
        }
        return intermediateResult1;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public Double extractFinalResult(Map<? extends Number, Long> intermediateResult) {
        if (intermediateResult.isEmpty()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (intermediateResult instanceof Int2LongOpenHashMap) {
            return this.extractFinalResult((Int2LongOpenHashMap)intermediateResult);
        }
        if (intermediateResult instanceof Long2LongOpenHashMap) {
            return this.extractFinalResult((Long2LongOpenHashMap)intermediateResult);
        }
        if (intermediateResult instanceof Float2LongOpenHashMap) {
            return this.extractFinalResult((Float2LongOpenHashMap)intermediateResult);
        }
        if (intermediateResult instanceof Double2LongOpenHashMap) {
            return this.extractFinalResult((Double2LongOpenHashMap)intermediateResult);
        }
        throw new IllegalStateException("Illegal data type for Intermediate Result of MODE aggregation function: " + intermediateResult.getClass().getSimpleName());
    }

    @Override
    public double extractFinalResult(Int2LongOpenHashMap intermediateResult) {
        ObjectIterator iterator = intermediateResult.int2LongEntrySet().fastIterator();
        Int2LongMap.Entry first = (Int2LongMap.Entry)iterator.next();
        long maxFrequency = first.getLongValue();
        switch (this._multiModeReducerType) {
            case MIN: {
                int min = first.getIntKey();
                while (iterator.hasNext()) {
                    Int2LongMap.Entry next = (Int2LongMap.Entry)iterator.next();
                    if (next.getLongValue() <= maxFrequency && (next.getLongValue() != maxFrequency || min <= next.getIntKey())) continue;
                    maxFrequency = next.getLongValue();
                    min = next.getIntKey();
                }
                return min;
            }
            case MAX: {
                int max = first.getIntKey();
                while (iterator.hasNext()) {
                    Int2LongMap.Entry next = (Int2LongMap.Entry)iterator.next();
                    if (next.getLongValue() <= maxFrequency && (next.getLongValue() != maxFrequency || max >= next.getIntKey())) continue;
                    maxFrequency = next.getLongValue();
                    max = next.getIntKey();
                }
                return max;
            }
            case AVG: {
                double sum = first.getIntKey();
                int count = 1;
                while (iterator.hasNext()) {
                    Int2LongMap.Entry next = (Int2LongMap.Entry)iterator.next();
                    if (next.getLongValue() > maxFrequency) {
                        maxFrequency = next.getLongValue();
                        sum = next.getIntKey();
                        count = 1;
                        continue;
                    }
                    if (next.getLongValue() != maxFrequency) continue;
                    sum += (double)next.getIntKey();
                    ++count;
                }
                return sum / (double)count;
            }
        }
        throw new IllegalStateException("Illegal reducer type for MODE aggregation function: " + this._multiModeReducerType);
    }

    @Override
    public double extractFinalResult(Long2LongOpenHashMap intermediateResult) {
        ObjectIterator iterator = intermediateResult.long2LongEntrySet().fastIterator();
        Long2LongMap.Entry first = (Long2LongMap.Entry)iterator.next();
        long maxFrequency = first.getLongValue();
        switch (this._multiModeReducerType) {
            case MIN: {
                long min = first.getLongKey();
                while (iterator.hasNext()) {
                    Long2LongMap.Entry next = (Long2LongMap.Entry)iterator.next();
                    if (next.getLongValue() <= maxFrequency && (next.getLongValue() != maxFrequency || min <= next.getLongKey())) continue;
                    maxFrequency = next.getLongValue();
                    min = next.getLongKey();
                }
                return min;
            }
            case MAX: {
                long max = first.getLongKey();
                while (iterator.hasNext()) {
                    Long2LongMap.Entry next = (Long2LongMap.Entry)iterator.next();
                    if (next.getLongValue() <= maxFrequency && (next.getLongValue() != maxFrequency || max >= next.getLongKey())) continue;
                    maxFrequency = next.getLongValue();
                    max = next.getLongKey();
                }
                return max;
            }
            case AVG: {
                double sum = first.getLongKey();
                int count = 1;
                while (iterator.hasNext()) {
                    Long2LongMap.Entry next = (Long2LongMap.Entry)iterator.next();
                    if (next.getLongValue() > maxFrequency) {
                        maxFrequency = next.getLongValue();
                        sum = next.getLongKey();
                        count = 1;
                        continue;
                    }
                    if (next.getLongValue() != maxFrequency) continue;
                    sum += (double)next.getLongKey();
                    ++count;
                }
                return sum / (double)count;
            }
        }
        throw new IllegalStateException("Illegal reducer type for MODE aggregation function: " + this._multiModeReducerType);
    }

    @Override
    public double extractFinalResult(Float2LongOpenHashMap intermediateResult) {
        ObjectIterator iterator = intermediateResult.float2LongEntrySet().fastIterator();
        Float2LongMap.Entry first = (Float2LongMap.Entry)iterator.next();
        long maxFrequency = first.getLongValue();
        switch (this._multiModeReducerType) {
            case MIN: {
                float min = first.getFloatKey();
                while (iterator.hasNext()) {
                    Float2LongMap.Entry next = (Float2LongMap.Entry)iterator.next();
                    if (next.getLongValue() <= maxFrequency && (next.getLongValue() != maxFrequency || !(min > next.getFloatKey()))) continue;
                    maxFrequency = next.getLongValue();
                    min = next.getFloatKey();
                }
                return min;
            }
            case MAX: {
                float max = first.getFloatKey();
                while (iterator.hasNext()) {
                    Float2LongMap.Entry next = (Float2LongMap.Entry)iterator.next();
                    if (next.getLongValue() <= maxFrequency && (next.getLongValue() != maxFrequency || !(max < next.getFloatKey()))) continue;
                    maxFrequency = next.getLongValue();
                    max = next.getFloatKey();
                }
                return max;
            }
            case AVG: {
                double sum = first.getFloatKey();
                int count = 1;
                while (iterator.hasNext()) {
                    Float2LongMap.Entry next = (Float2LongMap.Entry)iterator.next();
                    if (next.getLongValue() > maxFrequency) {
                        maxFrequency = next.getLongValue();
                        sum = next.getFloatKey();
                        count = 1;
                        continue;
                    }
                    if (next.getLongValue() != maxFrequency) continue;
                    sum += (double)next.getFloatKey();
                    ++count;
                }
                return sum / (double)count;
            }
        }
        throw new IllegalStateException("Illegal reducer type for MODE aggregation function: " + this._multiModeReducerType);
    }

    @Override
    public Double extractFinalResult(Double2LongOpenHashMap intermediateResult) {
        ObjectIterator iterator = intermediateResult.double2LongEntrySet().fastIterator();
        Double2LongMap.Entry first = (Double2LongMap.Entry)iterator.next();
        long maxFrequency = first.getLongValue();
        switch (this._multiModeReducerType) {
            case MIN: {
                double min = first.getDoubleKey();
                while (iterator.hasNext()) {
                    Double2LongMap.Entry next = (Double2LongMap.Entry)iterator.next();
                    if (next.getLongValue() <= maxFrequency && (next.getLongValue() != maxFrequency || !(min > next.getDoubleKey()))) continue;
                    maxFrequency = next.getLongValue();
                    min = next.getDoubleKey();
                }
                return min;
            }
            case MAX: {
                double max = first.getDoubleKey();
                while (iterator.hasNext()) {
                    Double2LongMap.Entry next = (Double2LongMap.Entry)iterator.next();
                    if (next.getLongValue() <= maxFrequency && (next.getLongValue() != maxFrequency || !(max < next.getDoubleKey()))) continue;
                    maxFrequency = next.getLongValue();
                    max = next.getDoubleKey();
                }
                return max;
            }
            case AVG: {
                double sum = first.getDoubleKey();
                int count = 1;
                while (iterator.hasNext()) {
                    Double2LongMap.Entry next = (Double2LongMap.Entry)iterator.next();
                    if (next.getLongValue() > maxFrequency) {
                        maxFrequency = next.getLongValue();
                        sum = next.getDoubleKey();
                        count = 1;
                        continue;
                    }
                    if (next.getLongValue() != maxFrequency) continue;
                    sum += next.getDoubleKey();
                    ++count;
                }
                return sum / (double)count;
            }
        }
        throw new IllegalStateException("Illegal reducer type for MODE aggregation function: " + this._multiModeReducerType);
    }

    private static final class DictIdsWrapper {
        final Dictionary _dictionary;
        final Int2IntOpenHashMap _dictIdCountMap;

        private DictIdsWrapper(Dictionary dictionary) {
            this._dictionary = dictionary;
            this._dictIdCountMap = new Int2IntOpenHashMap();
        }
    }

    private static enum MultiModeReducerType {
        MIN,
        MAX,
        AVG;

    }
}

