/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.core.query.aggregation.utils.DoubleVectorOpUtils;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class HistogramAggregationFunction
extends BaseSingleInputAggregationFunction<DoubleArrayList, DoubleArrayList> {
    private static final String ARRAY_CONSTRUCTOR = "arrayvalueconstructor";
    private static final int INVALID_BIN = -1;
    double[] _bucketEdges;
    boolean _isEqualLength = false;
    double _lower;
    double _upper;
    double _binLength;

    public HistogramAggregationFunction(List<ExpressionContext> arguments) {
        super(arguments.get(0));
        int numArguments = arguments.size();
        Preconditions.checkArgument((numArguments == 4 || numArguments == 2 ? 1 : 0) != 0, (String)"Histogram expects 2 or 4 arguments, got: %s; usage example: `Histogram(columnName, ARRAY[0,1,10,100])` to specify bins [0,1), [1,10), [10,1000] or `Histogram(columnName, 0, 1000, 10)` to specify 10 equal-length bins [0,100), [100,200), ..., [900,1000]", (int)numArguments);
        if (numArguments == 2) {
            ExpressionContext arrayExpression = arguments.get(1);
            Preconditions.checkArgument((arrayExpression.getType() == ExpressionContext.Type.FUNCTION && arrayExpression.getFunction().getFunctionName().equals(ARRAY_CONSTRUCTOR) ? 1 : 0) != 0, (Object)"Please use the format of `Histogram(columnName, ARRAY[1,10,100])` to specify the bin edges");
            this._bucketEdges = this.parseVector(arrayExpression.getFunction().getArguments());
            this._lower = this._bucketEdges[0];
            this._upper = this._bucketEdges[this._bucketEdges.length - 1];
        } else {
            this._isEqualLength = true;
            this._lower = Double.parseDouble(arguments.get(1).getLiteralString());
            this._upper = Double.parseDouble(arguments.get(2).getLiteralString());
            int numBins = Integer.parseInt(arguments.get(3).getLiteralString());
            Preconditions.checkArgument((this._upper > this._lower ? 1 : 0) != 0, (String)"The right most edge must be greater than left most edge, given %s and %s", (Object)this._lower, (Object)this._upper);
            Preconditions.checkArgument((numBins > 0 ? 1 : 0) != 0, (String)"The number of bins must be greater than zero, given %s", (int)numBins);
            this._bucketEdges = new double[numBins + 1];
            this._bucketEdges[0] = this._lower;
            this._bucketEdges[numBins] = this._upper;
            this._binLength = (this._upper - this._lower) / (double)numBins;
            for (int i = 1; i < numBins; ++i) {
                this._bucketEdges[i] = (double)i * this._binLength + this._lower;
            }
        }
    }

    int getNumBins() {
        return this._bucketEdges.length - 1;
    }

    int getNumEdges() {
        return this._bucketEdges.length;
    }

    private double[] parseVector(List<ExpressionContext> arrayStr) {
        int len = arrayStr.size();
        Preconditions.checkArgument((len > 1 ? 1 : 0) != 0, (Object)"The number of bin edges must be greater than 1");
        double[] ret = new double[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = arrayStr.get(i).getType() == ExpressionContext.Type.IDENTIFIER ? Double.parseDouble(arrayStr.get(i).getIdentifier()) : Double.parseDouble(arrayStr.get(i).getLiteralString());
            if (i <= 0) continue;
            Preconditions.checkState((ret[i] > ret[i - 1] ? 1 : 0) != 0, (Object)"The bin edges must be strictly increasing");
        }
        return ret;
    }

    private int getBinId(double val) {
        int id;
        if (val > this._upper || val < this._lower) {
            return -1;
        }
        if (val == this._upper) {
            return this.getNumBins() - 1;
        }
        if (this._isEqualLength) {
            id = (int)Math.floor((val - this._lower) / this._binLength);
        } else {
            int i = 0;
            int j = this.getNumEdges() - 1;
            while (i < j) {
                int mid = (i + j + 1) / 2;
                if (this._bucketEdges[mid] > val) {
                    j = mid - 1;
                    continue;
                }
                i = mid;
            }
            id = i;
        }
        return id;
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.HISTOGRAM;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public DoubleArrayList extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        DoubleArrayList aggregationResultHolderResult = (DoubleArrayList)aggregationResultHolder.getResult();
        if (aggregationResultHolderResult == null) {
            return DoubleVectorOpUtils.createAndInitialize(this.getNumBins());
        }
        return aggregationResultHolderResult;
    }

    @Override
    public DoubleArrayList extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        return (DoubleArrayList)groupByResultHolder.getResult(groupKey);
    }

    @Override
    public DoubleArrayList merge(DoubleArrayList intermediateResult1, DoubleArrayList intermediateResult2) {
        DoubleVectorOpUtils.vectorAdd(intermediateResult1, intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE_ARRAY;
    }

    @Override
    public DoubleArrayList extractFinalResult(DoubleArrayList doubleArrayList) {
        int count = doubleArrayList.size();
        if ((long)count < 1L) {
            throw new IllegalStateException("histogram result shouldn't be empty!");
        }
        return new DoubleArrayList(doubleArrayList.elements());
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        Preconditions.checkState((boolean)blockValSet.isSingleValue(), (Object)"Histogram currently only supports single-valued column");
        switch (blockValSet.getValueType().getStoredType()) {
            case INT: {
                int[] values = blockValSet.getIntValuesSV();
                for (int i = 0; i < length && i < values.length; ++i) {
                    double value = values[i];
                    for (int groupKey : groupKeysArray[i]) {
                        this.setGroupByResult(groupKey, groupByResultHolder, value);
                    }
                }
                break;
            }
            case LONG: {
                long[] values = blockValSet.getLongValuesSV();
                for (int i = 0; i < length && i < values.length; ++i) {
                    double value = values[i];
                    for (int groupKey : groupKeysArray[i]) {
                        this.setGroupByResult(groupKey, groupByResultHolder, value);
                    }
                }
                break;
            }
            case FLOAT: {
                float[] values = blockValSet.getFloatValuesSV();
                for (int i = 0; i < length && i < values.length; ++i) {
                    double value = values[i];
                    for (int groupKey : groupKeysArray[i]) {
                        this.setGroupByResult(groupKey, groupByResultHolder, value);
                    }
                }
                break;
            }
            case DOUBLE: {
                double[] values = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < length && i < values.length; ++i) {
                    double value = values[i];
                    for (int groupKey : groupKeysArray[i]) {
                        this.setGroupByResult(groupKey, groupByResultHolder, value);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Cannot compute histogram for non-numeric type: " + blockValSet.getValueType());
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        switch (blockValSet.getValueType().getStoredType()) {
            case INT: {
                int[] values = blockValSet.getIntValuesSV();
                for (int i = 0; i < length && i < values.length; ++i) {
                    this.setGroupByResult(groupKeyArray[i], groupByResultHolder, values[i]);
                }
                break;
            }
            case LONG: {
                long[] values = blockValSet.getLongValuesSV();
                for (int i = 0; i < length && i < values.length; ++i) {
                    this.setGroupByResult(groupKeyArray[i], groupByResultHolder, values[i]);
                }
                break;
            }
            case FLOAT: {
                float[] values = blockValSet.getFloatValuesSV();
                for (int i = 0; i < length && i < values.length; ++i) {
                    this.setGroupByResult(groupKeyArray[i], groupByResultHolder, values[i]);
                }
                break;
            }
            case DOUBLE: {
                double[] values = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < length && i < values.length; ++i) {
                    this.setGroupByResult(groupKeyArray[i], groupByResultHolder, values[i]);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Cannot compute histogram for non-numeric type: " + blockValSet.getValueType());
            }
        }
    }

    protected void setGroupByResult(int groupKey, GroupByResultHolder groupByResultHolder, double val) {
        int binID = this.getBinId(val);
        DoubleArrayList byResultHolderResult = (DoubleArrayList)groupByResultHolder.getResult(groupKey);
        if (byResultHolderResult == null) {
            byResultHolderResult = DoubleVectorOpUtils.createAndInitialize(this.getNumBins());
            groupByResultHolder.setValueForKey(groupKey, byResultHolderResult);
        }
        if (binID != -1) {
            DoubleVectorOpUtils.incrementElementByOne(byResultHolderResult, binID);
        }
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        Preconditions.checkState((boolean)blockValSet.isSingleValue(), (Object)"Histogram currently only supports single-valued column");
        double[] histogram = new double[this.getNumBins()];
        switch (blockValSet.getValueType().getStoredType()) {
            case INT: {
                int[] values = blockValSet.getIntValuesSV();
                for (int i = 0; i < length && i < values.length; ++i) {
                    int binId = this.getBinId(values[i]);
                    if (binId == -1) continue;
                    int n = binId;
                    histogram[n] = histogram[n] + 1.0;
                }
                this.setAggregationResult(aggregationResultHolder, histogram);
                break;
            }
            case LONG: {
                long[] values = blockValSet.getLongValuesSV();
                for (int i = 0; i < length && i < values.length; ++i) {
                    int binId = this.getBinId(values[i]);
                    if (binId == -1) continue;
                    int n = binId;
                    histogram[n] = histogram[n] + 1.0;
                }
                this.setAggregationResult(aggregationResultHolder, histogram);
                break;
            }
            case FLOAT: {
                float[] values = blockValSet.getFloatValuesSV();
                for (int i = 0; i < length && i < values.length; ++i) {
                    int binId = this.getBinId(values[i]);
                    if (binId == -1) continue;
                    int n = binId;
                    histogram[n] = histogram[n] + 1.0;
                }
                this.setAggregationResult(aggregationResultHolder, histogram);
                break;
            }
            case DOUBLE: {
                double[] values = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < length && i < values.length; ++i) {
                    int binId = this.getBinId(values[i]);
                    if (binId == -1) continue;
                    int n = binId;
                    histogram[n] = histogram[n] + 1.0;
                }
                this.setAggregationResult(aggregationResultHolder, histogram);
                break;
            }
            default: {
                throw new IllegalStateException("Cannot compute histogram for non-numeric type: " + blockValSet.getValueType());
            }
        }
    }

    protected void setAggregationResult(AggregationResultHolder aggregationResultHolder, double[] histogram) {
        DoubleArrayList aggregatedHistogram = (DoubleArrayList)aggregationResultHolder.getResult();
        if (aggregatedHistogram == null) {
            aggregationResultHolder.setValue(DoubleVectorOpUtils.createAndInitialize(histogram));
        } else {
            DoubleVectorOpUtils.vectorAdd(aggregatedHistogram, histogram);
        }
    }
}

