/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.FirstWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.segment.local.customobject.IntLongPair;
import org.apache.pinot.segment.local.customobject.ValueLongPair;

public class FirstIntValueWithTimeAggregationFunction
extends FirstWithTimeAggregationFunction<Integer> {
    private static final ValueLongPair<Integer> DEFAULT_VALUE_TIME_PAIR = new IntLongPair(Integer.valueOf(Integer.MIN_VALUE), Long.MAX_VALUE);
    private final boolean _isBoolean;

    public FirstIntValueWithTimeAggregationFunction(ExpressionContext dataCol, ExpressionContext timeCol, boolean isBoolean) {
        super(dataCol, timeCol, ObjectSerDeUtils.INT_LONG_PAIR_SER_DE);
        this._isBoolean = isBoolean;
    }

    @Override
    public ValueLongPair<Integer> constructValueLongPair(Integer value, long time) {
        return new IntLongPair(value, time);
    }

    @Override
    public ValueLongPair<Integer> getDefaultValueTimePair() {
        return DEFAULT_VALUE_TIME_PAIR;
    }

    @Override
    public void aggregateResultWithRawData(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet, BlockValSet timeValSet) {
        ValueLongPair<Integer> defaultValueLongPair = this.getDefaultValueTimePair();
        Integer firstData = (Integer)defaultValueLongPair.getValue();
        long firstTime = defaultValueLongPair.getTime();
        int[] intValues = blockValSet.getIntValuesSV();
        long[] timeValues = timeValSet.getLongValuesSV();
        for (int i = 0; i < length; ++i) {
            int data = intValues[i];
            long time = timeValues[i];
            if (time > firstTime) continue;
            firstTime = time;
            firstData = data;
        }
        this.setAggregationResult(aggregationResultHolder, firstData, firstTime);
    }

    @Override
    public void aggregateGroupResultWithRawDataSv(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet, BlockValSet timeValSet) {
        int[] intValues = blockValSet.getIntValuesSV();
        long[] timeValues = timeValSet.getLongValuesSV();
        for (int i = 0; i < length; ++i) {
            int data = intValues[i];
            long time = timeValues[i];
            this.setGroupByResult(groupKeyArray[i], groupByResultHolder, data, time);
        }
    }

    @Override
    public void aggregateGroupResultWithRawDataMv(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet, BlockValSet timeValSet) {
        int[] intValues = blockValSet.getIntValuesSV();
        long[] timeValues = timeValSet.getLongValuesSV();
        for (int i = 0; i < length; ++i) {
            int value = intValues[i];
            long time = timeValues[i];
            for (int groupKey : groupKeysArray[i]) {
                this.setGroupByResult(groupKey, groupByResultHolder, value, time);
            }
        }
    }

    @Override
    public String getResultColumnName() {
        if (this._isBoolean) {
            return this.getType().getName().toLowerCase() + "(" + this._expression + "," + this._timeCol + ",'BOOLEAN')";
        }
        return this.getType().getName().toLowerCase() + "(" + this._expression + "," + this._timeCol + ",'INT')";
    }

    @Override
    public String getColumnName() {
        if (this._isBoolean) {
            return this.getType().getName() + "_" + this._expression + "_" + this._timeCol + "_BOOLEAN";
        }
        return this.getType().getName() + "_" + this._expression + "_" + this._timeCol + "_INT";
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        if (this._isBoolean) {
            return DataSchema.ColumnDataType.BOOLEAN;
        }
        return DataSchema.ColumnDataType.INT;
    }
}

