/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.FirstWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.segment.local.customobject.FloatLongPair;
import org.apache.pinot.segment.local.customobject.ValueLongPair;

public class FirstFloatValueWithTimeAggregationFunction
extends FirstWithTimeAggregationFunction<Float> {
    private static final ValueLongPair<Float> DEFAULT_VALUE_TIME_PAIR = new FloatLongPair(Float.valueOf(Float.NaN), Long.MAX_VALUE);

    public FirstFloatValueWithTimeAggregationFunction(ExpressionContext dataCol, ExpressionContext timeCol) {
        super(dataCol, timeCol, ObjectSerDeUtils.FLOAT_LONG_PAIR_SER_DE);
    }

    @Override
    public ValueLongPair<Float> constructValueLongPair(Float value, long time) {
        return new FloatLongPair(value, time);
    }

    @Override
    public ValueLongPair<Float> getDefaultValueTimePair() {
        return DEFAULT_VALUE_TIME_PAIR;
    }

    @Override
    public void aggregateResultWithRawData(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet, BlockValSet timeValSet) {
        ValueLongPair<Float> defaultValueLongPair = this.getDefaultValueTimePair();
        Float firstData = (Float)defaultValueLongPair.getValue();
        long firstTime = defaultValueLongPair.getTime();
        float[] floatValues = blockValSet.getFloatValuesSV();
        long[] timeValues = timeValSet.getLongValuesSV();
        for (int i = 0; i < length; ++i) {
            float data = floatValues[i];
            long time = timeValues[i];
            if (time > firstTime) continue;
            firstTime = time;
            firstData = Float.valueOf(data);
        }
        this.setAggregationResult(aggregationResultHolder, firstData, firstTime);
    }

    @Override
    public void aggregateGroupResultWithRawDataSv(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet, BlockValSet timeValSet) {
        float[] floatValues = blockValSet.getFloatValuesSV();
        long[] timeValues = timeValSet.getLongValuesSV();
        for (int i = 0; i < length; ++i) {
            float data = floatValues[i];
            long time = timeValues[i];
            this.setGroupByResult(groupKeyArray[i], groupByResultHolder, Float.valueOf(data), time);
        }
    }

    @Override
    public void aggregateGroupResultWithRawDataMv(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet, BlockValSet timeValSet) {
        float[] floatValues = blockValSet.getFloatValuesSV();
        long[] timeValues = timeValSet.getLongValuesSV();
        for (int i = 0; i < length; ++i) {
            float value = floatValues[i];
            long time = timeValues[i];
            for (int groupKey : groupKeysArray[i]) {
                this.setGroupByResult(groupKey, groupByResultHolder, Float.valueOf(value), time);
            }
        }
    }

    @Override
    public String getResultColumnName() {
        return this.getType().getName().toLowerCase() + "(" + this._expression + "," + this._timeCol + ",'FLOAT')";
    }

    @Override
    public String getColumnName() {
        return this.getType().getName() + "_" + this._expression + "_" + this._timeCol + "_FLOAT";
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.FLOAT;
    }
}

