/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;

public abstract class BaseSingleInputAggregationFunction<I, F extends Comparable>
implements AggregationFunction<I, F> {
    protected final ExpressionContext _expression;

    public BaseSingleInputAggregationFunction(ExpressionContext expression) {
        this._expression = expression;
    }

    @Override
    public String getColumnName() {
        return this.getType().getName() + "_" + this._expression;
    }

    @Override
    public String getResultColumnName() {
        return this.getType().getName().toLowerCase() + "(" + this._expression + ")";
    }

    @Override
    public List<ExpressionContext> getInputExpressions() {
        return Collections.singletonList(this._expression);
    }

    @Override
    public String toExplainString() {
        StringBuilder stringBuilder = new StringBuilder(this.getType().getName()).append('(');
        int numArguments = this.getInputExpressions().size();
        if (numArguments > 0) {
            stringBuilder.append(this.getInputExpressions().get(0).toString());
            for (int i = 1; i < numArguments; ++i) {
                stringBuilder.append(", ").append(this.getInputExpressions().get(i).toString());
            }
        }
        return stringBuilder.append(')').toString();
    }
}

