/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AvgAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AvgMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.BooleanAndAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.BooleanOrAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.CountAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.CountMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.CovarianceAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountBitmapAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountBitmapMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountHLLAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountHLLMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountRawHLLAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountRawHLLMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountRawThetaSketchAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountSmartHLLAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountThetaSketchAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.FastHLLAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.FirstDoubleValueWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.FirstFloatValueWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.FirstIntValueWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.FirstLongValueWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.FirstStringValueWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.FourthMomentAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.HistogramAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.IdSetAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.LastDoubleValueWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.LastFloatValueWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.LastIntValueWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.LastLongValueWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.LastStringValueWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.MaxAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.MaxMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.MinAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.MinMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.MinMaxRangeAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.MinMaxRangeMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.ModeAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileEstAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileEstMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileRawEstAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileRawEstMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileRawTDigestAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileRawTDigestMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileSmartTDigestAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileTDigestAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileTDigestMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.SegmentPartitionedDistinctCountAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.StUnionAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.SumAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.SumMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.SumPrecisionAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.VarianceAggregationFunction;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.exception.BadQueryRequestException;

public class AggregationFunctionFactory {
    private AggregationFunctionFactory() {
    }

    public static AggregationFunction getAggregationFunction(FunctionContext function, QueryContext queryContext) {
        try {
            String upperCaseFunctionName = StringUtils.remove((String)function.getFunctionName(), (char)'_').toUpperCase();
            List arguments = function.getArguments();
            ExpressionContext firstArgument = (ExpressionContext)arguments.get(0);
            if (upperCaseFunctionName.startsWith("PERCENTILE")) {
                String remainingFunctionName = upperCaseFunctionName.substring(10);
                if (remainingFunctionName.equals("SMARTTDIGEST")) {
                    return new PercentileSmartTDigestAggregationFunction(arguments);
                }
                int numArguments = arguments.size();
                if (numArguments == 1) {
                    if (remainingFunctionName.matches("\\d+")) {
                        return new PercentileAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentileToInt(remainingFunctionName));
                    }
                    if (remainingFunctionName.matches("EST\\d+")) {
                        String percentileString = remainingFunctionName.substring(3);
                        return new PercentileEstAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentileToInt(percentileString));
                    }
                    if (remainingFunctionName.matches("RAWEST\\d+")) {
                        String percentileString = remainingFunctionName.substring(6);
                        return new PercentileRawEstAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentileToInt(percentileString));
                    }
                    if (remainingFunctionName.matches("TDIGEST\\d+")) {
                        String percentileString = remainingFunctionName.substring(7);
                        return new PercentileTDigestAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentileToInt(percentileString));
                    }
                    if (remainingFunctionName.matches("RAWTDIGEST\\d+")) {
                        String percentileString = remainingFunctionName.substring(10);
                        return new PercentileRawTDigestAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentileToInt(percentileString));
                    }
                    if (remainingFunctionName.matches("\\d+MV")) {
                        String percentileString = remainingFunctionName.substring(0, remainingFunctionName.length() - 2);
                        return new PercentileMVAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentileToInt(percentileString));
                    }
                    if (remainingFunctionName.matches("EST\\d+MV")) {
                        String percentileString = remainingFunctionName.substring(3, remainingFunctionName.length() - 2);
                        return new PercentileEstMVAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentileToInt(percentileString));
                    }
                    if (remainingFunctionName.matches("RAWEST\\d+MV")) {
                        String percentileString = remainingFunctionName.substring(6, remainingFunctionName.length() - 2);
                        return new PercentileRawEstMVAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentileToInt(percentileString));
                    }
                    if (remainingFunctionName.matches("TDIGEST\\d+MV")) {
                        String percentileString = remainingFunctionName.substring(7, remainingFunctionName.length() - 2);
                        return new PercentileTDigestMVAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentileToInt(percentileString));
                    }
                    if (remainingFunctionName.matches("RAWTDIGEST\\d+MV")) {
                        String percentileString = remainingFunctionName.substring(10, remainingFunctionName.length() - 2);
                        return new PercentileRawTDigestMVAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentileToInt(percentileString));
                    }
                } else if (numArguments == 2) {
                    double percentile = AggregationFunctionFactory.parsePercentileToDouble(((ExpressionContext)arguments.get(1)).getLiteralString());
                    if (remainingFunctionName.isEmpty()) {
                        return new PercentileAggregationFunction(firstArgument, percentile);
                    }
                    if (remainingFunctionName.equals("EST")) {
                        return new PercentileEstAggregationFunction(firstArgument, percentile);
                    }
                    if (remainingFunctionName.equals("RAWEST")) {
                        return new PercentileRawEstAggregationFunction(firstArgument, percentile);
                    }
                    if (remainingFunctionName.equals("TDIGEST")) {
                        return new PercentileTDigestAggregationFunction(firstArgument, percentile);
                    }
                    if (remainingFunctionName.equals("RAWTDIGEST")) {
                        return new PercentileRawTDigestAggregationFunction(firstArgument, percentile);
                    }
                    if (remainingFunctionName.equals("MV")) {
                        return new PercentileMVAggregationFunction(firstArgument, percentile);
                    }
                    if (remainingFunctionName.equals("ESTMV")) {
                        return new PercentileEstMVAggregationFunction(firstArgument, percentile);
                    }
                    if (remainingFunctionName.equals("RAWESTMV")) {
                        return new PercentileRawEstMVAggregationFunction(firstArgument, percentile);
                    }
                    if (remainingFunctionName.equals("TDIGESTMV")) {
                        return new PercentileTDigestMVAggregationFunction(firstArgument, percentile);
                    }
                    if (remainingFunctionName.equals("RAWTDIGESTMV")) {
                        return new PercentileRawTDigestMVAggregationFunction(firstArgument, percentile);
                    }
                }
                throw new IllegalArgumentException("Invalid percentile function: " + function);
            }
            switch (AggregationFunctionType.valueOf((String)upperCaseFunctionName)) {
                case COUNT: {
                    return new CountAggregationFunction(firstArgument, queryContext.isNullHandlingEnabled());
                }
                case MIN: {
                    return new MinAggregationFunction(firstArgument, queryContext.isNullHandlingEnabled());
                }
                case MAX: {
                    return new MaxAggregationFunction(firstArgument, queryContext.isNullHandlingEnabled());
                }
                case SUM: {
                    return new SumAggregationFunction(firstArgument, queryContext.isNullHandlingEnabled());
                }
                case SUMPRECISION: {
                    return new SumPrecisionAggregationFunction(arguments, queryContext.isNullHandlingEnabled());
                }
                case AVG: {
                    return new AvgAggregationFunction(firstArgument, queryContext.isNullHandlingEnabled());
                }
                case MODE: {
                    return new ModeAggregationFunction(arguments);
                }
                case FIRSTWITHTIME: {
                    if (arguments.size() == 3) {
                        ExpressionContext timeCol = (ExpressionContext)arguments.get(1);
                        ExpressionContext dataType = (ExpressionContext)arguments.get(2);
                        if (dataType.getType() != ExpressionContext.Type.LITERAL) {
                            throw new IllegalArgumentException("Third argument of firstWithTime Function should be literal. The function can be used as firstWithTime(dataColumn, timeColumn, 'dataType')");
                        }
                        FieldSpec.DataType fieldDataType = FieldSpec.DataType.valueOf((String)dataType.getLiteralString().toUpperCase());
                        switch (fieldDataType) {
                            case BOOLEAN: 
                            case INT: {
                                return new FirstIntValueWithTimeAggregationFunction(firstArgument, timeCol, fieldDataType == FieldSpec.DataType.BOOLEAN);
                            }
                            case LONG: {
                                return new FirstLongValueWithTimeAggregationFunction(firstArgument, timeCol);
                            }
                            case FLOAT: {
                                return new FirstFloatValueWithTimeAggregationFunction(firstArgument, timeCol);
                            }
                            case DOUBLE: {
                                return new FirstDoubleValueWithTimeAggregationFunction(firstArgument, timeCol);
                            }
                            case STRING: {
                                return new FirstStringValueWithTimeAggregationFunction(firstArgument, timeCol);
                            }
                        }
                        throw new IllegalArgumentException("Unsupported Value Type for firstWithTime Function:" + dataType);
                    }
                    throw new IllegalArgumentException("Three arguments are required for firstWithTime Function. The function can be used as firstWithTime(dataColumn, timeColumn, 'dataType')");
                }
                case LASTWITHTIME: {
                    if (arguments.size() == 3) {
                        ExpressionContext timeCol = (ExpressionContext)arguments.get(1);
                        ExpressionContext dataType = (ExpressionContext)arguments.get(2);
                        if (dataType.getType() != ExpressionContext.Type.LITERAL) {
                            throw new IllegalArgumentException("Third argument of lastWithTime Function should be literal. The function can be used as lastWithTime(dataColumn, timeColumn, 'dataType')");
                        }
                        FieldSpec.DataType fieldDataType = FieldSpec.DataType.valueOf((String)dataType.getLiteralString().toUpperCase());
                        switch (fieldDataType) {
                            case BOOLEAN: 
                            case INT: {
                                return new LastIntValueWithTimeAggregationFunction(firstArgument, timeCol, fieldDataType == FieldSpec.DataType.BOOLEAN);
                            }
                            case LONG: {
                                return new LastLongValueWithTimeAggregationFunction(firstArgument, timeCol);
                            }
                            case FLOAT: {
                                return new LastFloatValueWithTimeAggregationFunction(firstArgument, timeCol);
                            }
                            case DOUBLE: {
                                return new LastDoubleValueWithTimeAggregationFunction(firstArgument, timeCol);
                            }
                            case STRING: {
                                return new LastStringValueWithTimeAggregationFunction(firstArgument, timeCol);
                            }
                        }
                        throw new IllegalArgumentException("Unsupported Value Type for lastWithTime Function:" + dataType);
                    }
                    throw new IllegalArgumentException("Three arguments are required for lastWithTime Function. The function can be used as lastWithTime(dataColumn, timeColumn, 'dataType')");
                }
                case MINMAXRANGE: {
                    return new MinMaxRangeAggregationFunction(firstArgument);
                }
                case DISTINCTCOUNT: {
                    return new DistinctCountAggregationFunction(firstArgument);
                }
                case DISTINCTCOUNTBITMAP: {
                    return new DistinctCountBitmapAggregationFunction(firstArgument);
                }
                case SEGMENTPARTITIONEDDISTINCTCOUNT: {
                    return new SegmentPartitionedDistinctCountAggregationFunction(firstArgument);
                }
                case DISTINCTCOUNTHLL: {
                    return new DistinctCountHLLAggregationFunction(arguments);
                }
                case DISTINCTCOUNTRAWHLL: {
                    return new DistinctCountRawHLLAggregationFunction(arguments);
                }
                case DISTINCTCOUNTSMARTHLL: {
                    return new DistinctCountSmartHLLAggregationFunction(arguments);
                }
                case FASTHLL: {
                    return new FastHLLAggregationFunction(firstArgument);
                }
                case DISTINCTCOUNTTHETASKETCH: {
                    return new DistinctCountThetaSketchAggregationFunction(arguments);
                }
                case DISTINCTCOUNTRAWTHETASKETCH: {
                    return new DistinctCountRawThetaSketchAggregationFunction(arguments);
                }
                case IDSET: {
                    return new IdSetAggregationFunction(arguments);
                }
                case COUNTMV: {
                    return new CountMVAggregationFunction(firstArgument);
                }
                case MINMV: {
                    return new MinMVAggregationFunction(firstArgument);
                }
                case MAXMV: {
                    return new MaxMVAggregationFunction(firstArgument);
                }
                case SUMMV: {
                    return new SumMVAggregationFunction(firstArgument);
                }
                case AVGMV: {
                    return new AvgMVAggregationFunction(firstArgument);
                }
                case MINMAXRANGEMV: {
                    return new MinMaxRangeMVAggregationFunction(firstArgument);
                }
                case DISTINCTCOUNTMV: {
                    return new DistinctCountMVAggregationFunction(firstArgument);
                }
                case DISTINCTCOUNTBITMAPMV: {
                    return new DistinctCountBitmapMVAggregationFunction(firstArgument);
                }
                case DISTINCTCOUNTHLLMV: {
                    return new DistinctCountHLLMVAggregationFunction(arguments);
                }
                case DISTINCTCOUNTRAWHLLMV: {
                    return new DistinctCountRawHLLMVAggregationFunction(arguments);
                }
                case DISTINCT: {
                    return new DistinctAggregationFunction(arguments, queryContext.getOrderByExpressions(), queryContext.getLimit());
                }
                case STUNION: {
                    return new StUnionAggregationFunction(firstArgument);
                }
                case HISTOGRAM: {
                    return new HistogramAggregationFunction(arguments);
                }
                case COVARPOP: {
                    return new CovarianceAggregationFunction(arguments, false);
                }
                case COVARSAMP: {
                    return new CovarianceAggregationFunction(arguments, true);
                }
                case BOOLAND: {
                    return new BooleanAndAggregationFunction(firstArgument, queryContext.isNullHandlingEnabled());
                }
                case BOOLOR: {
                    return new BooleanOrAggregationFunction(firstArgument, queryContext.isNullHandlingEnabled());
                }
                case VARPOP: {
                    return new VarianceAggregationFunction(firstArgument, false, false);
                }
                case VARSAMP: {
                    return new VarianceAggregationFunction(firstArgument, true, false);
                }
                case STDDEVPOP: {
                    return new VarianceAggregationFunction(firstArgument, false, true);
                }
                case STDDEVSAMP: {
                    return new VarianceAggregationFunction(firstArgument, true, true);
                }
                case SKEWNESS: {
                    return new FourthMomentAggregationFunction(firstArgument, FourthMomentAggregationFunction.Type.SKEWNESS);
                }
                case KURTOSIS: {
                    return new FourthMomentAggregationFunction(firstArgument, FourthMomentAggregationFunction.Type.KURTOSIS);
                }
            }
            throw new IllegalArgumentException();
        }
        catch (Exception e) {
            throw new BadQueryRequestException("Invalid aggregation function: " + function + "; Reason: " + e.getMessage());
        }
    }

    private static int parsePercentileToInt(String percentileString) {
        int percentile = Integer.parseInt(percentileString);
        Preconditions.checkArgument((percentile >= 0 && percentile <= 100 ? 1 : 0) != 0, (String)"Invalid percentile: %s", (int)percentile);
        return percentile;
    }

    private static double parsePercentileToDouble(String percentileString) {
        double percentile = Double.parseDouble(percentileString);
        Preconditions.checkArgument((percentile >= 0.0 && percentile <= 100.0 ? 1 : 0) != 0, (String)"Invalid percentile: %s", (Object)percentile);
        return percentile;
    }
}

