/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import java.util.HashMap;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.core.operator.DocIdSetOperator;
import org.apache.pinot.core.operator.ProjectionOperator;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.datasource.DataSource;

public class ProjectionPlanNode
implements PlanNode {
    private final IndexSegment _indexSegment;
    private final QueryContext _queryContext;
    private final Set<String> _projectionColumns;
    private final int _maxDocsPerCall;
    private final BaseFilterOperator _filterOperator;

    public ProjectionPlanNode(IndexSegment indexSegment, QueryContext queryContext, Set<String> projectionColumns, int maxDocsPerCall, @Nullable BaseFilterOperator filterOperator) {
        this._indexSegment = indexSegment;
        this._queryContext = queryContext;
        this._projectionColumns = projectionColumns;
        this._maxDocsPerCall = maxDocsPerCall;
        this._filterOperator = filterOperator;
    }

    public ProjectionOperator run() {
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>(this._projectionColumns.size());
        for (String column : this._projectionColumns) {
            dataSourceMap.put(column, this._indexSegment.getDataSource(column));
        }
        DocIdSetOperator docIdSetOperator = this._maxDocsPerCall > 0 ? new DocIdSetPlanNode(this._indexSegment, this._queryContext, this._maxDocsPerCall, this._filterOperator).run() : null;
        return new ProjectionOperator(dataSourceMap, docIdSetOperator);
    }
}

