/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import java.util.concurrent.TimeoutException;
import org.apache.pinot.core.operator.InstanceResponseOperator;
import org.apache.pinot.core.operator.blocks.InstanceResponseBlock;
import org.apache.pinot.core.plan.InstanceResponsePlanNode;
import org.apache.pinot.core.plan.Plan;
import org.apache.pinot.core.plan.PlanNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalPlanImplV0
implements Plan {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalPlanImplV0.class);
    private final InstanceResponsePlanNode _instanceResponsePlanNode;

    public GlobalPlanImplV0(InstanceResponsePlanNode instanceResponsePlanNode) {
        this._instanceResponsePlanNode = instanceResponsePlanNode;
    }

    @Override
    public PlanNode getPlanNode() {
        return this._instanceResponsePlanNode;
    }

    @Override
    public InstanceResponseBlock execute() throws TimeoutException {
        long startTime = System.currentTimeMillis();
        InstanceResponseOperator instanceResponseOperator = this._instanceResponsePlanNode.run();
        long endTime1 = System.currentTimeMillis();
        LOGGER.debug("InstanceResponsePlanNode.run() took: {}ms", (Object)(endTime1 - startTime));
        if (endTime1 > this._instanceResponsePlanNode._queryContext.getEndTimeMs()) {
            throw new TimeoutException("Query timed out while generating physical execution plan");
        }
        InstanceResponseBlock instanceResponseBlock = (InstanceResponseBlock)instanceResponseOperator.nextBlock();
        long endTime2 = System.currentTimeMillis();
        LOGGER.debug("InstanceResponseOperator.nextBlock() took: {}ms", (Object)(endTime2 - endTime1));
        return instanceResponseBlock;
    }
}

