/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class ValueInTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "valueIn";
    private TransformFunction _mainTransformFunction;
    private TransformResultMetadata _resultMetadata;
    private Dictionary _dictionary;
    private IntSet _dictIdSet;
    private int[][] _dictIds;
    private IntSet _intValueSet;
    private LongSet _longValueSet;
    private FloatSet _floatValueSet;
    private DoubleSet _doubleValueSet;
    private Set<String> _stringValueSet;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        int numArguments = arguments.size();
        if (numArguments < 2) {
            throw new IllegalArgumentException("At least 2 arguments are required for VALUE_IN transform function");
        }
        TransformFunction firstArgument = arguments.get(0);
        if (firstArgument instanceof LiteralTransformFunction || firstArgument.getResultMetadata().isSingleValue()) {
            throw new IllegalArgumentException("The first argument of VALUE_IN transform function must be a multi-valued column or a transform function");
        }
        this._mainTransformFunction = firstArgument;
        this._resultMetadata = this._mainTransformFunction.getResultMetadata();
        this._dictionary = this._mainTransformFunction.getDictionary();
        this._stringValueSet = new HashSet<String>(numArguments - 1);
        for (int i = 1; i < numArguments; ++i) {
            this._stringValueSet.add(((LiteralTransformFunction)arguments.get(i)).getLiteral());
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public Dictionary getDictionary() {
        return this._dictionary;
    }

    @Override
    public int[][] transformToDictIdsMV(ProjectionBlock projectionBlock) {
        int length = projectionBlock.getNumDocs();
        if (this._dictIdSet == null) {
            this._dictIdSet = new IntOpenHashSet();
            assert (this._dictionary != null);
            for (String inValue : this._stringValueSet) {
                int dictId = this._dictionary.indexOf(inValue);
                if (dictId < 0) continue;
                this._dictIdSet.add(dictId);
            }
            if (this._dictIds == null) {
                this._dictIds = new int[length][];
            }
        }
        int[][] unFilteredDictIds = this._mainTransformFunction.transformToDictIdsMV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._dictIds[i] = ValueInTransformFunction.filterInts(this._dictIdSet, unFilteredDictIds[i]);
        }
        return this._dictIds;
    }

    @Override
    public int[][] transformToIntValuesMV(ProjectionBlock projectionBlock) {
        if (this._dictionary != null || this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.INT) {
            return super.transformToIntValuesMV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._intValueSet == null) {
            this._intValueSet = new IntOpenHashSet();
            for (String inValue : this._stringValueSet) {
                this._intValueSet.add(Integer.parseInt(inValue));
            }
            if (this._intValuesMV == null) {
                this._intValuesMV = new int[length][];
            }
        }
        int[][] unFilteredIntValues = this._mainTransformFunction.transformToIntValuesMV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesMV[i] = ValueInTransformFunction.filterInts(this._intValueSet, unFilteredIntValues[i]);
        }
        return this._intValuesMV;
    }

    @Override
    public long[][] transformToLongValuesMV(ProjectionBlock projectionBlock) {
        if (this._dictionary != null || this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.LONG) {
            return super.transformToLongValuesMV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._longValueSet == null) {
            this._longValueSet = new LongOpenHashSet();
            for (String inValue : this._stringValueSet) {
                this._longValueSet.add(Long.parseLong(inValue));
            }
            if (this._longValuesMV == null) {
                this._longValuesMV = new long[length][];
            }
        }
        long[][] unFilteredLongValues = this._mainTransformFunction.transformToLongValuesMV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._longValuesMV[i] = ValueInTransformFunction.filterLongs(this._longValueSet, unFilteredLongValues[i]);
        }
        return this._longValuesMV;
    }

    @Override
    public float[][] transformToFloatValuesMV(ProjectionBlock projectionBlock) {
        if (this._dictionary != null || this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.FLOAT) {
            return super.transformToFloatValuesMV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._floatValueSet == null) {
            this._floatValueSet = new FloatOpenHashSet();
            for (String inValue : this._stringValueSet) {
                this._floatValueSet.add(Float.parseFloat(inValue));
            }
            if (this._floatValuesMV == null) {
                this._floatValuesMV = new float[length][];
            }
        }
        float[][] unFilteredFloatValues = this._mainTransformFunction.transformToFloatValuesMV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._floatValuesMV[i] = ValueInTransformFunction.filterFloats(this._floatValueSet, unFilteredFloatValues[i]);
        }
        return this._floatValuesMV;
    }

    @Override
    public double[][] transformToDoubleValuesMV(ProjectionBlock projectionBlock) {
        if (this._dictionary != null || this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.DOUBLE) {
            return super.transformToDoubleValuesMV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._doubleValueSet == null) {
            this._doubleValueSet = new DoubleOpenHashSet();
            for (String inValue : this._stringValueSet) {
                this._doubleValueSet.add(Double.parseDouble(inValue));
            }
            if (this._doubleValuesMV == null) {
                this._doubleValuesMV = new double[length][];
            }
        }
        double[][] unFilteredDoubleValues = this._mainTransformFunction.transformToDoubleValuesMV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._doubleValuesMV[i] = ValueInTransformFunction.filterDoubles(this._doubleValueSet, unFilteredDoubleValues[i]);
        }
        return this._doubleValuesMV;
    }

    @Override
    public String[][] transformToStringValuesMV(ProjectionBlock projectionBlock) {
        if (this._dictionary != null || this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.STRING) {
            return super.transformToStringValuesMV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._stringValuesMV == null) {
            this._stringValuesMV = new String[length][];
        }
        String[][] unFilteredStringValues = this._mainTransformFunction.transformToStringValuesMV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._stringValuesMV[i] = ValueInTransformFunction.filterStrings(this._stringValueSet, unFilteredStringValues[i]);
        }
        return this._stringValuesMV;
    }

    private static int[] filterInts(IntSet intSet, int[] source) {
        IntArrayList intList = new IntArrayList();
        for (int value : source) {
            if (!intSet.contains(value)) continue;
            intList.add(value);
        }
        if (intList.size() == source.length) {
            return source;
        }
        return intList.toIntArray();
    }

    private static long[] filterLongs(LongSet longSet, long[] source) {
        LongArrayList longList = new LongArrayList();
        for (long value : source) {
            if (!longSet.contains(value)) continue;
            longList.add(value);
        }
        if (longList.size() == source.length) {
            return source;
        }
        return longList.toLongArray();
    }

    private static float[] filterFloats(FloatSet floatSet, float[] source) {
        FloatArrayList floatList = new FloatArrayList();
        for (float value : source) {
            if (!floatSet.contains(value)) continue;
            floatList.add(value);
        }
        if (floatList.size() == source.length) {
            return source;
        }
        return floatList.toFloatArray();
    }

    private static double[] filterDoubles(DoubleSet doubleSet, double[] source) {
        DoubleArrayList doubleList = new DoubleArrayList();
        for (double value : source) {
            if (!doubleSet.contains(value)) continue;
            doubleList.add(value);
        }
        if (doubleList.size() == source.length) {
            return source;
        }
        return doubleList.toDoubleArray();
    }

    private static String[] filterStrings(Set<String> stringSet, String[] source) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (String value : source) {
            if (!stringSet.contains(value)) continue;
            stringList.add(value);
        }
        if (stringList.size() == source.length) {
            return source;
        }
        return stringList.toArray(new String[0]);
    }
}

