/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;

public class RegexpExtractTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "REGEXP_EXTRACT";
    private TransformFunction _valueFunction;
    private Pattern _regexp;
    private int _group;
    private String _defaultValue;
    private TransformResultMetadata _resultMetadata;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        Preconditions.checkArgument((arguments.size() >= 2 && arguments.size() <= 4 ? 1 : 0) != 0, (Object)"REGEXP_EXTRACT takes between 2 to 4 arguments. See usage: REGEXP_EXTRACT(`value`, `regexp`[, `group`[, `default_value`]]");
        this._valueFunction = arguments.get(0);
        TransformFunction regexpFunction = arguments.get(1);
        Preconditions.checkState((boolean)(regexpFunction instanceof LiteralTransformFunction), (Object)"`regexp` must be a literal regex expression.");
        this._regexp = Pattern.compile(((LiteralTransformFunction)regexpFunction).getLiteral());
        if (arguments.size() >= 3) {
            TransformFunction groupFunction = arguments.get(2);
            Preconditions.checkState((groupFunction instanceof LiteralTransformFunction && Integer.parseInt(((LiteralTransformFunction)groupFunction).getLiteral()) >= 0 ? 1 : 0) != 0, (Object)"`group` must be a literal, non-negative integer.");
            this._group = Integer.parseInt(((LiteralTransformFunction)groupFunction).getLiteral());
        } else {
            this._group = 0;
        }
        if (arguments.size() == 4) {
            TransformFunction positionFunction = arguments.get(3);
            Preconditions.checkState((boolean)(positionFunction instanceof LiteralTransformFunction), (Object)"`default_value` must be a literal expression.");
            this._defaultValue = ((LiteralTransformFunction)regexpFunction).getLiteral();
        } else {
            this._defaultValue = "";
        }
        this._resultMetadata = STRING_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        int length = projectionBlock.getNumDocs();
        if (this._stringValuesSV == null) {
            this._stringValuesSV = new String[length];
        }
        String[] valuesSV = this._valueFunction.transformToStringValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            Matcher matcher = this._regexp.matcher(valuesSV[i]);
            this._stringValuesSV[i] = matcher.find() && matcher.groupCount() >= this._group ? matcher.group(this._group) : this._defaultValue;
        }
        return this._stringValuesSV;
    }
}

