/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;

public abstract class LogicalOperatorTransformFunction
extends BaseTransformFunction {
    protected List<TransformFunction> _arguments;

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        this._arguments = arguments;
        int numArguments = arguments.size();
        if (numArguments <= 1) {
            throw new IllegalArgumentException("Expect more than 1 argument for logical operator [" + this.getName() + "], args [" + Arrays.toString(arguments.toArray()) + "].");
        }
        for (int i = 0; i < numArguments; ++i) {
            TransformResultMetadata argumentMetadata = arguments.get(i).getResultMetadata();
            if (argumentMetadata.isSingleValue() && argumentMetadata.getDataType().getStoredType().isNumeric()) continue;
            throw new IllegalArgumentException("Unsupported argument of index: " + i + ", expecting single-valued boolean/number");
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return BOOLEAN_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        if (this._intValuesSV == null) {
            this._intValuesSV = new int[numDocs];
        }
        System.arraycopy(this._arguments.get(0).transformToIntValuesSV(projectionBlock), 0, this._intValuesSV, 0, numDocs);
        int numArguments = this._arguments.size();
        for (int i = 1; i < numArguments; ++i) {
            TransformFunction transformFunction = this._arguments.get(i);
            int[] results = transformFunction.transformToIntValuesSV(projectionBlock);
            for (int j = 0; j < numDocs; ++j) {
                this._intValuesSV[j] = this.getLogicalFuncResult(this._intValuesSV[j], results[j]);
            }
        }
        return this._intValuesSV;
    }

    abstract int getLogicalFuncResult(int var1, int var2);
}

