/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.chrono.ISOChronology;

public class ExtractTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "extract";
    private TransformFunction _mainTransformFunction;
    protected Field _field;
    protected Chronology _chronology = ISOChronology.getInstanceUTC();

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        if (arguments.size() != 2) {
            throw new IllegalArgumentException("Exactly 2 arguments are required for EXTRACT transform function");
        }
        this._field = Field.valueOf(((LiteralTransformFunction)arguments.get(0)).getLiteral());
        this._mainTransformFunction = arguments.get(1);
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return INT_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        if (this._intValuesSV == null) {
            this._intValuesSV = new int[numDocs];
        }
        long[] timestamps = this._mainTransformFunction.transformToLongValuesSV(projectionBlock);
        this.convert(timestamps, numDocs, this._intValuesSV);
        return this._intValuesSV;
    }

    private void convert(long[] timestamps, int numDocs, int[] output) {
        block8: for (int i = 0; i < numDocs; ++i) {
            switch (this._field) {
                case YEAR: {
                    DateTimeField accessor = this._chronology.year();
                    output[i] = accessor.get(timestamps[i]);
                    continue block8;
                }
                case MONTH: {
                    DateTimeField accessor = this._chronology.monthOfYear();
                    output[i] = accessor.get(timestamps[i]);
                    continue block8;
                }
                case DAY: {
                    DateTimeField accessor = this._chronology.dayOfMonth();
                    output[i] = accessor.get(timestamps[i]);
                    continue block8;
                }
                case HOUR: {
                    DateTimeField accessor = this._chronology.hourOfDay();
                    output[i] = accessor.get(timestamps[i]);
                    continue block8;
                }
                case MINUTE: {
                    DateTimeField accessor = this._chronology.minuteOfHour();
                    output[i] = accessor.get(timestamps[i]);
                    continue block8;
                }
                case SECOND: {
                    DateTimeField accessor = this._chronology.secondOfMinute();
                    output[i] = accessor.get(timestamps[i]);
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported FIELD type");
                }
            }
        }
    }

    private static enum Field {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND;

    }
}

