/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BinaryOperatorTransformFunction;
import org.apache.pinot.core.operator.transform.function.IdentifierTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.roaringbitmap.RoaringBitmap;

public class DistinctFromTransformFunction
extends BinaryOperatorTransformFunction {
    private final int _distinctResult;
    private final int _notDistinctResult;

    @Nullable
    private static RoaringBitmap getNullBitMap(ProjectionBlock projectionBlock, TransformFunction transformFunction) {
        String columnName = ((IdentifierTransformFunction)transformFunction).getColumnName();
        return projectionBlock.getBlockValueSet(columnName).getNullBitmap();
    }

    private static boolean isEmpty(RoaringBitmap bitmap) {
        return bitmap == null || bitmap.isEmpty();
    }

    protected DistinctFromTransformFunction(boolean distinct) {
        super(distinct ? TransformFunctionType.NOT_EQUALS : TransformFunctionType.EQUALS);
        this._distinctResult = distinct ? 1 : 0;
        this._notDistinctResult = distinct ? 0 : 1;
    }

    @Override
    public String getName() {
        if (this._distinctResult == 1) {
            return TransformFunctionType.IS_DISTINCT_FROM.getName();
        }
        return TransformFunctionType.IS_NOT_DISTINCT_FROM.getName();
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        super.init(arguments, dataSourceMap);
        if (!(this._leftTransformFunction instanceof IdentifierTransformFunction) || !(this._rightTransformFunction instanceof IdentifierTransformFunction)) {
            throw new IllegalArgumentException("Only column names are supported in DistinctFrom transformation.");
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return BOOLEAN_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        this._intValuesSV = super.transformToIntValuesSV(projectionBlock);
        RoaringBitmap leftNull = DistinctFromTransformFunction.getNullBitMap(projectionBlock, this._leftTransformFunction);
        RoaringBitmap rightNull = DistinctFromTransformFunction.getNullBitMap(projectionBlock, this._rightTransformFunction);
        if (DistinctFromTransformFunction.isEmpty(leftNull) && DistinctFromTransformFunction.isEmpty(rightNull)) {
            return this._intValuesSV;
        }
        if (DistinctFromTransformFunction.isEmpty(leftNull)) {
            rightNull.forEach(i -> {
                this._intValuesSV[i] = this._distinctResult;
            });
            return this._intValuesSV;
        }
        if (DistinctFromTransformFunction.isEmpty(rightNull)) {
            leftNull.forEach(i -> {
                this._intValuesSV[i] = this._distinctResult;
            });
            return this._intValuesSV;
        }
        RoaringBitmap xorNull = RoaringBitmap.xor((RoaringBitmap)leftNull, (RoaringBitmap)rightNull);
        xorNull.forEach(i -> {
            this._intValuesSV[i] = this._distinctResult;
        });
        RoaringBitmap andNull = RoaringBitmap.and((RoaringBitmap)leftNull, (RoaringBitmap)rightNull);
        andNull.forEach(i -> {
            this._intValuesSV[i] = this._notDistinctResult;
        });
        return this._intValuesSV;
    }
}

