/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.IdentifierTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RoaringBitmap;

public class CoalesceTransformFunction
extends BaseTransformFunction {
    public static final int NULL_INT = Integer.MIN_VALUE;
    public static final long NULL_LONG = Long.MIN_VALUE;
    public static final float NULL_FLOAT = Float.NEGATIVE_INFINITY;
    public static final double NULL_DOUBLE = Double.NEGATIVE_INFINITY;
    public static final BigDecimal NULL_BIG_DECIMAL = BigDecimal.valueOf(Long.MIN_VALUE);
    public static final String NULL_STRING = "null";
    private TransformFunction[] _transformFunctions;
    private FieldSpec.DataType _dataType;
    private TransformResultMetadata _resultMetadata;

    private static RoaringBitmap[] getNullBitMaps(ProjectionBlock projectionBlock, TransformFunction[] transformFunctions) {
        RoaringBitmap[] roaringBitmaps = new RoaringBitmap[transformFunctions.length];
        for (int i = 0; i < roaringBitmaps.length; ++i) {
            TransformFunction func = transformFunctions[i];
            if (func instanceof IdentifierTransformFunction) {
                RoaringBitmap nullBitmap;
                String columnName = ((IdentifierTransformFunction)func).getColumnName();
                roaringBitmaps[i] = nullBitmap = projectionBlock.getBlockValueSet(columnName).getNullBitmap();
                continue;
            }
            roaringBitmaps[i] = new RoaringBitmap();
        }
        return roaringBitmaps;
    }

    private int[] getIntTransformResults(ProjectionBlock projectionBlock) {
        int length = projectionBlock.getNumDocs();
        if (this._intValuesSV == null) {
            this._intValuesSV = new int[length];
        }
        int width = this._transformFunctions.length;
        RoaringBitmap[] nullBitMaps = CoalesceTransformFunction.getNullBitMaps(projectionBlock, this._transformFunctions);
        int[][] data = new int[width][length];
        RoaringBitmap filledData = new RoaringBitmap();
        for (int i = 0; i < length; ++i) {
            boolean hasNonNullValue = false;
            for (int j = 0; j < width; ++j) {
                if (nullBitMaps[j] != null && nullBitMaps[j].contains(i)) continue;
                if (!filledData.contains(j)) {
                    filledData.add(j);
                    data[j] = this._transformFunctions[j].transformToIntValuesSV(projectionBlock);
                }
                hasNonNullValue = true;
                this._intValuesSV[i] = data[j][i];
                break;
            }
            if (hasNonNullValue) continue;
            this._intValuesSV[i] = Integer.MIN_VALUE;
        }
        return this._intValuesSV;
    }

    private long[] getLongTransformResults(ProjectionBlock projectionBlock) {
        int length = projectionBlock.getNumDocs();
        if (this._longValuesSV == null) {
            this._longValuesSV = new long[length];
        }
        int width = this._transformFunctions.length;
        RoaringBitmap[] nullBitMaps = CoalesceTransformFunction.getNullBitMaps(projectionBlock, this._transformFunctions);
        long[][] data = new long[width][length];
        RoaringBitmap filledData = new RoaringBitmap();
        for (int i = 0; i < length; ++i) {
            boolean hasNonNullValue = false;
            for (int j = 0; j < width; ++j) {
                if (nullBitMaps[j] != null && nullBitMaps[j].contains(i)) continue;
                if (!filledData.contains(j)) {
                    filledData.add(j);
                    data[j] = this._transformFunctions[j].transformToLongValuesSV(projectionBlock);
                }
                hasNonNullValue = true;
                this._longValuesSV[i] = data[j][i];
                break;
            }
            if (hasNonNullValue) continue;
            this._longValuesSV[i] = Long.MIN_VALUE;
        }
        return this._longValuesSV;
    }

    private float[] getFloatTransformResults(ProjectionBlock projectionBlock) {
        int length = projectionBlock.getNumDocs();
        if (this._floatValuesSV == null) {
            this._floatValuesSV = new float[length];
        }
        int width = this._transformFunctions.length;
        RoaringBitmap[] nullBitMaps = CoalesceTransformFunction.getNullBitMaps(projectionBlock, this._transformFunctions);
        float[][] data = new float[width][length];
        RoaringBitmap filledData = new RoaringBitmap();
        for (int i = 0; i < length; ++i) {
            boolean hasNonNullValue = false;
            for (int j = 0; j < width; ++j) {
                if (nullBitMaps[j] != null && nullBitMaps[j].contains(i)) continue;
                if (!filledData.contains(j)) {
                    filledData.add(j);
                    data[j] = this._transformFunctions[j].transformToFloatValuesSV(projectionBlock);
                }
                hasNonNullValue = true;
                this._floatValuesSV[i] = data[j][i];
                break;
            }
            if (hasNonNullValue) continue;
            this._floatValuesSV[i] = Float.NEGATIVE_INFINITY;
        }
        return this._floatValuesSV;
    }

    private double[] getDoubleTransformResults(ProjectionBlock projectionBlock) {
        int length = projectionBlock.getNumDocs();
        if (this._doubleValuesSV == null) {
            this._doubleValuesSV = new double[length];
        }
        int width = this._transformFunctions.length;
        RoaringBitmap[] nullBitMaps = CoalesceTransformFunction.getNullBitMaps(projectionBlock, this._transformFunctions);
        double[][] data = new double[width][length];
        RoaringBitmap filledData = new RoaringBitmap();
        for (int i = 0; i < length; ++i) {
            boolean hasNonNullValue = false;
            for (int j = 0; j < width; ++j) {
                if (nullBitMaps[j] != null && nullBitMaps[j].contains(i)) continue;
                if (!filledData.contains(j)) {
                    filledData.add(j);
                    data[j] = this._transformFunctions[j].transformToDoubleValuesSV(projectionBlock);
                }
                hasNonNullValue = true;
                this._doubleValuesSV[i] = data[j][i];
                break;
            }
            if (hasNonNullValue) continue;
            this._doubleValuesSV[i] = Double.NEGATIVE_INFINITY;
        }
        return this._doubleValuesSV;
    }

    private BigDecimal[] getBigDecimalTransformResults(ProjectionBlock projectionBlock) {
        int length = projectionBlock.getNumDocs();
        if (this._bigDecimalValuesSV == null) {
            this._bigDecimalValuesSV = new BigDecimal[length];
        }
        int width = this._transformFunctions.length;
        RoaringBitmap[] nullBitMaps = CoalesceTransformFunction.getNullBitMaps(projectionBlock, this._transformFunctions);
        BigDecimal[][] data = new BigDecimal[width][length];
        RoaringBitmap filledData = new RoaringBitmap();
        for (int i = 0; i < length; ++i) {
            boolean hasNonNullValue = false;
            for (int j = 0; j < width; ++j) {
                if (nullBitMaps[j] != null && nullBitMaps[j].contains(i)) continue;
                if (!filledData.contains(j)) {
                    filledData.add(j);
                    data[j] = this._transformFunctions[j].transformToBigDecimalValuesSV(projectionBlock);
                }
                hasNonNullValue = true;
                this._bigDecimalValuesSV[i] = data[j][i];
                break;
            }
            if (hasNonNullValue) continue;
            this._bigDecimalValuesSV[i] = NULL_BIG_DECIMAL;
        }
        return this._bigDecimalValuesSV;
    }

    private String[] getStringTransformResults(ProjectionBlock projectionBlock) {
        int length = projectionBlock.getNumDocs();
        if (this._stringValuesSV == null) {
            this._stringValuesSV = new String[length];
        }
        int width = this._transformFunctions.length;
        RoaringBitmap[] nullBitMaps = CoalesceTransformFunction.getNullBitMaps(projectionBlock, this._transformFunctions);
        String[][] data = new String[width][length];
        RoaringBitmap filledData = new RoaringBitmap();
        for (int i = 0; i < length; ++i) {
            boolean hasNonNullValue = false;
            for (int j = 0; j < width; ++j) {
                if (nullBitMaps[j] != null && nullBitMaps[j].contains(i)) continue;
                if (!filledData.contains(j)) {
                    filledData.add(j);
                    data[j] = this._transformFunctions[j].transformToStringValuesSV(projectionBlock);
                }
                hasNonNullValue = true;
                this._stringValuesSV[i] = data[j][i];
                break;
            }
            if (hasNonNullValue) continue;
            this._stringValuesSV[i] = NULL_STRING;
        }
        return this._stringValuesSV;
    }

    @Override
    public String getName() {
        return TransformFunctionType.COALESCE.getName();
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        int argSize = arguments.size();
        Preconditions.checkArgument((argSize > 0 ? 1 : 0) != 0, (Object)"COALESCE needs to have at least one argument.");
        this._transformFunctions = new TransformFunction[argSize];
        for (int i = 0; i < argSize; ++i) {
            TransformFunction func = arguments.get(i);
            Preconditions.checkArgument((func instanceof IdentifierTransformFunction || func instanceof LiteralTransformFunction ? 1 : 0) != 0, (Object)"Only column names and literals are supported in COALESCE.");
            FieldSpec.DataType dataType = func.getResultMetadata().getDataType();
            if (this._dataType == null) {
                this._dataType = dataType;
            } else {
                Preconditions.checkArgument((dataType == this._dataType ? 1 : 0) != 0, (Object)"Argument types have to be the same.");
            }
            this._transformFunctions[i] = func;
        }
        switch (this._dataType) {
            case INT: {
                this._resultMetadata = INT_SV_NO_DICTIONARY_METADATA;
                break;
            }
            case LONG: {
                this._resultMetadata = LONG_SV_NO_DICTIONARY_METADATA;
                break;
            }
            case FLOAT: {
                this._resultMetadata = FLOAT_SV_NO_DICTIONARY_METADATA;
                break;
            }
            case DOUBLE: {
                this._resultMetadata = DOUBLE_SV_NO_DICTIONARY_METADATA;
                break;
            }
            case BIG_DECIMAL: {
                this._resultMetadata = BIG_DECIMAL_SV_NO_DICTIONARY_METADATA;
                break;
            }
            case STRING: {
                this._resultMetadata = STRING_SV_NO_DICTIONARY_METADATA;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Coalesce only supports numerical and string data type");
            }
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        if (this._dataType != FieldSpec.DataType.INT) {
            return super.transformToIntValuesSV(projectionBlock);
        }
        return this.getIntTransformResults(projectionBlock);
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        if (this._dataType != FieldSpec.DataType.LONG) {
            return super.transformToLongValuesSV(projectionBlock);
        }
        return this.getLongTransformResults(projectionBlock);
    }

    @Override
    public float[] transformToFloatValuesSV(ProjectionBlock projectionBlock) {
        if (this._dataType != FieldSpec.DataType.FLOAT) {
            return super.transformToFloatValuesSV(projectionBlock);
        }
        return this.getFloatTransformResults(projectionBlock);
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        if (this._dataType != FieldSpec.DataType.DOUBLE) {
            return super.transformToDoubleValuesSV(projectionBlock);
        }
        return this.getDoubleTransformResults(projectionBlock);
    }

    @Override
    public BigDecimal[] transformToBigDecimalValuesSV(ProjectionBlock projectionBlock) {
        if (this._dataType != FieldSpec.DataType.BIG_DECIMAL) {
            return super.transformToBigDecimalValuesSV(projectionBlock);
        }
        return this.getBigDecimalTransformResults(projectionBlock);
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        if (this._dataType != FieldSpec.DataType.STRING) {
            return super.transformToStringValuesSV(projectionBlock);
        }
        return this.getStringTransformResults(projectionBlock);
    }
}

