/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;

public abstract class BinaryOperatorTransformFunction
extends BaseTransformFunction {
    private static final int EQUALS = 0;
    private static final int GREATER_THAN_OR_EQUAL = 1;
    private static final int GREATER_THAN = 2;
    private static final int LESS_THAN = 3;
    private static final int LESS_THAN_OR_EQUAL = 4;
    private static final int NOT_EQUAL = 5;
    protected final int _op;
    protected final TransformFunctionType _transformFunctionType;
    protected TransformFunction _leftTransformFunction;
    protected TransformFunction _rightTransformFunction;
    protected FieldSpec.DataType _leftStoredType;
    protected FieldSpec.DataType _rightStoredType;

    protected BinaryOperatorTransformFunction(TransformFunctionType transformFunctionType) {
        switch (transformFunctionType) {
            case EQUALS: {
                this._op = 0;
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                this._op = 1;
                break;
            }
            case GREATER_THAN: {
                this._op = 2;
                break;
            }
            case LESS_THAN: {
                this._op = 3;
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                this._op = 4;
                break;
            }
            case NOT_EQUALS: {
                this._op = 5;
                break;
            }
            default: {
                throw new IllegalArgumentException("non-binary transform function provided: " + transformFunctionType);
            }
        }
        this._transformFunctionType = transformFunctionType;
    }

    @Override
    public String getName() {
        return this._transformFunctionType.getName();
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0, (Object)"Exact 2 arguments are required for binary operator transform function");
        this._leftTransformFunction = arguments.get(0);
        this._rightTransformFunction = arguments.get(1);
        this._leftStoredType = this._leftTransformFunction.getResultMetadata().getDataType().getStoredType();
        this._rightStoredType = this._rightTransformFunction.getResultMetadata().getDataType().getStoredType();
        if (this._leftStoredType == FieldSpec.DataType.BYTES || this._rightStoredType == FieldSpec.DataType.BYTES) {
            Preconditions.checkState((this._leftStoredType == this._rightStoredType ? 1 : 0) != 0, (Object)String.format("Unsupported data type for comparison: [Left Transform Function [%s] result type is [%s], Right Transform Function [%s] result type is [%s]]", this._leftTransformFunction.getName(), this._leftStoredType, this._rightTransformFunction.getName(), this._rightStoredType));
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return BOOLEAN_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        this.fillResultArray(projectionBlock);
        return this._intValuesSV;
    }

    private void fillResultArray(ProjectionBlock projectionBlock) {
        int length = projectionBlock.getNumDocs();
        if (this._intValuesSV == null) {
            this._intValuesSV = new int[length];
        }
        switch (this._leftStoredType) {
            case INT: {
                this.fillResultInt(projectionBlock, length);
                break;
            }
            case LONG: {
                this.fillResultLong(projectionBlock, length);
                break;
            }
            case FLOAT: {
                this.fillResultFloat(projectionBlock, length);
                break;
            }
            case DOUBLE: {
                this.fillResultDouble(projectionBlock, length);
                break;
            }
            case BIG_DECIMAL: {
                this.fillResultBigDecimal(projectionBlock, length);
                break;
            }
            case STRING: {
                this.fillResultString(projectionBlock, length);
                break;
            }
            case BYTES: {
                this.fillResultBytes(projectionBlock, length);
                break;
            }
            default: {
                throw this.illegalState();
            }
        }
    }

    private void fillResultInt(ProjectionBlock projectionBlock, int length) {
        int[] leftIntValues = this._leftTransformFunction.transformToIntValuesSV(projectionBlock);
        switch (this._rightStoredType) {
            case INT: {
                this.fillIntResultArray(projectionBlock, leftIntValues, length);
                break;
            }
            case LONG: {
                this.fillLongResultArray(projectionBlock, leftIntValues, length);
                break;
            }
            case FLOAT: {
                this.fillFloatResultArray(projectionBlock, leftIntValues, length);
                break;
            }
            case DOUBLE: {
                this.fillDoubleResultArray(projectionBlock, leftIntValues, length);
                break;
            }
            case BIG_DECIMAL: {
                this.fillBigDecimalResultArray(projectionBlock, leftIntValues, length);
                break;
            }
            case STRING: {
                this.fillStringResultArray(projectionBlock, leftIntValues, length);
                break;
            }
            default: {
                throw this.illegalState();
            }
        }
    }

    private void fillResultLong(ProjectionBlock projectionBlock, int length) {
        long[] leftLongValues = this._leftTransformFunction.transformToLongValuesSV(projectionBlock);
        switch (this._rightStoredType) {
            case INT: {
                this.fillIntResultArray(projectionBlock, leftLongValues, length);
                break;
            }
            case LONG: {
                this.fillLongResultArray(projectionBlock, leftLongValues, length);
                break;
            }
            case FLOAT: {
                this.fillFloatResultArray(projectionBlock, leftLongValues, length);
                break;
            }
            case DOUBLE: {
                this.fillDoubleResultArray(projectionBlock, leftLongValues, length);
                break;
            }
            case BIG_DECIMAL: {
                this.fillBigDecimalResultArray(projectionBlock, leftLongValues, length);
                break;
            }
            case STRING: {
                this.fillStringResultArray(projectionBlock, leftLongValues, length);
                break;
            }
            default: {
                throw this.illegalState();
            }
        }
    }

    private void fillResultFloat(ProjectionBlock projectionBlock, int length) {
        float[] leftFloatValues = this._leftTransformFunction.transformToFloatValuesSV(projectionBlock);
        switch (this._rightStoredType) {
            case INT: {
                this.fillIntResultArray(projectionBlock, leftFloatValues, length);
                break;
            }
            case LONG: {
                this.fillLongResultArray(projectionBlock, leftFloatValues, length);
                break;
            }
            case FLOAT: {
                this.fillFloatResultArray(projectionBlock, leftFloatValues, length);
                break;
            }
            case DOUBLE: {
                this.fillDoubleResultArray(projectionBlock, leftFloatValues, length);
                break;
            }
            case BIG_DECIMAL: {
                this.fillBigDecimalResultArray(projectionBlock, leftFloatValues, length);
                break;
            }
            case STRING: {
                this.fillStringResultArray(projectionBlock, leftFloatValues, length);
                break;
            }
            default: {
                throw this.illegalState();
            }
        }
    }

    private void fillResultDouble(ProjectionBlock projectionBlock, int length) {
        double[] leftDoubleValues = this._leftTransformFunction.transformToDoubleValuesSV(projectionBlock);
        switch (this._rightStoredType) {
            case INT: {
                this.fillIntResultArray(projectionBlock, leftDoubleValues, length);
                break;
            }
            case LONG: {
                this.fillLongResultArray(projectionBlock, leftDoubleValues, length);
                break;
            }
            case FLOAT: {
                this.fillFloatResultArray(projectionBlock, leftDoubleValues, length);
                break;
            }
            case DOUBLE: {
                this.fillDoubleResultArray(projectionBlock, leftDoubleValues, length);
                break;
            }
            case BIG_DECIMAL: {
                this.fillBigDecimalResultArray(projectionBlock, leftDoubleValues, length);
                break;
            }
            case STRING: {
                this.fillStringResultArray(projectionBlock, leftDoubleValues, length);
                break;
            }
            default: {
                throw this.illegalState();
            }
        }
    }

    private void fillResultBigDecimal(ProjectionBlock projectionBlock, int length) {
        BigDecimal[] leftBigDecimalValues = this._leftTransformFunction.transformToBigDecimalValuesSV(projectionBlock);
        switch (this._rightStoredType) {
            case INT: {
                this.fillIntResultArray(projectionBlock, leftBigDecimalValues, length);
                break;
            }
            case LONG: {
                this.fillLongResultArray(projectionBlock, leftBigDecimalValues, length);
                break;
            }
            case FLOAT: {
                this.fillFloatResultArray(projectionBlock, leftBigDecimalValues, length);
                break;
            }
            case DOUBLE: {
                this.fillDoubleResultArray(projectionBlock, leftBigDecimalValues, length);
                break;
            }
            case STRING: {
                this.fillStringResultArray(projectionBlock, leftBigDecimalValues, length);
                break;
            }
            case BIG_DECIMAL: {
                this.fillBigDecimalResultArray(projectionBlock, leftBigDecimalValues, length);
                break;
            }
            default: {
                throw this.illegalState();
            }
        }
    }

    private IllegalStateException illegalState() {
        throw new IllegalStateException(String.format("Unsupported data type for comparison: [Left Transform Function [%s] result type is [%s], Right Transform Function [%s] result type is [%s]]", this._leftTransformFunction.getName(), this._leftStoredType, this._rightTransformFunction.getName(), this._rightStoredType));
    }

    private void fillResultString(ProjectionBlock projectionBlock, int length) {
        String[] leftStringValues = this._leftTransformFunction.transformToStringValuesSV(projectionBlock);
        String[] rightStringValues = this._rightTransformFunction.transformToStringValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(leftStringValues[i].compareTo(rightStringValues[i]));
        }
    }

    private void fillResultBytes(ProjectionBlock projectionBlock, int length) {
        byte[][] leftBytesValues = this._leftTransformFunction.transformToBytesValuesSV(projectionBlock);
        byte[][] rightBytesValues = this._rightTransformFunction.transformToBytesValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(ByteArray.compare((byte[])leftBytesValues[i], (byte[])rightBytesValues[i]));
        }
    }

    private void fillIntResultArray(ProjectionBlock projectionBlock, int[] leftIntValues, int length) {
        int[] rightIntValues = this._rightTransformFunction.transformToIntValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(Integer.compare(leftIntValues[i], rightIntValues[i]));
        }
    }

    private void fillLongResultArray(ProjectionBlock projectionBlock, int[] leftValues, int length) {
        long[] rightValues = this._rightTransformFunction.transformToLongValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(Long.compare(leftValues[i], rightValues[i]));
        }
    }

    private void fillFloatResultArray(ProjectionBlock projectionBlock, int[] leftValues, int length) {
        float[] rightFloatValues = this._rightTransformFunction.transformToFloatValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(Double.compare(leftValues[i], rightFloatValues[i]));
        }
    }

    private void fillDoubleResultArray(ProjectionBlock projectionBlock, int[] leftValues, int length) {
        double[] rightDoubleValues = this._rightTransformFunction.transformToDoubleValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(Double.compare(leftValues[i], rightDoubleValues[i]));
        }
    }

    private void fillBigDecimalResultArray(ProjectionBlock projectionBlock, int[] leftValues, int length) {
        BigDecimal[] rightBigDecimalValues = this._rightTransformFunction.transformToBigDecimalValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(BigDecimal.valueOf(leftValues[i]).compareTo(rightBigDecimalValues[i]));
        }
    }

    private void fillStringResultArray(ProjectionBlock projectionBlock, int[] leftValues, int length) {
        String[] rightStringValues = this._rightTransformFunction.transformToStringValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            try {
                this._intValuesSV[i] = this.getIntResult(BigDecimal.valueOf(leftValues[i]).compareTo(new BigDecimal(rightStringValues[i])));
                continue;
            }
            catch (NumberFormatException e) {
                this._intValuesSV[i] = 0;
            }
        }
    }

    private void fillIntResultArray(ProjectionBlock projectionBlock, long[] leftIntValues, int length) {
        int[] rightIntValues = this._rightTransformFunction.transformToIntValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(Long.compare(leftIntValues[i], rightIntValues[i]));
        }
    }

    private void fillLongResultArray(ProjectionBlock projectionBlock, long[] leftValues, int length) {
        long[] rightValues = this._rightTransformFunction.transformToLongValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(Long.compare(leftValues[i], rightValues[i]));
        }
    }

    private void fillFloatResultArray(ProjectionBlock projectionBlock, long[] leftValues, int length) {
        float[] rightFloatValues = this._rightTransformFunction.transformToFloatValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(this.compare(leftValues[i], rightFloatValues[i]));
        }
    }

    private void fillDoubleResultArray(ProjectionBlock projectionBlock, long[] leftValues, int length) {
        double[] rightDoubleValues = this._rightTransformFunction.transformToDoubleValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(this.compare(leftValues[i], rightDoubleValues[i]));
        }
    }

    private void fillBigDecimalResultArray(ProjectionBlock projectionBlock, long[] leftValues, int length) {
        BigDecimal[] rightBigDecimalValues = this._rightTransformFunction.transformToBigDecimalValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(BigDecimal.valueOf(leftValues[i]).compareTo(rightBigDecimalValues[i]));
        }
    }

    private void fillStringResultArray(ProjectionBlock projectionBlock, long[] leftValues, int length) {
        String[] rightStringValues = this._rightTransformFunction.transformToStringValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            try {
                this._intValuesSV[i] = this.getIntResult(BigDecimal.valueOf(leftValues[i]).compareTo(new BigDecimal(rightStringValues[i])));
                continue;
            }
            catch (NumberFormatException e) {
                this._intValuesSV[i] = 0;
            }
        }
    }

    private void fillIntResultArray(ProjectionBlock projectionBlock, float[] leftValues, int length) {
        int[] rightIntValues = this._rightTransformFunction.transformToIntValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(Double.compare(leftValues[i], rightIntValues[i]));
        }
    }

    private void fillLongResultArray(ProjectionBlock projectionBlock, float[] leftValues, int length) {
        long[] rightValues = this._rightTransformFunction.transformToLongValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(this.compare(leftValues[i], rightValues[i]));
        }
    }

    private void fillFloatResultArray(ProjectionBlock projectionBlock, float[] leftValues, int length) {
        float[] rightFloatValues = this._rightTransformFunction.transformToFloatValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(Float.compare(leftValues[i], rightFloatValues[i]));
        }
    }

    private void fillDoubleResultArray(ProjectionBlock projectionBlock, float[] leftValues, int length) {
        double[] rightDoubleValues = this._rightTransformFunction.transformToDoubleValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(Double.compare(leftValues[i], rightDoubleValues[i]));
        }
    }

    private void fillBigDecimalResultArray(ProjectionBlock projectionBlock, float[] leftValues, int length) {
        BigDecimal[] rightBigDecimalValues = this._rightTransformFunction.transformToBigDecimalValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(BigDecimal.valueOf(leftValues[i]).compareTo(rightBigDecimalValues[i]));
        }
    }

    private void fillStringResultArray(ProjectionBlock projectionBlock, float[] leftValues, int length) {
        String[] rightStringValues = this._rightTransformFunction.transformToStringValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            try {
                this._intValuesSV[i] = this.getIntResult(BigDecimal.valueOf(leftValues[i]).compareTo(new BigDecimal(rightStringValues[i])));
                continue;
            }
            catch (NumberFormatException e) {
                this._intValuesSV[i] = 0;
            }
        }
    }

    private void fillIntResultArray(ProjectionBlock projectionBlock, double[] leftValues, int length) {
        int[] rightIntValues = this._rightTransformFunction.transformToIntValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(Double.compare(leftValues[i], rightIntValues[i]));
        }
    }

    private void fillLongResultArray(ProjectionBlock projectionBlock, double[] leftValues, int length) {
        long[] rightValues = this._rightTransformFunction.transformToLongValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(this.compare(leftValues[i], rightValues[i]));
        }
    }

    private void fillFloatResultArray(ProjectionBlock projectionBlock, double[] leftValues, int length) {
        float[] rightFloatValues = this._rightTransformFunction.transformToFloatValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(Double.compare(leftValues[i], rightFloatValues[i]));
        }
    }

    private void fillDoubleResultArray(ProjectionBlock projectionBlock, double[] leftValues, int length) {
        double[] rightDoubleValues = this._rightTransformFunction.transformToDoubleValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(Double.compare(leftValues[i], rightDoubleValues[i]));
        }
    }

    private void fillBigDecimalResultArray(ProjectionBlock projectionBlock, double[] leftValues, int length) {
        BigDecimal[] rightBigDecimalValues = this._rightTransformFunction.transformToBigDecimalValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(BigDecimal.valueOf(leftValues[i]).compareTo(rightBigDecimalValues[i]));
        }
    }

    private void fillStringResultArray(ProjectionBlock projectionBlock, double[] leftValues, int length) {
        String[] rightStringValues = this._rightTransformFunction.transformToStringValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            try {
                this._intValuesSV[i] = this.getIntResult(BigDecimal.valueOf(leftValues[i]).compareTo(new BigDecimal(rightStringValues[i])));
                continue;
            }
            catch (NumberFormatException e) {
                this._intValuesSV[i] = 0;
            }
        }
    }

    private void fillIntResultArray(ProjectionBlock projectionBlock, BigDecimal[] leftValues, int length) {
        int[] rightIntValues = this._rightTransformFunction.transformToIntValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(leftValues[i].compareTo(BigDecimal.valueOf(rightIntValues[i])));
        }
    }

    private void fillLongResultArray(ProjectionBlock projectionBlock, BigDecimal[] leftValues, int length) {
        long[] rightLongValues = this._rightTransformFunction.transformToLongValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(leftValues[i].compareTo(BigDecimal.valueOf(rightLongValues[i])));
        }
    }

    private void fillFloatResultArray(ProjectionBlock projectionBlock, BigDecimal[] leftValues, int length) {
        float[] rightFloatValues = this._rightTransformFunction.transformToFloatValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(leftValues[i].compareTo(BigDecimal.valueOf(rightFloatValues[i])));
        }
    }

    private void fillDoubleResultArray(ProjectionBlock projectionBlock, BigDecimal[] leftValues, int length) {
        double[] rightDoubleValues = this._rightTransformFunction.transformToDoubleValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(leftValues[i].compareTo(BigDecimal.valueOf(rightDoubleValues[i])));
        }
    }

    private void fillBigDecimalResultArray(ProjectionBlock projectionBlock, BigDecimal[] leftValues, int length) {
        BigDecimal[] rightBigDecimalValues = this._rightTransformFunction.transformToBigDecimalValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(leftValues[i].compareTo(rightBigDecimalValues[i]));
        }
    }

    private void fillStringResultArray(ProjectionBlock projectionBlock, BigDecimal[] leftValues, int length) {
        String[] rightStringValues = this._rightTransformFunction.transformToStringValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._intValuesSV[i] = this.getIntResult(leftValues[i].compareTo(new BigDecimal(rightStringValues[i])));
        }
    }

    private int compare(long left, double right) {
        if (Math.abs(left) <= 0x20000000000000L) {
            return Double.compare(left, right);
        }
        return BigDecimal.valueOf(left).compareTo(BigDecimal.valueOf(right));
    }

    private int compare(double left, long right) {
        if (Math.abs(right) <= 0x20000000000000L) {
            return Double.compare(left, right);
        }
        return BigDecimal.valueOf(left).compareTo(BigDecimal.valueOf(right));
    }

    private int getIntResult(int comparisonResult) {
        return this.getBinaryFuncResult(comparisonResult) ? 1 : 0;
    }

    private boolean getBinaryFuncResult(int comparisonResult) {
        switch (this._op) {
            case 0: {
                return comparisonResult == 0;
            }
            case 1: {
                return comparisonResult >= 0;
            }
            case 2: {
                return comparisonResult > 0;
            }
            case 3: {
                return comparisonResult < 0;
            }
            case 4: {
                return comparisonResult <= 0;
            }
            case 5: {
                return comparisonResult != 0;
            }
        }
        throw new IllegalStateException();
    }
}

