/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.math.BigDecimal;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ArrayCopyUtils;

public abstract class BaseTransformFunction
implements TransformFunction {
    protected static final TransformResultMetadata INT_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.INT, true, false);
    protected static final TransformResultMetadata LONG_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.LONG, true, false);
    protected static final TransformResultMetadata FLOAT_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.FLOAT, true, false);
    protected static final TransformResultMetadata DOUBLE_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.DOUBLE, true, false);
    protected static final TransformResultMetadata BIG_DECIMAL_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.BIG_DECIMAL, true, false);
    protected static final TransformResultMetadata BOOLEAN_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.BOOLEAN, true, false);
    protected static final TransformResultMetadata TIMESTAMP_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.TIMESTAMP, true, false);
    protected static final TransformResultMetadata STRING_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.STRING, true, false);
    protected static final TransformResultMetadata JSON_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.JSON, true, false);
    protected static final TransformResultMetadata BYTES_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.BYTES, true, false);
    protected static final TransformResultMetadata INT_MV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.INT, false, false);
    protected static final TransformResultMetadata LONG_MV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.LONG, false, false);
    protected static final TransformResultMetadata FLOAT_MV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.FLOAT, false, false);
    protected static final TransformResultMetadata DOUBLE_MV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.DOUBLE, false, false);
    protected static final TransformResultMetadata BIG_DECIMAL_MV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.BIG_DECIMAL, false, false);
    protected static final TransformResultMetadata BOOLEAN_MV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.BOOLEAN, false, false);
    protected static final TransformResultMetadata TIMESTAMP_MV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.TIMESTAMP, false, false);
    protected static final TransformResultMetadata STRING_MV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.STRING, false, false);
    protected static final TransformResultMetadata JSON_MV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.JSON, false, false);
    protected static final TransformResultMetadata BYTES_MV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.BYTES, false, false);
    protected int[] _intValuesSV;
    protected long[] _longValuesSV;
    protected float[] _floatValuesSV;
    protected double[] _doubleValuesSV;
    protected BigDecimal[] _bigDecimalValuesSV;
    protected String[] _stringValuesSV;
    protected byte[][] _bytesValuesSV;
    protected int[][] _intValuesMV;
    protected long[][] _longValuesMV;
    protected float[][] _floatValuesMV;
    protected double[][] _doubleValuesMV;
    protected String[][] _stringValuesMV;
    protected byte[][][] _bytesValuesMV;

    @Override
    public Dictionary getDictionary() {
        return null;
    }

    @Override
    public int[] transformToDictIdsSV(ProjectionBlock projectionBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[][] transformToDictIdsMV(ProjectionBlock projectionBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        Dictionary dictionary;
        int length = projectionBlock.getNumDocs();
        if (this._intValuesSV == null) {
            this._intValuesSV = new int[length];
        }
        if ((dictionary = this.getDictionary()) != null) {
            int[] dictIds = this.transformToDictIdsSV(projectionBlock);
            dictionary.readIntValues(dictIds, length, this._intValuesSV);
        } else {
            FieldSpec.DataType resultDataType = this.getResultMetadata().getDataType();
            switch (resultDataType.getStoredType()) {
                case LONG: {
                    long[] longValues = this.transformToLongValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((long[])longValues, (int[])this._intValuesSV, (int)length);
                    break;
                }
                case FLOAT: {
                    float[] floatValues = this.transformToFloatValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((float[])floatValues, (int[])this._intValuesSV, (int)length);
                    break;
                }
                case DOUBLE: {
                    double[] doubleValues = this.transformToDoubleValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((double[])doubleValues, (int[])this._intValuesSV, (int)length);
                    break;
                }
                case BIG_DECIMAL: {
                    BigDecimal[] bigDecimalValues = this.transformToBigDecimalValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((BigDecimal[])bigDecimalValues, (int[])this._intValuesSV, (int)length);
                    break;
                }
                case STRING: {
                    String[] stringValues = this.transformToStringValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((String[])stringValues, (int[])this._intValuesSV, (int)length);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot read SV %s as INT", resultDataType));
                }
            }
        }
        return this._intValuesSV;
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        Dictionary dictionary;
        int length = projectionBlock.getNumDocs();
        if (this._longValuesSV == null) {
            this._longValuesSV = new long[length];
        }
        if ((dictionary = this.getDictionary()) != null) {
            int[] dictIds = this.transformToDictIdsSV(projectionBlock);
            dictionary.readLongValues(dictIds, length, this._longValuesSV);
        } else {
            FieldSpec.DataType resultDataType = this.getResultMetadata().getDataType();
            switch (resultDataType.getStoredType()) {
                case INT: {
                    int[] intValues = this.transformToIntValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((int[])intValues, (long[])this._longValuesSV, (int)length);
                    break;
                }
                case FLOAT: {
                    float[] floatValues = this.transformToFloatValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((float[])floatValues, (long[])this._longValuesSV, (int)length);
                    break;
                }
                case DOUBLE: {
                    double[] doubleValues = this.transformToDoubleValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((double[])doubleValues, (long[])this._longValuesSV, (int)length);
                    break;
                }
                case BIG_DECIMAL: {
                    BigDecimal[] bigDecimalValues = this.transformToBigDecimalValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((BigDecimal[])bigDecimalValues, (long[])this._longValuesSV, (int)length);
                    break;
                }
                case STRING: {
                    String[] stringValues = this.transformToStringValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((String[])stringValues, (long[])this._longValuesSV, (int)length);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot read SV %s as LONG", resultDataType));
                }
            }
        }
        return this._longValuesSV;
    }

    @Override
    public float[] transformToFloatValuesSV(ProjectionBlock projectionBlock) {
        Dictionary dictionary;
        int length = projectionBlock.getNumDocs();
        if (this._floatValuesSV == null) {
            this._floatValuesSV = new float[length];
        }
        if ((dictionary = this.getDictionary()) != null) {
            int[] dictIds = this.transformToDictIdsSV(projectionBlock);
            dictionary.readFloatValues(dictIds, length, this._floatValuesSV);
        } else {
            FieldSpec.DataType resultDataType = this.getResultMetadata().getDataType();
            switch (resultDataType.getStoredType()) {
                case INT: {
                    int[] intValues = this.transformToIntValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((int[])intValues, (float[])this._floatValuesSV, (int)length);
                    break;
                }
                case LONG: {
                    long[] longValues = this.transformToLongValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((long[])longValues, (float[])this._floatValuesSV, (int)length);
                    break;
                }
                case DOUBLE: {
                    double[] doubleValues = this.transformToDoubleValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((double[])doubleValues, (float[])this._floatValuesSV, (int)length);
                    break;
                }
                case BIG_DECIMAL: {
                    BigDecimal[] bigDecimalValues = this.transformToBigDecimalValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((BigDecimal[])bigDecimalValues, (float[])this._floatValuesSV, (int)length);
                    break;
                }
                case STRING: {
                    String[] stringValues = this.transformToStringValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((String[])stringValues, (float[])this._floatValuesSV, (int)length);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot read SV %s as FLOAT", resultDataType));
                }
            }
        }
        return this._floatValuesSV;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        Dictionary dictionary;
        int length = projectionBlock.getNumDocs();
        if (this._doubleValuesSV == null) {
            this._doubleValuesSV = new double[length];
        }
        if ((dictionary = this.getDictionary()) != null) {
            int[] dictIds = this.transformToDictIdsSV(projectionBlock);
            dictionary.readDoubleValues(dictIds, length, this._doubleValuesSV);
        } else {
            FieldSpec.DataType resultDataType = this.getResultMetadata().getDataType();
            switch (resultDataType.getStoredType()) {
                case INT: {
                    int[] intValues = this.transformToIntValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((int[])intValues, (double[])this._doubleValuesSV, (int)length);
                    break;
                }
                case LONG: {
                    long[] longValues = this.transformToLongValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((long[])longValues, (double[])this._doubleValuesSV, (int)length);
                    break;
                }
                case FLOAT: {
                    float[] floatValues = this.transformToFloatValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((float[])floatValues, (double[])this._doubleValuesSV, (int)length);
                    break;
                }
                case BIG_DECIMAL: {
                    BigDecimal[] bigDecimalValues = this.transformToBigDecimalValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((BigDecimal[])bigDecimalValues, (double[])this._doubleValuesSV, (int)length);
                    break;
                }
                case STRING: {
                    String[] stringValues = this.transformToStringValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((String[])stringValues, (double[])this._doubleValuesSV, (int)length);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot read SV %s as DOUBLE", resultDataType));
                }
            }
        }
        return this._doubleValuesSV;
    }

    @Override
    public BigDecimal[] transformToBigDecimalValuesSV(ProjectionBlock projectionBlock) {
        Dictionary dictionary;
        int length = projectionBlock.getNumDocs();
        if (this._bigDecimalValuesSV == null) {
            this._bigDecimalValuesSV = new BigDecimal[length];
        }
        if ((dictionary = this.getDictionary()) != null) {
            int[] dictIds = this.transformToDictIdsSV(projectionBlock);
            dictionary.readBigDecimalValues(dictIds, length, this._bigDecimalValuesSV);
        } else {
            FieldSpec.DataType resultDataType = this.getResultMetadata().getDataType();
            switch (resultDataType.getStoredType()) {
                case INT: {
                    int[] intValues = this.transformToIntValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((int[])intValues, (BigDecimal[])this._bigDecimalValuesSV, (int)length);
                    break;
                }
                case LONG: {
                    long[] longValues = this.transformToLongValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((long[])longValues, (BigDecimal[])this._bigDecimalValuesSV, (int)length);
                    break;
                }
                case FLOAT: {
                    float[] floatValues = this.transformToFloatValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((float[])floatValues, (BigDecimal[])this._bigDecimalValuesSV, (int)length);
                    break;
                }
                case DOUBLE: {
                    double[] doubleValues = this.transformToDoubleValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((double[])doubleValues, (BigDecimal[])this._bigDecimalValuesSV, (int)length);
                    break;
                }
                case STRING: {
                    String[] stringValues = this.transformToStringValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((String[])stringValues, (BigDecimal[])this._bigDecimalValuesSV, (int)length);
                    break;
                }
                case BYTES: {
                    byte[][] bytesValues = this.transformToBytesValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((byte[][])bytesValues, (BigDecimal[])this._bigDecimalValuesSV, (int)length);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot read SV %s as BIG_DECIMAL", resultDataType));
                }
            }
        }
        return this._bigDecimalValuesSV;
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        Dictionary dictionary;
        int length = projectionBlock.getNumDocs();
        if (this._stringValuesSV == null) {
            this._stringValuesSV = new String[length];
        }
        if ((dictionary = this.getDictionary()) != null) {
            int[] dictIds = this.transformToDictIdsSV(projectionBlock);
            dictionary.readStringValues(dictIds, length, this._stringValuesSV);
        } else {
            FieldSpec.DataType resultDataType = this.getResultMetadata().getDataType();
            switch (resultDataType.getStoredType()) {
                case INT: {
                    int[] intValues = this.transformToIntValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((int[])intValues, (String[])this._stringValuesSV, (int)length);
                    break;
                }
                case LONG: {
                    long[] longValues = this.transformToLongValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((long[])longValues, (String[])this._stringValuesSV, (int)length);
                    break;
                }
                case FLOAT: {
                    float[] floatValues = this.transformToFloatValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((float[])floatValues, (String[])this._stringValuesSV, (int)length);
                    break;
                }
                case DOUBLE: {
                    double[] doubleValues = this.transformToDoubleValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((double[])doubleValues, (String[])this._stringValuesSV, (int)length);
                    break;
                }
                case BIG_DECIMAL: {
                    BigDecimal[] bigDecimalValues = this.transformToBigDecimalValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((BigDecimal[])bigDecimalValues, (String[])this._stringValuesSV, (int)length);
                    break;
                }
                case BYTES: {
                    byte[][] bytesValues = this.transformToBytesValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((byte[][])bytesValues, (String[])this._stringValuesSV, (int)length);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot read SV %s as STRING", resultDataType));
                }
            }
        }
        return this._stringValuesSV;
    }

    @Override
    public byte[][] transformToBytesValuesSV(ProjectionBlock projectionBlock) {
        Dictionary dictionary;
        int length = projectionBlock.getNumDocs();
        if (this._bytesValuesSV == null) {
            this._bytesValuesSV = new byte[length][];
        }
        if ((dictionary = this.getDictionary()) != null) {
            int[] dictIds = this.transformToDictIdsSV(projectionBlock);
            dictionary.readBytesValues(dictIds, length, this._bytesValuesSV);
        } else {
            FieldSpec.DataType resultDataType = this.getResultMetadata().getDataType();
            switch (resultDataType.getStoredType()) {
                case BIG_DECIMAL: {
                    BigDecimal[] bigDecimalValues = this.transformToBigDecimalValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((BigDecimal[])bigDecimalValues, (byte[][])this._bytesValuesSV, (int)length);
                    break;
                }
                case STRING: {
                    String[] stringValues = this.transformToStringValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((String[])stringValues, (byte[][])this._bytesValuesSV, (int)length);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot read SV %s as BYTES", resultDataType));
                }
            }
        }
        return this._bytesValuesSV;
    }

    @Override
    public int[][] transformToIntValuesMV(ProjectionBlock projectionBlock) {
        Dictionary dictionary;
        int length = projectionBlock.getNumDocs();
        if (this._intValuesMV == null) {
            this._intValuesMV = new int[length][];
        }
        if ((dictionary = this.getDictionary()) != null) {
            int[][] dictIdsMV = this.transformToDictIdsMV(projectionBlock);
            for (int i = 0; i < length; ++i) {
                int[] dictIds = dictIdsMV[i];
                int numValues = dictIds.length;
                int[] intValues = new int[numValues];
                dictionary.readIntValues(dictIds, numValues, intValues);
                this._intValuesMV[i] = intValues;
            }
        } else {
            FieldSpec.DataType resultDataType = this.getResultMetadata().getDataType();
            switch (resultDataType.getStoredType()) {
                case LONG: {
                    long[][] longValuesMV = this.transformToLongValuesMV(projectionBlock);
                    ArrayCopyUtils.copy((long[][])longValuesMV, (int[][])this._intValuesMV, (int)length);
                    break;
                }
                case FLOAT: {
                    float[][] floatValuesMV = this.transformToFloatValuesMV(projectionBlock);
                    ArrayCopyUtils.copy((float[][])floatValuesMV, (int[][])this._intValuesMV, (int)length);
                    break;
                }
                case DOUBLE: {
                    double[][] doubleValuesMV = this.transformToDoubleValuesMV(projectionBlock);
                    ArrayCopyUtils.copy((double[][])doubleValuesMV, (int[][])this._intValuesMV, (int)length);
                    break;
                }
                case STRING: {
                    String[][] stringValuesMV = this.transformToStringValuesMV(projectionBlock);
                    ArrayCopyUtils.copy((String[][])stringValuesMV, (int[][])this._intValuesMV, (int)length);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot read MV %s as INT", resultDataType));
                }
            }
        }
        return this._intValuesMV;
    }

    @Override
    public long[][] transformToLongValuesMV(ProjectionBlock projectionBlock) {
        Dictionary dictionary;
        int length = projectionBlock.getNumDocs();
        if (this._longValuesMV == null) {
            this._longValuesMV = new long[length][];
        }
        if ((dictionary = this.getDictionary()) != null) {
            int[][] dictIdsMV = this.transformToDictIdsMV(projectionBlock);
            for (int i = 0; i < length; ++i) {
                int[] dictIds = dictIdsMV[i];
                int numValues = dictIds.length;
                long[] longValues = new long[numValues];
                dictionary.readLongValues(dictIds, numValues, longValues);
                this._longValuesMV[i] = longValues;
            }
        } else {
            FieldSpec.DataType resultDataType = this.getResultMetadata().getDataType();
            switch (resultDataType.getStoredType()) {
                case INT: {
                    int[][] intValuesMV = this.transformToIntValuesMV(projectionBlock);
                    ArrayCopyUtils.copy((int[][])intValuesMV, (long[][])this._longValuesMV, (int)length);
                    break;
                }
                case FLOAT: {
                    float[][] floatValuesMV = this.transformToFloatValuesMV(projectionBlock);
                    ArrayCopyUtils.copy((float[][])floatValuesMV, (long[][])this._longValuesMV, (int)length);
                    break;
                }
                case DOUBLE: {
                    double[][] doubleValuesMV = this.transformToDoubleValuesMV(projectionBlock);
                    ArrayCopyUtils.copy((double[][])doubleValuesMV, (long[][])this._longValuesMV, (int)length);
                    break;
                }
                case STRING: {
                    String[][] stringValuesMV = this.transformToStringValuesMV(projectionBlock);
                    ArrayCopyUtils.copy((String[][])stringValuesMV, (long[][])this._longValuesMV, (int)length);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot read MV %s as LONG", resultDataType));
                }
            }
        }
        return this._longValuesMV;
    }

    @Override
    public float[][] transformToFloatValuesMV(ProjectionBlock projectionBlock) {
        Dictionary dictionary;
        int length = projectionBlock.getNumDocs();
        if (this._floatValuesMV == null) {
            this._floatValuesMV = new float[length][];
        }
        if ((dictionary = this.getDictionary()) != null) {
            int[][] dictIdsMV = this.transformToDictIdsMV(projectionBlock);
            for (int i = 0; i < length; ++i) {
                int[] dictIds = dictIdsMV[i];
                int numValues = dictIds.length;
                float[] floatValues = new float[numValues];
                dictionary.readFloatValues(dictIds, numValues, floatValues);
                this._floatValuesMV[i] = floatValues;
            }
        } else {
            FieldSpec.DataType resultDataType = this.getResultMetadata().getDataType();
            switch (resultDataType.getStoredType()) {
                case INT: {
                    int[][] intValuesMV = this.transformToIntValuesMV(projectionBlock);
                    ArrayCopyUtils.copy((int[][])intValuesMV, (float[][])this._floatValuesMV, (int)length);
                    break;
                }
                case LONG: {
                    long[][] longValuesMV = this.transformToLongValuesMV(projectionBlock);
                    ArrayCopyUtils.copy((long[][])longValuesMV, (float[][])this._floatValuesMV, (int)length);
                    break;
                }
                case DOUBLE: {
                    double[][] doubleValuesMV = this.transformToDoubleValuesMV(projectionBlock);
                    ArrayCopyUtils.copy((double[][])doubleValuesMV, (float[][])this._floatValuesMV, (int)length);
                    break;
                }
                case STRING: {
                    String[][] stringValuesMV = this.transformToStringValuesMV(projectionBlock);
                    ArrayCopyUtils.copy((String[][])stringValuesMV, (float[][])this._floatValuesMV, (int)length);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot read MV %s as FLOAT", resultDataType));
                }
            }
        }
        return this._floatValuesMV;
    }

    @Override
    public double[][] transformToDoubleValuesMV(ProjectionBlock projectionBlock) {
        Dictionary dictionary;
        int length = projectionBlock.getNumDocs();
        if (this._doubleValuesMV == null) {
            this._doubleValuesMV = new double[length][];
        }
        if ((dictionary = this.getDictionary()) != null) {
            int[][] dictIdsMV = this.transformToDictIdsMV(projectionBlock);
            for (int i = 0; i < length; ++i) {
                int[] dictIds = dictIdsMV[i];
                int numValues = dictIds.length;
                double[] doubleValues = new double[numValues];
                dictionary.readDoubleValues(dictIds, numValues, doubleValues);
                this._doubleValuesMV[i] = doubleValues;
            }
        } else {
            FieldSpec.DataType resultDataType = this.getResultMetadata().getDataType();
            switch (resultDataType.getStoredType()) {
                case INT: {
                    int[][] intValuesMV = this.transformToIntValuesMV(projectionBlock);
                    ArrayCopyUtils.copy((int[][])intValuesMV, (double[][])this._doubleValuesMV, (int)length);
                    break;
                }
                case LONG: {
                    long[][] longValuesMV = this.transformToLongValuesMV(projectionBlock);
                    ArrayCopyUtils.copy((long[][])longValuesMV, (double[][])this._doubleValuesMV, (int)length);
                    break;
                }
                case FLOAT: {
                    float[][] floatValuesMV = this.transformToFloatValuesMV(projectionBlock);
                    ArrayCopyUtils.copy((float[][])floatValuesMV, (double[][])this._doubleValuesMV, (int)length);
                    break;
                }
                case STRING: {
                    String[][] stringValuesMV = this.transformToStringValuesMV(projectionBlock);
                    ArrayCopyUtils.copy((String[][])stringValuesMV, (double[][])this._doubleValuesMV, (int)length);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot read MV %s as DOUBLE", resultDataType));
                }
            }
        }
        return this._doubleValuesMV;
    }

    @Override
    public String[][] transformToStringValuesMV(ProjectionBlock projectionBlock) {
        Dictionary dictionary;
        int length = projectionBlock.getNumDocs();
        if (this._stringValuesMV == null) {
            this._stringValuesMV = new String[length][];
        }
        if ((dictionary = this.getDictionary()) != null) {
            int[][] dictIdsMV = this.transformToDictIdsMV(projectionBlock);
            for (int i = 0; i < length; ++i) {
                int[] dictIds = dictIdsMV[i];
                int numValues = dictIds.length;
                String[] stringValues = new String[numValues];
                dictionary.readStringValues(dictIds, numValues, stringValues);
                this._stringValuesMV[i] = stringValues;
            }
        } else {
            FieldSpec.DataType resultDataType = this.getResultMetadata().getDataType();
            switch (resultDataType) {
                case INT: {
                    int[][] intValuesMV = this.transformToIntValuesMV(projectionBlock);
                    ArrayCopyUtils.copy((int[][])intValuesMV, (String[][])this._stringValuesMV, (int)length);
                    break;
                }
                case LONG: {
                    long[][] longValuesMV = this.transformToLongValuesMV(projectionBlock);
                    ArrayCopyUtils.copy((long[][])longValuesMV, (String[][])this._stringValuesMV, (int)length);
                    break;
                }
                case FLOAT: {
                    float[][] floatValuesMV = this.transformToFloatValuesMV(projectionBlock);
                    ArrayCopyUtils.copy((float[][])floatValuesMV, (String[][])this._stringValuesMV, (int)length);
                    break;
                }
                case DOUBLE: {
                    double[][] doubleValuesMV = this.transformToDoubleValuesMV(projectionBlock);
                    ArrayCopyUtils.copy((double[][])doubleValuesMV, (String[][])this._stringValuesMV, (int)length);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cannot read MV %s as STRING", resultDataType));
                }
            }
        }
        return this._stringValuesMV;
    }

    @Override
    public byte[][][] transformToBytesValuesMV(ProjectionBlock projectionBlock) {
        Dictionary dictionary;
        int length = projectionBlock.getNumDocs();
        if (this._bytesValuesMV == null) {
            this._bytesValuesMV = new byte[length][][];
        }
        if ((dictionary = this.getDictionary()) != null) {
            int[][] dictIdsMV = this.transformToDictIdsMV(projectionBlock);
            for (int i = 0; i < length; ++i) {
                int[] dictIds = dictIdsMV[i];
                int numValues = dictIds.length;
                byte[][] bytesValues = new byte[numValues][];
                dictionary.readBytesValues(dictIds, numValues, (byte[][])bytesValues);
                this._bytesValuesMV[i] = bytesValues;
            }
        } else {
            assert (this.getResultMetadata().getDataType().getStoredType() == FieldSpec.DataType.STRING);
            String[][] stringValuesMV = this.transformToStringValuesMV(projectionBlock);
            ArrayCopyUtils.copy((String[][])stringValuesMV, (byte[][][])this._bytesValuesMV, (int)length);
        }
        return this._bytesValuesMV;
    }
}

