/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.streaming;

import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.List;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.core.operator.InstanceResponseOperator;
import org.apache.pinot.core.operator.blocks.InstanceResponseBlock;
import org.apache.pinot.core.operator.combine.BaseCombineOperator;
import org.apache.pinot.core.operator.streaming.StreamingResponseUtils;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.FetchContext;
import org.apache.pinot.segment.spi.IndexSegment;

public class StreamingInstanceResponseOperator
extends InstanceResponseOperator {
    private final StreamObserver<Server.ServerResponse> _streamObserver;

    public StreamingInstanceResponseOperator(BaseCombineOperator<?> combinedOperator, List<IndexSegment> indexSegments, List<FetchContext> fetchContexts, StreamObserver<Server.ServerResponse> streamObserver, QueryContext queryContext) {
        super(combinedOperator, indexSegments, fetchContexts, queryContext);
        this._streamObserver = streamObserver;
    }

    @Override
    protected InstanceResponseBlock getNextBlock() {
        InstanceResponseBlock responseBlock = super.getNextBlock();
        InstanceResponseBlock metadataOnlyResponseBlock = responseBlock.toMetadataOnlyResponseBlock();
        try {
            this._streamObserver.onNext((Object)StreamingResponseUtils.getDataResponse(responseBlock.toDataOnlyDataTable()));
        }
        catch (IOException e) {
            metadataOnlyResponseBlock.addException(QueryException.getException((ProcessingException)QueryException.DATA_TABLE_SERIALIZATION_ERROR, (Throwable)e));
        }
        return metadataOnlyResponseBlock;
    }
}

