/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.common.RowBasedBlockValueFetcher;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.operator.blocks.results.SelectionResultsBlock;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.utils.OrderByComparatorFactory;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RoaringBitmap;

public abstract class LinearSelectionOrderByOperator
extends BaseOperator<SelectionResultsBlock> {
    protected final IndexSegment _indexSegment;
    protected final boolean _nullHandlingEnabled;
    protected final List<ExpressionContext> _expressions;
    protected final List<ExpressionContext> _alreadySorted;
    protected final List<ExpressionContext> _toSort;
    protected final TransformOperator _transformOperator;
    protected final List<OrderByExpressionContext> _orderByExpressions;
    protected final TransformResultMetadata[] _expressionsMetadata;
    protected final int _numRowsToKeep;
    private final Supplier<ListBuilder> _listBuilderSupplier;
    protected boolean _used = false;
    protected Comparator<Object[]> _comparator;

    public LinearSelectionOrderByOperator(IndexSegment indexSegment, QueryContext queryContext, List<ExpressionContext> expressions, TransformOperator transformOperator, int numSortedExpressions) {
        this._indexSegment = indexSegment;
        this._nullHandlingEnabled = queryContext.isNullHandlingEnabled();
        this._expressions = expressions;
        this._transformOperator = transformOperator;
        this._orderByExpressions = queryContext.getOrderByExpressions();
        assert (this._orderByExpressions != null);
        int numOrderByExpressions = this._orderByExpressions.size();
        this._alreadySorted = expressions.subList(0, numSortedExpressions);
        this._toSort = expressions.subList(numSortedExpressions, numOrderByExpressions);
        this._expressionsMetadata = new TransformResultMetadata[this._expressions.size()];
        for (int i = 0; i < this._expressionsMetadata.length; ++i) {
            ExpressionContext expression = this._expressions.get(i);
            this._expressionsMetadata[i] = this._transformOperator.getResultMetadata(expression);
        }
        this._numRowsToKeep = queryContext.getOffset() + queryContext.getLimit();
        if (this._toSort.isEmpty()) {
            this._listBuilderSupplier = () -> new TotallySortedListBuilder(this._numRowsToKeep);
        } else {
            Comparator<Object[]> sortedComparator = OrderByComparatorFactory.getComparator(this._orderByExpressions, this._expressionsMetadata, false, this._nullHandlingEnabled, 0, numSortedExpressions);
            Comparator<Object[]> unsortedComparator = OrderByComparatorFactory.getComparator(this._orderByExpressions, this._expressionsMetadata, true, this._nullHandlingEnabled, numSortedExpressions, numOrderByExpressions);
            this._listBuilderSupplier = () -> new PartiallySortedListBuilder(this._numRowsToKeep, sortedComparator, unsortedComparator);
        }
        this._comparator = OrderByComparatorFactory.getComparator(this._orderByExpressions, this._expressionsMetadata, true, this._nullHandlingEnabled);
    }

    @Override
    public IndexSegment getIndexSegment() {
        return this._indexSegment;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        long numEntriesScannedInFilter = this._transformOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
        int numDocsScanned = this.getNumDocsScanned();
        long numEntriesScannedPostFilter = (long)numDocsScanned * (long)this._transformOperator.getNumColumnsProjected();
        int numTotalDocs = this._indexSegment.getSegmentMetadata().getTotalDocs();
        return new ExecutionStatistics(numDocsScanned, numEntriesScannedInFilter, numEntriesScannedPostFilter, numTotalDocs);
    }

    protected IntFunction<Object[]> fetchBlock(TransformBlock transformBlock, BlockValSet[] blockValSets) {
        int numExpressions = this._expressions.size();
        for (int i = 0; i < numExpressions; ++i) {
            ExpressionContext expression = this._expressions.get(i);
            blockValSets[i] = transformBlock.getBlockValueSet(expression);
        }
        RowBasedBlockValueFetcher blockValueFetcher = new RowBasedBlockValueFetcher(blockValSets);
        if (!this._nullHandlingEnabled) {
            return blockValueFetcher::getRow;
        }
        RoaringBitmap[] nullBitmaps = new RoaringBitmap[numExpressions];
        for (int i = 0; i < numExpressions; ++i) {
            nullBitmaps[i] = blockValSets[i].getNullBitmap();
        }
        return docId -> {
            Object[] row = blockValueFetcher.getRow(docId);
            for (int colId = 0; colId < nullBitmaps.length; ++colId) {
                if (nullBitmaps[colId] == null || !nullBitmaps[colId].contains(docId)) continue;
                row[colId] = null;
            }
            return row;
        };
    }

    protected abstract int getNumDocsScanned();

    protected abstract List<Object[]> fetch(Supplier<ListBuilder> var1);

    @Override
    public List<Operator> getChildOperators() {
        return Collections.singletonList(this._transformOperator);
    }

    protected abstract String getExplainName();

    @Override
    public String toExplainString() {
        StringBuilder sb = new StringBuilder(this.getExplainName());
        sb.append("(sortedList: ");
        this.concatList(sb, this._alreadySorted);
        sb.append(", unsortedList: ");
        this.concatList(sb, this._toSort);
        sb.append(", rest: ");
        this.concatList(sb, this._expressions.subList(this._alreadySorted.size() + this._toSort.size(), this._expressions.size()));
        sb.append(')');
        return sb.toString();
    }

    private void concatList(StringBuilder sb, List<?> list) {
        sb.append('(');
        Iterator<?> it = list.iterator();
        if (it.hasNext()) {
            sb.append(it.next());
            while (it.hasNext()) {
                sb.append(", ").append(it.next());
            }
        }
        sb.append(')');
    }

    @Override
    protected SelectionResultsBlock getNextBlock() {
        Preconditions.checkState((!this._used ? 1 : 0) != 0, (Object)"nextBlock was called more than once");
        this._used = true;
        List<Object[]> list = this.fetch(this._listBuilderSupplier);
        DataSchema dataSchema = this.createDataSchema();
        if (list.size() > this._numRowsToKeep) {
            list = new ArrayList<Object[]>(list.subList(0, this._numRowsToKeep));
        }
        return new SelectionResultsBlock(dataSchema, list, this._comparator);
    }

    protected DataSchema createDataSchema() {
        int i;
        int numExpressions = this._expressions.size();
        String[] columnNames = new String[numExpressions];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numExpressions];
        for (i = 0; i < columnNames.length; ++i) {
            columnNames[i] = this._expressions.get(i).toString();
        }
        for (i = 0; i < numExpressions; ++i) {
            TransformResultMetadata expressionMetadata = this._expressionsMetadata[i];
            columnDataTypes[i] = DataSchema.ColumnDataType.fromDataType((FieldSpec.DataType)expressionMetadata.getDataType(), (boolean)expressionMetadata.isSingleValue());
        }
        return new DataSchema(columnNames, columnDataTypes);
    }

    @VisibleForTesting
    static class PartiallySortedListBuilder
    implements ListBuilder {
        private final ArrayList<Object[]> _sorted;
        private PriorityQueue<Object[]> _lastPartitionQueue;
        private final Comparator<Object[]> _partitionComparator;
        private final Comparator<Object[]> _unsortedComparator;
        private final int _maxNumRows;
        private Object[] _lastPartitionRow;
        private int _numSortedRows;

        public PartiallySortedListBuilder(int maxNumRows, Comparator<Object[]> partitionComparator, Comparator<Object[]> unsortedComparator) {
            this._maxNumRows = maxNumRows;
            this._sorted = new ArrayList(Integer.min(maxNumRows, 10000));
            this._partitionComparator = partitionComparator;
            this._unsortedComparator = unsortedComparator;
        }

        @Override
        public boolean add(Object[] row) {
            boolean newPartition;
            if (this._lastPartitionRow == null) {
                this._lastPartitionRow = row;
                this._sorted.add(row);
                return false;
            }
            int cmp = this._partitionComparator.compare(row, this._lastPartitionRow);
            if (cmp < 0) {
                throw new IllegalArgumentException("Row with docId " + this._sorted.size() + " is not sorted compared to the previous one");
            }
            boolean bl = newPartition = cmp > 0;
            if (this._sorted.size() < this._maxNumRows) {
                if (newPartition) {
                    this._lastPartitionRow = row;
                    this._numSortedRows = this._sorted.size();
                }
                this._sorted.add(row);
                return false;
            }
            assert (this._sorted.size() == this._maxNumRows);
            if (newPartition) {
                return true;
            }
            if (this._lastPartitionQueue == null) {
                int numRowsInPriorityQueue = this._maxNumRows - this._numSortedRows;
                this._lastPartitionQueue = new PriorityQueue<Object[]>(numRowsInPriorityQueue, this._unsortedComparator);
                this._lastPartitionQueue.addAll(this._sorted.subList(this._numSortedRows, this._maxNumRows));
            }
            if (this._unsortedComparator.compare(row, this._lastPartitionQueue.peek()) > 0) {
                this._lastPartitionQueue.poll();
                this._lastPartitionQueue.offer(row);
            }
            return false;
        }

        @Override
        public List<Object[]> build() {
            if (this._lastPartitionQueue != null) {
                assert (this._lastPartitionQueue.size() == this._maxNumRows - this._numSortedRows);
                Iterator<Object[]> lastPartitionIt = this._lastPartitionQueue.iterator();
                for (int i = this._numSortedRows; i < this._maxNumRows; ++i) {
                    this._sorted.set(i, lastPartitionIt.next());
                }
            }
            return this._sorted;
        }
    }

    @VisibleForTesting
    static class TotallySortedListBuilder
    implements ListBuilder {
        private final ArrayList<Object[]> _list;
        private final int _maxNumRows;

        public TotallySortedListBuilder(int maxNumRows) {
            this._maxNumRows = maxNumRows;
            this._list = new ArrayList(Integer.min(maxNumRows, 10000));
        }

        @Override
        public boolean add(Object[] row) {
            this._list.add(row);
            return this._list.size() == this._maxNumRows;
        }

        @Override
        public List<Object[]> build() {
            return this._list;
        }
    }

    protected static interface ListBuilder {
        public boolean add(Object[] var1);

        public List<Object[]> build();
    }
}

