/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.results.AggregationResultsBlock;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.segment.spi.SegmentMetadata;

public class FastFilteredCountOperator
extends BaseOperator<AggregationResultsBlock> {
    private static final String EXPLAIN_NAME = "FAST_FILTERED_COUNT";
    private final BaseFilterOperator _filterOperator;
    private final AggregationFunction[] _aggregationFunctions;
    private final SegmentMetadata _segmentMetadata;
    private long _docsCounted;

    public FastFilteredCountOperator(AggregationFunction[] aggregationFunctions, BaseFilterOperator filterOperator, SegmentMetadata segmentMetadata) {
        this._filterOperator = filterOperator;
        this._segmentMetadata = segmentMetadata;
        this._aggregationFunctions = aggregationFunctions;
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.singletonList(this._filterOperator);
    }

    @Override
    protected AggregationResultsBlock getNextBlock() {
        long count = this._filterOperator.getNumMatchingDocs();
        ArrayList<Object> aggregates = new ArrayList<Object>(1);
        aggregates.add(count);
        this._docsCounted += count;
        return new AggregationResultsBlock(this._aggregationFunctions, aggregates);
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        return new ExecutionStatistics(this._docsCounted, 0L, 0L, this._segmentMetadata.getTotalDocs());
    }
}

