/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter.predicate;

import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.pinot.common.request.context.predicate.BaseInPredicate;
import org.apache.pinot.common.request.context.predicate.InPredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.utils.HashUtil;
import org.apache.pinot.core.operator.filter.predicate.BaseDictionaryBasedPredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.BaseRawValueBasedPredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.PredicateUtils;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;

public class InPredicateEvaluatorFactory {
    private InPredicateEvaluatorFactory() {
    }

    public static BaseDictionaryBasedPredicateEvaluator newDictionaryBasedEvaluator(InPredicate inPredicate, Dictionary dictionary, FieldSpec.DataType dataType) {
        return new DictionaryBasedInPredicateEvaluator(inPredicate, dictionary, dataType);
    }

    public static BaseRawValueBasedPredicateEvaluator newRawValueBasedEvaluator(InPredicate inPredicate, FieldSpec.DataType dataType) {
        switch (dataType) {
            case INT: {
                int[] intValues = inPredicate.getIntValues();
                IntOpenHashSet matchingValues = new IntOpenHashSet(HashUtil.getMinHashSetSize((int)intValues.length));
                for (int value : intValues) {
                    matchingValues.add(value);
                }
                return new IntRawValueBasedInPredicateEvaluator(inPredicate, (IntSet)matchingValues);
            }
            case LONG: {
                long[] longValues = inPredicate.getLongValues();
                LongOpenHashSet matchingValues = new LongOpenHashSet(HashUtil.getMinHashSetSize((int)longValues.length));
                for (long value : longValues) {
                    matchingValues.add(value);
                }
                return new LongRawValueBasedInPredicateEvaluator(inPredicate, (LongSet)matchingValues);
            }
            case FLOAT: {
                float[] floatValues = inPredicate.getFloatValues();
                FloatOpenHashSet matchingValues = new FloatOpenHashSet(HashUtil.getMinHashSetSize((int)floatValues.length));
                for (float value : floatValues) {
                    matchingValues.add(value);
                }
                return new FloatRawValueBasedInPredicateEvaluator(inPredicate, (FloatSet)matchingValues);
            }
            case DOUBLE: {
                double[] doubleValues = inPredicate.getDoubleValues();
                DoubleOpenHashSet matchingValues = new DoubleOpenHashSet(HashUtil.getMinHashSetSize((int)doubleValues.length));
                for (double value : doubleValues) {
                    matchingValues.add(value);
                }
                return new DoubleRawValueBasedInPredicateEvaluator(inPredicate, (DoubleSet)matchingValues);
            }
            case BIG_DECIMAL: {
                BigDecimal[] bigDecimalValues = inPredicate.getBigDecimalValues();
                TreeSet<BigDecimal> matchingValues = new TreeSet<BigDecimal>(Arrays.asList(bigDecimalValues));
                return new BigDecimalRawValueBasedInPredicateEvaluator(inPredicate, matchingValues);
            }
            case BOOLEAN: {
                int[] booleanValues = inPredicate.getBooleanValues();
                IntOpenHashSet matchingValues = new IntOpenHashSet(HashUtil.getMinHashSetSize((int)booleanValues.length));
                for (int value : booleanValues) {
                    matchingValues.add(value);
                }
                return new IntRawValueBasedInPredicateEvaluator(inPredicate, (IntSet)matchingValues);
            }
            case TIMESTAMP: {
                long[] timestampValues = inPredicate.getTimestampValues();
                LongOpenHashSet matchingValues = new LongOpenHashSet(HashUtil.getMinHashSetSize((int)timestampValues.length));
                for (long value : timestampValues) {
                    matchingValues.add(value);
                }
                return new LongRawValueBasedInPredicateEvaluator(inPredicate, (LongSet)matchingValues);
            }
            case STRING: {
                List stringValues = inPredicate.getValues();
                ObjectOpenHashSet matchingValues = new ObjectOpenHashSet(HashUtil.getMinHashSetSize((int)stringValues.size()));
                for (String value : stringValues) {
                    matchingValues.add(value);
                }
                return new StringRawValueBasedInPredicateEvaluator(inPredicate, (Set<String>)matchingValues);
            }
            case BYTES: {
                ByteArray[] bytesValues = inPredicate.getBytesValues();
                ObjectOpenHashSet matchingValues = new ObjectOpenHashSet(HashUtil.getMinHashSetSize((int)bytesValues.length));
                for (ByteArray value : bytesValues) {
                    matchingValues.add(value);
                }
                return new BytesRawValueBasedInPredicateEvaluator(inPredicate, (Set<ByteArray>)matchingValues);
            }
        }
        throw new IllegalStateException("Unsupported data type: " + dataType);
    }

    private static final class BytesRawValueBasedInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final Set<ByteArray> _matchingValues;

        BytesRawValueBasedInPredicateEvaluator(InPredicate inPredicate, Set<ByteArray> matchingValues) {
            super((Predicate)inPredicate);
            this._matchingValues = matchingValues;
        }

        @Override
        public int getNumMatchingItems() {
            return this._matchingValues.size();
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.BYTES;
        }

        @Override
        public boolean applySV(byte[] value) {
            return this._matchingValues.contains(new ByteArray(value));
        }
    }

    private static final class StringRawValueBasedInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final Set<String> _matchingValues;

        StringRawValueBasedInPredicateEvaluator(InPredicate inPredicate, Set<String> matchingValues) {
            super((Predicate)inPredicate);
            this._matchingValues = matchingValues;
        }

        @Override
        public int getNumMatchingItems() {
            return this._matchingValues.size();
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.STRING;
        }

        @Override
        public boolean applySV(String value) {
            return this._matchingValues.contains(value);
        }
    }

    private static final class BigDecimalRawValueBasedInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final TreeSet<BigDecimal> _matchingValues;

        BigDecimalRawValueBasedInPredicateEvaluator(InPredicate inPredicate, TreeSet<BigDecimal> matchingValues) {
            super((Predicate)inPredicate);
            this._matchingValues = matchingValues;
        }

        @Override
        public int getNumMatchingItems() {
            return this._matchingValues.size();
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.BIG_DECIMAL;
        }

        @Override
        public boolean applySV(BigDecimal value) {
            return this._matchingValues.contains(value);
        }
    }

    private static final class DoubleRawValueBasedInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final DoubleSet _matchingValues;

        DoubleRawValueBasedInPredicateEvaluator(InPredicate inPredicate, DoubleSet matchingValues) {
            super((Predicate)inPredicate);
            this._matchingValues = matchingValues;
        }

        @Override
        public int getNumMatchingItems() {
            return this._matchingValues.size();
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.DOUBLE;
        }

        @Override
        public boolean applySV(double value) {
            return this._matchingValues.contains(value);
        }

        @Override
        public int applySV(int limit, int[] docIds, double[] values) {
            int matches = 0;
            for (int i = 0; i < limit; ++i) {
                double value = values[i];
                if (!this.applySV(value)) continue;
                docIds[matches++] = docIds[i];
            }
            return matches;
        }
    }

    private static final class FloatRawValueBasedInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final FloatSet _matchingValues;

        FloatRawValueBasedInPredicateEvaluator(InPredicate inPredicate, FloatSet matchingValues) {
            super((Predicate)inPredicate);
            this._matchingValues = matchingValues;
        }

        @Override
        public int getNumMatchingItems() {
            return this._matchingValues.size();
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.FLOAT;
        }

        @Override
        public boolean applySV(float value) {
            return this._matchingValues.contains(value);
        }

        @Override
        public int applySV(int limit, int[] docIds, float[] values) {
            int matches = 0;
            for (int i = 0; i < limit; ++i) {
                float value = values[i];
                if (!this.applySV(value)) continue;
                docIds[matches++] = docIds[i];
            }
            return matches;
        }
    }

    private static final class LongRawValueBasedInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final LongSet _matchingValues;

        LongRawValueBasedInPredicateEvaluator(InPredicate inPredicate, LongSet matchingValues) {
            super((Predicate)inPredicate);
            this._matchingValues = matchingValues;
        }

        @Override
        public int getNumMatchingItems() {
            return this._matchingValues.size();
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.LONG;
        }

        @Override
        public boolean applySV(long value) {
            return this._matchingValues.contains(value);
        }

        @Override
        public int applySV(int limit, int[] docIds, long[] values) {
            int matches = 0;
            for (int i = 0; i < limit; ++i) {
                long value = values[i];
                if (!this.applySV(value)) continue;
                docIds[matches++] = docIds[i];
            }
            return matches;
        }
    }

    private static final class IntRawValueBasedInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final IntSet _matchingValues;

        IntRawValueBasedInPredicateEvaluator(InPredicate inPredicate, IntSet matchingValues) {
            super((Predicate)inPredicate);
            this._matchingValues = matchingValues;
        }

        @Override
        public int getNumMatchingItems() {
            return this._matchingValues.size();
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.INT;
        }

        @Override
        public boolean applySV(int value) {
            return this._matchingValues.contains(value);
        }

        @Override
        public int applySV(int limit, int[] docIds, int[] values) {
            int matches = 0;
            for (int i = 0; i < limit; ++i) {
                int value = values[i];
                if (!this.applySV(value)) continue;
                docIds[matches++] = docIds[i];
            }
            return matches;
        }
    }

    private static final class DictionaryBasedInPredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        final IntSet _matchingDictIdSet;
        final int _numMatchingDictIds;
        int[] _matchingDictIds;

        DictionaryBasedInPredicateEvaluator(InPredicate inPredicate, Dictionary dictionary, FieldSpec.DataType dataType) {
            super((Predicate)inPredicate);
            this._matchingDictIdSet = PredicateUtils.getDictIdSet((BaseInPredicate)inPredicate, dictionary, dataType);
            this._numMatchingDictIds = this._matchingDictIdSet.size();
            if (this._numMatchingDictIds == 0) {
                this._alwaysFalse = true;
            } else if (dictionary.length() == this._numMatchingDictIds) {
                this._alwaysTrue = true;
            }
        }

        @Override
        public boolean applySV(int dictId) {
            return this._matchingDictIdSet.contains(dictId);
        }

        @Override
        public int getNumMatchingDictIds() {
            return this._numMatchingDictIds;
        }

        @Override
        public int getNumMatchingItems() {
            return this.getNumMatchingDictIds();
        }

        @Override
        public int[] getMatchingDictIds() {
            if (this._matchingDictIds == null) {
                this._matchingDictIds = this._matchingDictIdSet.toIntArray();
            }
            return this._matchingDictIds;
        }

        @Override
        public int applySV(int limit, int[] docIds, int[] values) {
            int matches = 0;
            for (int i = 0; i < limit; ++i) {
                int value = values[i];
                if (!this.applySV(value)) continue;
                docIds[matches++] = docIds[i];
            }
            return matches;
        }
    }
}

