/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.predicate.EqPredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.dociditerators.ScanBasedDocIdIterator;
import org.apache.pinot.core.operator.docidsets.BitmapDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.ExpressionFilterOperator;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.local.utils.GeometrySerializer;
import org.apache.pinot.segment.local.utils.H3Utils;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.index.reader.H3IndexReader;
import org.apache.pinot.spi.utils.BooleanUtils;
import org.apache.pinot.spi.utils.BytesUtils;
import org.locationtech.jts.geom.Geometry;
import org.roaringbitmap.buffer.BufferFastAggregation;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class H3InclusionIndexFilterOperator
extends BaseFilterOperator {
    private static final String EXPLAIN_NAME = "INCLUSION_FILTER_H3_INDEX";
    private static final String LITERAL_H3_CELLS_CACHE_NAME = "st_contain_literal_h3_cells";
    private final IndexSegment _segment;
    private final Predicate _predicate;
    private final int _numDocs;
    private final H3IndexReader _h3IndexReader;
    private final Geometry _geometry;
    private final boolean _isPositiveCheck;
    private final QueryContext _queryContext;

    public H3InclusionIndexFilterOperator(IndexSegment segment, Predicate predicate, QueryContext queryContext, int numDocs) {
        this._segment = segment;
        this._predicate = predicate;
        this._numDocs = numDocs;
        this._queryContext = queryContext;
        List arguments = predicate.getLhs().getFunction().getArguments();
        EqPredicate eqPredicate = (EqPredicate)predicate;
        this._isPositiveCheck = BooleanUtils.toBoolean((String)eqPredicate.getValue());
        if (((ExpressionContext)arguments.get(0)).getType() == ExpressionContext.Type.IDENTIFIER) {
            this._h3IndexReader = segment.getDataSource(((ExpressionContext)arguments.get(0)).getIdentifier()).getH3Index();
            this._geometry = GeometrySerializer.deserialize((byte[])BytesUtils.toBytes((String)((ExpressionContext)arguments.get(1)).getLiteralString()));
        } else {
            this._h3IndexReader = segment.getDataSource(((ExpressionContext)arguments.get(1)).getIdentifier()).getH3Index();
            this._geometry = GeometrySerializer.deserialize((byte[])BytesUtils.toBytes((String)((ExpressionContext)arguments.get(0)).getLiteralString()));
        }
        assert (this._h3IndexReader != null) : "the column must have H3 index setup.";
    }

    @Override
    protected FilterBlock getNextBlock() {
        Pair fullCoverAndPotentialCoverCells = this._queryContext.getOrComputeSharedValue(Pair.class, LITERAL_H3_CELLS_CACHE_NAME, k -> H3Utils.coverGeometryInH3((Geometry)this._geometry, (int)this._h3IndexReader.getH3IndexResolution().getLowestResolution()));
        LongSet fullyCoverH3Cells = (LongSet)fullCoverAndPotentialCoverCells.getLeft();
        LongSet potentialCoverH3Cells = (LongSet)fullCoverAndPotentialCoverCells.getRight();
        int i = 0;
        ImmutableRoaringBitmap[] fullMatchDocIds = new ImmutableRoaringBitmap[fullyCoverH3Cells.size()];
        LongIterator fullyCoverH3CellsIterator = fullyCoverH3Cells.iterator();
        while (fullyCoverH3CellsIterator.hasNext()) {
            fullMatchDocIds[i++] = this._h3IndexReader.getDocIds(fullyCoverH3CellsIterator.nextLong());
        }
        MutableRoaringBitmap fullMatch = BufferFastAggregation.or((ImmutableRoaringBitmap[])fullMatchDocIds);
        i = 0;
        potentialCoverH3Cells.removeAll((LongCollection)fullyCoverH3Cells);
        ImmutableRoaringBitmap[] potentialNotMatchDocIds = new ImmutableRoaringBitmap[potentialCoverH3Cells.size()];
        LongIterator potentialMatchH3CellsIterator = potentialCoverH3Cells.iterator();
        while (potentialMatchH3CellsIterator.hasNext()) {
            potentialNotMatchDocIds[i++] = this._h3IndexReader.getDocIds(potentialMatchH3CellsIterator.nextLong());
        }
        MutableRoaringBitmap potentialMatch = BufferFastAggregation.or((ImmutableRoaringBitmap[])potentialNotMatchDocIds);
        if (this._isPositiveCheck) {
            return this.getFilterBlock(fullMatch, potentialMatch);
        }
        MutableRoaringBitmap fullNotMatch = potentialMatch.clone();
        fullNotMatch.flip(0L, (long)this._numDocs);
        fullNotMatch.andNot((ImmutableRoaringBitmap)fullMatch);
        return this.getFilterBlock(fullNotMatch, potentialMatch);
    }

    private FilterBlock getFilterBlock(MutableRoaringBitmap fullMatchDocIds, MutableRoaringBitmap partialMatchDocIds) {
        ExpressionFilterOperator expressionFilterOperator = new ExpressionFilterOperator(this._segment, this._predicate, this._numDocs);
        final ScanBasedDocIdIterator docIdIterator = (ScanBasedDocIdIterator)expressionFilterOperator.getNextBlock().getBlockDocIdSet().iterator();
        MutableRoaringBitmap result = docIdIterator.applyAnd((ImmutableRoaringBitmap)partialMatchDocIds);
        result.or((ImmutableRoaringBitmap)fullMatchDocIds);
        return new FilterBlock(new BitmapDocIdSet((ImmutableRoaringBitmap)result, this._numDocs){

            @Override
            public long getNumEntriesScannedInFilter() {
                return docIdIterator.getNumEntriesScanned();
            }
        });
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.emptyList();
    }

    @Override
    public String toExplainString() {
        StringBuilder stringBuilder = new StringBuilder(EXPLAIN_NAME).append("(inclusionIndex:h3_index");
        stringBuilder.append(",operator:").append(this._predicate.getType());
        stringBuilder.append(",predicate:").append(this._predicate.toString());
        return stringBuilder.append(')').toString();
    }
}

