/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.docidsets.AndDocIdSet;
import org.apache.pinot.core.operator.docidsets.FilterBlockDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.spi.trace.Tracing;

public class CombinedFilterOperator
extends BaseFilterOperator {
    private static final String EXPLAIN_NAME = "FILTER_COMBINED";
    private final BaseFilterOperator _mainFilterOperator;
    private final BaseFilterOperator _subFilterOperator;
    private final Map<String, String> _queryOptions;

    public CombinedFilterOperator(BaseFilterOperator mainFilterOperator, BaseFilterOperator subFilterOperator, Map<String, String> queryOptions) {
        this._mainFilterOperator = mainFilterOperator;
        this._subFilterOperator = subFilterOperator;
        this._queryOptions = queryOptions;
    }

    @Override
    public List<Operator> getChildOperators() {
        return Arrays.asList(this._mainFilterOperator, this._subFilterOperator);
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    protected FilterBlock getNextBlock() {
        Tracing.activeRecording().setNumChildren(2);
        FilterBlockDocIdSet mainFilterDocIdSet = ((FilterBlock)this._mainFilterOperator.nextBlock()).getNonScanFilterBLockDocIdSet();
        FilterBlockDocIdSet subFilterDocIdSet = ((FilterBlock)this._subFilterOperator.nextBlock()).getBlockDocIdSet();
        return new FilterBlock(new AndDocIdSet(Arrays.asList(mainFilterDocIdSet, subFilterDocIdSet), this._queryOptions));
    }
}

